/*
 * Decompiled with CFR 0.152.
 */
package ocpp.v201;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum FirmwareStatusEnum {
    DOWNLOADED("Downloaded"),
    DOWNLOAD_FAILED("DownloadFailed"),
    DOWNLOADING("Downloading"),
    DOWNLOAD_SCHEDULED("DownloadScheduled"),
    DOWNLOAD_PAUSED("DownloadPaused"),
    IDLE("Idle"),
    INSTALLATION_FAILED("InstallationFailed"),
    INSTALLING("Installing"),
    INSTALLED("Installed"),
    INSTALL_REBOOTING("InstallRebooting"),
    INSTALL_SCHEDULED("InstallScheduled"),
    INSTALL_VERIFICATION_FAILED("InstallVerificationFailed"),
    INVALID_SIGNATURE("InvalidSignature"),
    SIGNATURE_VERIFIED("SignatureVerified");

    private final String value;
    private static final Map<String, FirmwareStatusEnum> CONSTANTS;

    private FirmwareStatusEnum(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static FirmwareStatusEnum fromValue(String value) {
        FirmwareStatusEnum constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, FirmwareStatusEnum>();
        for (FirmwareStatusEnum c : FirmwareStatusEnum.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

