/*
 * Decompiled with CFR 0.152.
 */
package ocpp.v201;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import ocpp.v201.AttributeEnum;
import ocpp.v201.Component;
import ocpp.v201.CustomData;
import ocpp.v201.Variable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"customData", "attributeType", "component", "variable"})
public class GetVariableData
implements Serializable {
    @JsonProperty(value="customData")
    @JsonPropertyDescription(value="This class does not get 'AdditionalProperties = false' in the schema generation, so it can be extended with arbitrary JSON properties to allow adding custom data.")
    private CustomData customData;
    @JsonProperty(value="attributeType")
    @JsonPropertyDescription(value="Attribute type for which value is requested. When absent, default Actual is assumed.\r\n")
    private AttributeEnum attributeType = AttributeEnum.fromValue("Actual");
    @JsonProperty(value="component")
    @JsonPropertyDescription(value="A physical or logical component\r\n")
    private Component component;
    @JsonProperty(value="variable")
    @JsonPropertyDescription(value="Reference key to a component-variable.\r\n")
    private Variable variable;
    private static final long serialVersionUID = -5190914829398864144L;

    public GetVariableData() {
    }

    public GetVariableData(Component component, Variable variable) {
        this.component = component;
        this.variable = variable;
    }

    @JsonProperty(value="customData")
    public CustomData getCustomData() {
        return this.customData;
    }

    @JsonProperty(value="customData")
    public void setCustomData(CustomData customData) {
        this.customData = customData;
    }

    public GetVariableData withCustomData(CustomData customData) {
        this.customData = customData;
        return this;
    }

    @JsonProperty(value="attributeType")
    public AttributeEnum getAttributeType() {
        return this.attributeType;
    }

    @JsonProperty(value="attributeType")
    public void setAttributeType(AttributeEnum attributeType) {
        this.attributeType = attributeType;
    }

    public GetVariableData withAttributeType(AttributeEnum attributeType) {
        this.attributeType = attributeType;
        return this;
    }

    @JsonProperty(value="component")
    public Component getComponent() {
        return this.component;
    }

    @JsonProperty(value="component")
    public void setComponent(Component component) {
        this.component = component;
    }

    public GetVariableData withComponent(Component component) {
        this.component = component;
        return this;
    }

    @JsonProperty(value="variable")
    public Variable getVariable() {
        return this.variable;
    }

    @JsonProperty(value="variable")
    public void setVariable(Variable variable) {
        this.variable = variable;
    }

    public GetVariableData withVariable(Variable variable) {
        this.variable = variable;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(GetVariableData.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("customData");
        sb.append('=');
        sb.append(this.customData == null ? "<null>" : this.customData);
        sb.append(',');
        sb.append("attributeType");
        sb.append('=');
        sb.append(this.attributeType == null ? "<null>" : this.attributeType);
        sb.append(',');
        sb.append("component");
        sb.append('=');
        sb.append(this.component == null ? "<null>" : this.component);
        sb.append(',');
        sb.append("variable");
        sb.append('=');
        sb.append(this.variable == null ? "<null>" : this.variable);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.variable == null ? 0 : this.variable.hashCode());
        result = result * 31 + (this.customData == null ? 0 : this.customData.hashCode());
        result = result * 31 + (this.component == null ? 0 : this.component.hashCode());
        result = result * 31 + (this.attributeType == null ? 0 : this.attributeType.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof GetVariableData)) {
            return false;
        }
        GetVariableData rhs = (GetVariableData)other;
        return (this.variable == rhs.variable || this.variable != null && this.variable.equals(rhs.variable)) && (this.customData == rhs.customData || this.customData != null && this.customData.equals(rhs.customData)) && (this.component == rhs.component || this.component != null && this.component.equals(rhs.component)) && (this.attributeType == rhs.attributeType || this.attributeType != null && this.attributeType.equals((Object)rhs.attributeType));
    }
}

