/*
 * Decompiled with CFR 0.152.
 */
package ocpp.v201;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import java.time.Instant;
import ocpp.v201.CustomData;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"customData", "remoteLocation", "oldestTimestamp", "latestTimestamp"})
public class LogParameters
implements Serializable {
    @JsonProperty(value="customData")
    @JsonPropertyDescription(value="This class does not get 'AdditionalProperties = false' in the schema generation, so it can be extended with arbitrary JSON properties to allow adding custom data.")
    private CustomData customData;
    @JsonProperty(value="remoteLocation")
    @JsonPropertyDescription(value="Log. Remote_ Location. URI\r\nurn:x-enexis:ecdm:uid:1:569484\r\nThe URL of the location at the remote system where the log should be stored.\r\n")
    private String remoteLocation;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss[.SSS]XXX", timezone="UTC")
    @JsonProperty(value="oldestTimestamp")
    @JsonPropertyDescription(value="Log. Oldest_ Timestamp. Date_ Time\r\nurn:x-enexis:ecdm:uid:1:569477\r\nThis contains the date and time of the oldest logging information to include in the diagnostics.\r\n")
    private Instant oldestTimestamp;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss[.SSS]XXX", timezone="UTC")
    @JsonProperty(value="latestTimestamp")
    @JsonPropertyDescription(value="Log. Latest_ Timestamp. Date_ Time\r\nurn:x-enexis:ecdm:uid:1:569482\r\nThis contains the date and time of the latest logging information to include in the diagnostics.\r\n")
    private Instant latestTimestamp;
    private static final long serialVersionUID = 3984270186661038910L;

    public LogParameters() {
    }

    public LogParameters(String remoteLocation) {
        this.remoteLocation = remoteLocation;
    }

    @JsonProperty(value="customData")
    public CustomData getCustomData() {
        return this.customData;
    }

    @JsonProperty(value="customData")
    public void setCustomData(CustomData customData) {
        this.customData = customData;
    }

    public LogParameters withCustomData(CustomData customData) {
        this.customData = customData;
        return this;
    }

    @JsonProperty(value="remoteLocation")
    public String getRemoteLocation() {
        return this.remoteLocation;
    }

    @JsonProperty(value="remoteLocation")
    public void setRemoteLocation(String remoteLocation) {
        this.remoteLocation = remoteLocation;
    }

    public LogParameters withRemoteLocation(String remoteLocation) {
        this.remoteLocation = remoteLocation;
        return this;
    }

    @JsonProperty(value="oldestTimestamp")
    public Instant getOldestTimestamp() {
        return this.oldestTimestamp;
    }

    @JsonProperty(value="oldestTimestamp")
    public void setOldestTimestamp(Instant oldestTimestamp) {
        this.oldestTimestamp = oldestTimestamp;
    }

    public LogParameters withOldestTimestamp(Instant oldestTimestamp) {
        this.oldestTimestamp = oldestTimestamp;
        return this;
    }

    @JsonProperty(value="latestTimestamp")
    public Instant getLatestTimestamp() {
        return this.latestTimestamp;
    }

    @JsonProperty(value="latestTimestamp")
    public void setLatestTimestamp(Instant latestTimestamp) {
        this.latestTimestamp = latestTimestamp;
    }

    public LogParameters withLatestTimestamp(Instant latestTimestamp) {
        this.latestTimestamp = latestTimestamp;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(LogParameters.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("customData");
        sb.append('=');
        sb.append(this.customData == null ? "<null>" : this.customData);
        sb.append(',');
        sb.append("remoteLocation");
        sb.append('=');
        sb.append(this.remoteLocation == null ? "<null>" : this.remoteLocation);
        sb.append(',');
        sb.append("oldestTimestamp");
        sb.append('=');
        sb.append(this.oldestTimestamp == null ? "<null>" : this.oldestTimestamp);
        sb.append(',');
        sb.append("latestTimestamp");
        sb.append('=');
        sb.append(this.latestTimestamp == null ? "<null>" : this.latestTimestamp);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.remoteLocation == null ? 0 : this.remoteLocation.hashCode());
        result = result * 31 + (this.oldestTimestamp == null ? 0 : this.oldestTimestamp.hashCode());
        result = result * 31 + (this.latestTimestamp == null ? 0 : this.latestTimestamp.hashCode());
        result = result * 31 + (this.customData == null ? 0 : this.customData.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof LogParameters)) {
            return false;
        }
        LogParameters rhs = (LogParameters)other;
        return (this.remoteLocation == rhs.remoteLocation || this.remoteLocation != null && this.remoteLocation.equals(rhs.remoteLocation)) && (this.oldestTimestamp == rhs.oldestTimestamp || this.oldestTimestamp != null && this.oldestTimestamp.equals(rhs.oldestTimestamp)) && (this.latestTimestamp == rhs.latestTimestamp || this.latestTimestamp != null && this.latestTimestamp.equals(rhs.latestTimestamp)) && (this.customData == rhs.customData || this.customData != null && this.customData.equals(rhs.customData));
    }
}

