/*
 * Decompiled with CFR 0.152.
 */
package ocpp.v201;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import java.time.Instant;
import java.util.List;
import ocpp.v201.CustomData;
import ocpp.v201.SampledValue;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"customData", "sampledValue", "timestamp"})
public class MeterValue
implements Serializable {
    @JsonProperty(value="customData")
    @JsonPropertyDescription(value="This class does not get 'AdditionalProperties = false' in the schema generation, so it can be extended with arbitrary JSON properties to allow adding custom data.")
    private CustomData customData;
    @JsonProperty(value="sampledValue")
    private List<SampledValue> sampledValue;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss[.SSS]XXX", timezone="UTC")
    @JsonProperty(value="timestamp")
    @JsonPropertyDescription(value="Meter_ Value. Timestamp. Date_ Time\r\nurn:x-oca:ocpp:uid:1:569259\r\nTimestamp for measured value(s).\r\n")
    private Instant timestamp;
    private static final long serialVersionUID = 4098645661969345848L;

    public MeterValue() {
    }

    public MeterValue(List<SampledValue> sampledValue, Instant timestamp) {
        this.sampledValue = sampledValue;
        this.timestamp = timestamp;
    }

    @JsonProperty(value="customData")
    public CustomData getCustomData() {
        return this.customData;
    }

    @JsonProperty(value="customData")
    public void setCustomData(CustomData customData) {
        this.customData = customData;
    }

    public MeterValue withCustomData(CustomData customData) {
        this.customData = customData;
        return this;
    }

    @JsonProperty(value="sampledValue")
    public List<SampledValue> getSampledValue() {
        return this.sampledValue;
    }

    @JsonProperty(value="sampledValue")
    public void setSampledValue(List<SampledValue> sampledValue) {
        this.sampledValue = sampledValue;
    }

    public MeterValue withSampledValue(List<SampledValue> sampledValue) {
        this.sampledValue = sampledValue;
        return this;
    }

    @JsonProperty(value="timestamp")
    public Instant getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="timestamp")
    public void setTimestamp(Instant timestamp) {
        this.timestamp = timestamp;
    }

    public MeterValue withTimestamp(Instant timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(MeterValue.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("customData");
        sb.append('=');
        sb.append(this.customData == null ? "<null>" : this.customData);
        sb.append(',');
        sb.append("sampledValue");
        sb.append('=');
        sb.append(this.sampledValue == null ? "<null>" : this.sampledValue);
        sb.append(',');
        sb.append("timestamp");
        sb.append('=');
        sb.append(this.timestamp == null ? "<null>" : this.timestamp);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.customData == null ? 0 : this.customData.hashCode());
        result = result * 31 + (this.sampledValue == null ? 0 : this.sampledValue.hashCode());
        result = result * 31 + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof MeterValue)) {
            return false;
        }
        MeterValue rhs = (MeterValue)other;
        return (this.customData == rhs.customData || this.customData != null && this.customData.equals(rhs.customData)) && (this.sampledValue == rhs.sampledValue || this.sampledValue != null && this.sampledValue.equals(rhs.sampledValue)) && (this.timestamp == rhs.timestamp || this.timestamp != null && this.timestamp.equals(rhs.timestamp));
    }
}

