/*
 * Decompiled with CFR 0.152.
 */
package ocpp.v201;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum MonitorEnum {
    UPPER_THRESHOLD("UpperThreshold"),
    LOWER_THRESHOLD("LowerThreshold"),
    DELTA("Delta"),
    PERIODIC("Periodic"),
    PERIODIC_CLOCK_ALIGNED("PeriodicClockAligned");

    private final String value;
    private static final Map<String, MonitorEnum> CONSTANTS;

    private MonitorEnum(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static MonitorEnum fromValue(String value) {
        MonitorEnum constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, MonitorEnum>();
        for (MonitorEnum c : MonitorEnum.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

