/*
 * Decompiled with CFR 0.152.
 */
package ocpp.v201;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import ocpp.v201.CustomData;
import ocpp.v201.RequestStartStopStatusEnum;
import ocpp.v201.StatusInfo;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"customData", "status", "statusInfo", "transactionId"})
public class RequestStartTransactionResponse
implements Serializable {
    @JsonProperty(value="customData")
    @JsonPropertyDescription(value="This class does not get 'AdditionalProperties = false' in the schema generation, so it can be extended with arbitrary JSON properties to allow adding custom data.")
    private CustomData customData;
    @JsonProperty(value="status")
    @JsonPropertyDescription(value="Status indicating whether the Charging Station accepts the request to start a transaction.\r\n")
    private RequestStartStopStatusEnum status;
    @JsonProperty(value="statusInfo")
    @JsonPropertyDescription(value="Element providing more information about the status.\r\n")
    private StatusInfo statusInfo;
    @JsonProperty(value="transactionId")
    @JsonPropertyDescription(value="When the transaction was already started by the Charging Station before the RequestStartTransactionRequest was received, for example: cable plugged in first. This contains the transactionId of the already started transaction.\r\n")
    private String transactionId;
    private static final long serialVersionUID = -5640646405471584095L;

    public RequestStartTransactionResponse() {
    }

    public RequestStartTransactionResponse(RequestStartStopStatusEnum status) {
        this.status = status;
    }

    @JsonProperty(value="customData")
    public CustomData getCustomData() {
        return this.customData;
    }

    @JsonProperty(value="customData")
    public void setCustomData(CustomData customData) {
        this.customData = customData;
    }

    public RequestStartTransactionResponse withCustomData(CustomData customData) {
        this.customData = customData;
        return this;
    }

    @JsonProperty(value="status")
    public RequestStartStopStatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    public void setStatus(RequestStartStopStatusEnum status) {
        this.status = status;
    }

    public RequestStartTransactionResponse withStatus(RequestStartStopStatusEnum status) {
        this.status = status;
        return this;
    }

    @JsonProperty(value="statusInfo")
    public StatusInfo getStatusInfo() {
        return this.statusInfo;
    }

    @JsonProperty(value="statusInfo")
    public void setStatusInfo(StatusInfo statusInfo) {
        this.statusInfo = statusInfo;
    }

    public RequestStartTransactionResponse withStatusInfo(StatusInfo statusInfo) {
        this.statusInfo = statusInfo;
        return this;
    }

    @JsonProperty(value="transactionId")
    public String getTransactionId() {
        return this.transactionId;
    }

    @JsonProperty(value="transactionId")
    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public RequestStartTransactionResponse withTransactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(RequestStartTransactionResponse.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("customData");
        sb.append('=');
        sb.append(this.customData == null ? "<null>" : this.customData);
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(this.status == null ? "<null>" : this.status);
        sb.append(',');
        sb.append("statusInfo");
        sb.append('=');
        sb.append(this.statusInfo == null ? "<null>" : this.statusInfo);
        sb.append(',');
        sb.append("transactionId");
        sb.append('=');
        sb.append(this.transactionId == null ? "<null>" : this.transactionId);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.customData == null ? 0 : this.customData.hashCode());
        result = result * 31 + (this.statusInfo == null ? 0 : this.statusInfo.hashCode());
        result = result * 31 + (this.transactionId == null ? 0 : this.transactionId.hashCode());
        result = result * 31 + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof RequestStartTransactionResponse)) {
            return false;
        }
        RequestStartTransactionResponse rhs = (RequestStartTransactionResponse)other;
        return (this.customData == rhs.customData || this.customData != null && this.customData.equals(rhs.customData)) && (this.statusInfo == rhs.statusInfo || this.statusInfo != null && this.statusInfo.equals(rhs.statusInfo)) && (this.transactionId == rhs.transactionId || this.transactionId != null && this.transactionId.equals(rhs.transactionId)) && (this.status == rhs.status || this.status != null && this.status.equals((Object)rhs.status));
    }
}

