/*
 * Decompiled with CFR 0.152.
 */
package ocpp.v201;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import java.time.Instant;
import ocpp.v201.ConnectorEnum;
import ocpp.v201.CustomData;
import ocpp.v201.IdToken;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"customData", "id", "expiryDateTime", "connectorType", "idToken", "evseId", "groupIdToken"})
public class ReserveNowRequest
implements Serializable {
    @JsonProperty(value="customData")
    @JsonPropertyDescription(value="This class does not get 'AdditionalProperties = false' in the schema generation, so it can be extended with arbitrary JSON properties to allow adding custom data.")
    private CustomData customData;
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="Id of reservation.\r\n")
    private Integer id;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss[.SSS]XXX", timezone="UTC")
    @JsonProperty(value="expiryDateTime")
    @JsonPropertyDescription(value="Date and time at which the reservation expires.\r\n")
    private Instant expiryDateTime;
    @JsonProperty(value="connectorType")
    @JsonPropertyDescription(value="This field specifies the connector type.\r\n")
    private ConnectorEnum connectorType;
    @JsonProperty(value="idToken")
    @JsonPropertyDescription(value="Contains a case insensitive identifier to use for the authorization and the type of authorization to support multiple forms of identifiers.\r\n")
    private IdToken idToken;
    @JsonProperty(value="evseId")
    @JsonPropertyDescription(value="This contains ID of the evse to be reserved.\r\n")
    private Integer evseId;
    @JsonProperty(value="groupIdToken")
    @JsonPropertyDescription(value="Contains a case insensitive identifier to use for the authorization and the type of authorization to support multiple forms of identifiers.\r\n")
    private IdToken groupIdToken;
    private static final long serialVersionUID = 3981278329784208638L;

    public ReserveNowRequest() {
    }

    public ReserveNowRequest(Integer id, Instant expiryDateTime, IdToken idToken) {
        this.id = id;
        this.expiryDateTime = expiryDateTime;
        this.idToken = idToken;
    }

    @JsonProperty(value="customData")
    public CustomData getCustomData() {
        return this.customData;
    }

    @JsonProperty(value="customData")
    public void setCustomData(CustomData customData) {
        this.customData = customData;
    }

    public ReserveNowRequest withCustomData(CustomData customData) {
        this.customData = customData;
        return this;
    }

    @JsonProperty(value="id")
    public Integer getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(Integer id) {
        this.id = id;
    }

    public ReserveNowRequest withId(Integer id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="expiryDateTime")
    public Instant getExpiryDateTime() {
        return this.expiryDateTime;
    }

    @JsonProperty(value="expiryDateTime")
    public void setExpiryDateTime(Instant expiryDateTime) {
        this.expiryDateTime = expiryDateTime;
    }

    public ReserveNowRequest withExpiryDateTime(Instant expiryDateTime) {
        this.expiryDateTime = expiryDateTime;
        return this;
    }

    @JsonProperty(value="connectorType")
    public ConnectorEnum getConnectorType() {
        return this.connectorType;
    }

    @JsonProperty(value="connectorType")
    public void setConnectorType(ConnectorEnum connectorType) {
        this.connectorType = connectorType;
    }

    public ReserveNowRequest withConnectorType(ConnectorEnum connectorType) {
        this.connectorType = connectorType;
        return this;
    }

    @JsonProperty(value="idToken")
    public IdToken getIdToken() {
        return this.idToken;
    }

    @JsonProperty(value="idToken")
    public void setIdToken(IdToken idToken) {
        this.idToken = idToken;
    }

    public ReserveNowRequest withIdToken(IdToken idToken) {
        this.idToken = idToken;
        return this;
    }

    @JsonProperty(value="evseId")
    public Integer getEvseId() {
        return this.evseId;
    }

    @JsonProperty(value="evseId")
    public void setEvseId(Integer evseId) {
        this.evseId = evseId;
    }

    public ReserveNowRequest withEvseId(Integer evseId) {
        this.evseId = evseId;
        return this;
    }

    @JsonProperty(value="groupIdToken")
    public IdToken getGroupIdToken() {
        return this.groupIdToken;
    }

    @JsonProperty(value="groupIdToken")
    public void setGroupIdToken(IdToken groupIdToken) {
        this.groupIdToken = groupIdToken;
    }

    public ReserveNowRequest withGroupIdToken(IdToken groupIdToken) {
        this.groupIdToken = groupIdToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ReserveNowRequest.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("customData");
        sb.append('=');
        sb.append(this.customData == null ? "<null>" : this.customData);
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(this.id == null ? "<null>" : this.id);
        sb.append(',');
        sb.append("expiryDateTime");
        sb.append('=');
        sb.append(this.expiryDateTime == null ? "<null>" : this.expiryDateTime);
        sb.append(',');
        sb.append("connectorType");
        sb.append('=');
        sb.append(this.connectorType == null ? "<null>" : this.connectorType);
        sb.append(',');
        sb.append("idToken");
        sb.append('=');
        sb.append(this.idToken == null ? "<null>" : this.idToken);
        sb.append(',');
        sb.append("evseId");
        sb.append('=');
        sb.append(this.evseId == null ? "<null>" : this.evseId);
        sb.append(',');
        sb.append("groupIdToken");
        sb.append('=');
        sb.append(this.groupIdToken == null ? "<null>" : this.groupIdToken);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.evseId == null ? 0 : this.evseId.hashCode());
        result = result * 31 + (this.connectorType == null ? 0 : this.connectorType.hashCode());
        result = result * 31 + (this.idToken == null ? 0 : this.idToken.hashCode());
        result = result * 31 + (this.customData == null ? 0 : this.customData.hashCode());
        result = result * 31 + (this.id == null ? 0 : this.id.hashCode());
        result = result * 31 + (this.expiryDateTime == null ? 0 : this.expiryDateTime.hashCode());
        result = result * 31 + (this.groupIdToken == null ? 0 : this.groupIdToken.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ReserveNowRequest)) {
            return false;
        }
        ReserveNowRequest rhs = (ReserveNowRequest)other;
        return (this.evseId == rhs.evseId || this.evseId != null && this.evseId.equals(rhs.evseId)) && (this.connectorType == rhs.connectorType || this.connectorType != null && this.connectorType.equals((Object)rhs.connectorType)) && (this.idToken == rhs.idToken || this.idToken != null && this.idToken.equals(rhs.idToken)) && (this.customData == rhs.customData || this.customData != null && this.customData.equals(rhs.customData)) && (this.id == rhs.id || this.id != null && this.id.equals(rhs.id)) && (this.expiryDateTime == rhs.expiryDateTime || this.expiryDateTime != null && this.expiryDateTime.equals(rhs.expiryDateTime)) && (this.groupIdToken == rhs.groupIdToken || this.groupIdToken != null && this.groupIdToken.equals(rhs.groupIdToken));
    }
}

