/*
 * Decompiled with CFR 0.152.
 */
package ocpp.v201;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import java.time.Instant;
import ocpp.v201.CustomData;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"customData", "type", "timestamp", "techInfo"})
public class SecurityEventNotificationRequest
implements Serializable {
    @JsonProperty(value="customData")
    @JsonPropertyDescription(value="This class does not get 'AdditionalProperties = false' in the schema generation, so it can be extended with arbitrary JSON properties to allow adding custom data.")
    private CustomData customData;
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Type of the security event. This value should be taken from the Security events list.\r\n")
    private String type;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss[.SSS]XXX", timezone="UTC")
    @JsonProperty(value="timestamp")
    @JsonPropertyDescription(value="Date and time at which the event occurred.\r\n")
    private Instant timestamp;
    @JsonProperty(value="techInfo")
    @JsonPropertyDescription(value="Additional information about the occurred security event.\r\n")
    private String techInfo;
    private static final long serialVersionUID = -1493652008214814677L;

    public SecurityEventNotificationRequest() {
    }

    public SecurityEventNotificationRequest(String type, Instant timestamp) {
        this.type = type;
        this.timestamp = timestamp;
    }

    @JsonProperty(value="customData")
    public CustomData getCustomData() {
        return this.customData;
    }

    @JsonProperty(value="customData")
    public void setCustomData(CustomData customData) {
        this.customData = customData;
    }

    public SecurityEventNotificationRequest withCustomData(CustomData customData) {
        this.customData = customData;
        return this;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(String type) {
        this.type = type;
    }

    public SecurityEventNotificationRequest withType(String type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="timestamp")
    public Instant getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="timestamp")
    public void setTimestamp(Instant timestamp) {
        this.timestamp = timestamp;
    }

    public SecurityEventNotificationRequest withTimestamp(Instant timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @JsonProperty(value="techInfo")
    public String getTechInfo() {
        return this.techInfo;
    }

    @JsonProperty(value="techInfo")
    public void setTechInfo(String techInfo) {
        this.techInfo = techInfo;
    }

    public SecurityEventNotificationRequest withTechInfo(String techInfo) {
        this.techInfo = techInfo;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(SecurityEventNotificationRequest.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("customData");
        sb.append('=');
        sb.append(this.customData == null ? "<null>" : this.customData);
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("timestamp");
        sb.append('=');
        sb.append(this.timestamp == null ? "<null>" : this.timestamp);
        sb.append(',');
        sb.append("techInfo");
        sb.append('=');
        sb.append(this.techInfo == null ? "<null>" : this.techInfo);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.customData == null ? 0 : this.customData.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.techInfo == null ? 0 : this.techInfo.hashCode());
        result = result * 31 + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SecurityEventNotificationRequest)) {
            return false;
        }
        SecurityEventNotificationRequest rhs = (SecurityEventNotificationRequest)other;
        return (this.customData == rhs.customData || this.customData != null && this.customData.equals(rhs.customData)) && (this.type == rhs.type || this.type != null && this.type.equals(rhs.type)) && (this.techInfo == rhs.techInfo || this.techInfo != null && this.techInfo.equals(rhs.techInfo)) && (this.timestamp == rhs.timestamp || this.timestamp != null && this.timestamp.equals(rhs.timestamp));
    }
}

