/*
 * Decompiled with CFR 0.152.
 */
package ocpp.v201;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import java.util.List;
import ocpp.v201.AuthorizationData;
import ocpp.v201.CustomData;
import ocpp.v201.UpdateEnum;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"customData", "localAuthorizationList", "versionNumber", "updateType"})
public class SendLocalListRequest
implements Serializable {
    @JsonProperty(value="customData")
    @JsonPropertyDescription(value="This class does not get 'AdditionalProperties = false' in the schema generation, so it can be extended with arbitrary JSON properties to allow adding custom data.")
    private CustomData customData;
    @JsonProperty(value="localAuthorizationList")
    private List<AuthorizationData> localAuthorizationList;
    @JsonProperty(value="versionNumber")
    @JsonPropertyDescription(value="In case of a full update this is the version number of the full list. In case of a differential update it is the version number of the list after the update has been applied.\r\n")
    private Integer versionNumber;
    @JsonProperty(value="updateType")
    @JsonPropertyDescription(value="This contains the type of update (full or differential) of this request.\r\n")
    private UpdateEnum updateType;
    private static final long serialVersionUID = -3717024586532799137L;

    public SendLocalListRequest() {
    }

    public SendLocalListRequest(Integer versionNumber, UpdateEnum updateType) {
        this.versionNumber = versionNumber;
        this.updateType = updateType;
    }

    @JsonProperty(value="customData")
    public CustomData getCustomData() {
        return this.customData;
    }

    @JsonProperty(value="customData")
    public void setCustomData(CustomData customData) {
        this.customData = customData;
    }

    public SendLocalListRequest withCustomData(CustomData customData) {
        this.customData = customData;
        return this;
    }

    @JsonProperty(value="localAuthorizationList")
    public List<AuthorizationData> getLocalAuthorizationList() {
        return this.localAuthorizationList;
    }

    @JsonProperty(value="localAuthorizationList")
    public void setLocalAuthorizationList(List<AuthorizationData> localAuthorizationList) {
        this.localAuthorizationList = localAuthorizationList;
    }

    public SendLocalListRequest withLocalAuthorizationList(List<AuthorizationData> localAuthorizationList) {
        this.localAuthorizationList = localAuthorizationList;
        return this;
    }

    @JsonProperty(value="versionNumber")
    public Integer getVersionNumber() {
        return this.versionNumber;
    }

    @JsonProperty(value="versionNumber")
    public void setVersionNumber(Integer versionNumber) {
        this.versionNumber = versionNumber;
    }

    public SendLocalListRequest withVersionNumber(Integer versionNumber) {
        this.versionNumber = versionNumber;
        return this;
    }

    @JsonProperty(value="updateType")
    public UpdateEnum getUpdateType() {
        return this.updateType;
    }

    @JsonProperty(value="updateType")
    public void setUpdateType(UpdateEnum updateType) {
        this.updateType = updateType;
    }

    public SendLocalListRequest withUpdateType(UpdateEnum updateType) {
        this.updateType = updateType;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(SendLocalListRequest.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("customData");
        sb.append('=');
        sb.append(this.customData == null ? "<null>" : this.customData);
        sb.append(',');
        sb.append("localAuthorizationList");
        sb.append('=');
        sb.append(this.localAuthorizationList == null ? "<null>" : this.localAuthorizationList);
        sb.append(',');
        sb.append("versionNumber");
        sb.append('=');
        sb.append(this.versionNumber == null ? "<null>" : this.versionNumber);
        sb.append(',');
        sb.append("updateType");
        sb.append('=');
        sb.append(this.updateType == null ? "<null>" : this.updateType);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.customData == null ? 0 : this.customData.hashCode());
        result = result * 31 + (this.localAuthorizationList == null ? 0 : this.localAuthorizationList.hashCode());
        result = result * 31 + (this.versionNumber == null ? 0 : this.versionNumber.hashCode());
        result = result * 31 + (this.updateType == null ? 0 : this.updateType.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SendLocalListRequest)) {
            return false;
        }
        SendLocalListRequest rhs = (SendLocalListRequest)other;
        return (this.customData == rhs.customData || this.customData != null && this.customData.equals(rhs.customData)) && (this.localAuthorizationList == rhs.localAuthorizationList || this.localAuthorizationList != null && this.localAuthorizationList.equals(rhs.localAuthorizationList)) && (this.versionNumber == rhs.versionNumber || this.versionNumber != null && this.versionNumber.equals(rhs.versionNumber)) && (this.updateType == rhs.updateType || this.updateType != null && this.updateType.equals((Object)rhs.updateType));
    }
}

