/*
 * Decompiled with CFR 0.152.
 */
package ocpp.v201;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import ocpp.v201.CustomData;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"customData", "severity"})
public class SetMonitoringLevelRequest
implements Serializable {
    @JsonProperty(value="customData")
    @JsonPropertyDescription(value="This class does not get 'AdditionalProperties = false' in the schema generation, so it can be extended with arbitrary JSON properties to allow adding custom data.")
    private CustomData customData;
    @JsonProperty(value="severity")
    @JsonPropertyDescription(value="The Charging Station SHALL only report events with a severity number lower than or equal to this severity.\r\nThe severity range is 0-9, with 0 as the highest and 9 as the lowest severity level.\r\n\r\nThe severity levels have the following meaning: +\r\n*0-Danger* +\r\nIndicates lives are potentially in danger. Urgent attention is needed and action should be taken immediately. +\r\n*1-Hardware Failure* +\r\nIndicates that the Charging Station is unable to continue regular operations due to Hardware issues. Action is required. +\r\n*2-System Failure* +\r\nIndicates that the Charging Station is unable to continue regular operations due to software or minor hardware issues. Action is required. +\r\n*3-Critical* +\r\nIndicates a critical error. Action is required. +\r\n*4-Error* +\r\nIndicates a non-urgent error. Action is required. +\r\n*5-Alert* +\r\nIndicates an alert event. Default severity for any type of monitoring event.  +\r\n*6-Warning* +\r\nIndicates a warning event. Action may be required. +\r\n*7-Notice* +\r\nIndicates an unusual event. No immediate action is required. +\r\n*8-Informational* +\r\nIndicates a regular operational event. May be used for reporting, measuring throughput, etc. No action is required. +\r\n*9-Debug* +\r\nIndicates information useful to developers for debugging, not useful during operations.\r\n\r\n\r\n")
    private Integer severity;
    private static final long serialVersionUID = 7733055183905848460L;

    public SetMonitoringLevelRequest() {
    }

    public SetMonitoringLevelRequest(Integer severity) {
        this.severity = severity;
    }

    @JsonProperty(value="customData")
    public CustomData getCustomData() {
        return this.customData;
    }

    @JsonProperty(value="customData")
    public void setCustomData(CustomData customData) {
        this.customData = customData;
    }

    public SetMonitoringLevelRequest withCustomData(CustomData customData) {
        this.customData = customData;
        return this;
    }

    @JsonProperty(value="severity")
    public Integer getSeverity() {
        return this.severity;
    }

    @JsonProperty(value="severity")
    public void setSeverity(Integer severity) {
        this.severity = severity;
    }

    public SetMonitoringLevelRequest withSeverity(Integer severity) {
        this.severity = severity;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(SetMonitoringLevelRequest.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("customData");
        sb.append('=');
        sb.append(this.customData == null ? "<null>" : this.customData);
        sb.append(',');
        sb.append("severity");
        sb.append('=');
        sb.append(this.severity == null ? "<null>" : this.severity);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.severity == null ? 0 : this.severity.hashCode());
        result = result * 31 + (this.customData == null ? 0 : this.customData.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SetMonitoringLevelRequest)) {
            return false;
        }
        SetMonitoringLevelRequest rhs = (SetMonitoringLevelRequest)other;
        return (this.severity == rhs.severity || this.severity != null && this.severity.equals(rhs.severity)) && (this.customData == rhs.customData || this.customData != null && this.customData.equals(rhs.customData));
    }
}

