/*
 * Decompiled with CFR 0.152.
 */
package ocpp.v201;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import ocpp.v201.Component;
import ocpp.v201.CustomData;
import ocpp.v201.MonitorEnum;
import ocpp.v201.SetMonitoringStatusEnum;
import ocpp.v201.StatusInfo;
import ocpp.v201.Variable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"customData", "id", "statusInfo", "status", "type", "component", "variable", "severity"})
public class SetMonitoringResult
implements Serializable {
    @JsonProperty(value="customData")
    @JsonPropertyDescription(value="This class does not get 'AdditionalProperties = false' in the schema generation, so it can be extended with arbitrary JSON properties to allow adding custom data.")
    private CustomData customData;
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="Id given to the VariableMonitor by the Charging Station. The Id is only returned when status is accepted. Installed VariableMonitors should have unique id's but the id's of removed Installed monitors should have unique id's but the id's of removed monitors MAY be reused.\r\n")
    private Integer id;
    @JsonProperty(value="statusInfo")
    @JsonPropertyDescription(value="Element providing more information about the status.\r\n")
    private StatusInfo statusInfo;
    @JsonProperty(value="status")
    @JsonPropertyDescription(value="Status is OK if a value could be returned. Otherwise this will indicate the reason why a value could not be returned.\r\n")
    private SetMonitoringStatusEnum status;
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="The type of this monitor, e.g. a threshold, delta or periodic monitor. \r\n\r\n")
    private MonitorEnum type;
    @JsonProperty(value="component")
    @JsonPropertyDescription(value="A physical or logical component\r\n")
    private Component component;
    @JsonProperty(value="variable")
    @JsonPropertyDescription(value="Reference key to a component-variable.\r\n")
    private Variable variable;
    @JsonProperty(value="severity")
    @JsonPropertyDescription(value="The severity that will be assigned to an event that is triggered by this monitor. The severity range is 0-9, with 0 as the highest and 9 as the lowest severity level.\r\n\r\nThe severity levels have the following meaning: +\r\n*0-Danger* +\r\nIndicates lives are potentially in danger. Urgent attention is needed and action should be taken immediately. +\r\n*1-Hardware Failure* +\r\nIndicates that the Charging Station is unable to continue regular operations due to Hardware issues. Action is required. +\r\n*2-System Failure* +\r\nIndicates that the Charging Station is unable to continue regular operations due to software or minor hardware issues. Action is required. +\r\n*3-Critical* +\r\nIndicates a critical error. Action is required. +\r\n*4-Error* +\r\nIndicates a non-urgent error. Action is required. +\r\n*5-Alert* +\r\nIndicates an alert event. Default severity for any type of monitoring event.  +\r\n*6-Warning* +\r\nIndicates a warning event. Action may be required. +\r\n*7-Notice* +\r\nIndicates an unusual event. No immediate action is required. +\r\n*8-Informational* +\r\nIndicates a regular operational event. May be used for reporting, measuring throughput, etc. No action is required. +\r\n*9-Debug* +\r\nIndicates information useful to developers for debugging, not useful during operations.\r\n\r\n")
    private Integer severity;
    private static final long serialVersionUID = 7804504523715890039L;

    public SetMonitoringResult() {
    }

    public SetMonitoringResult(SetMonitoringStatusEnum status, MonitorEnum type, Component component, Variable variable, Integer severity) {
        this.status = status;
        this.type = type;
        this.component = component;
        this.variable = variable;
        this.severity = severity;
    }

    @JsonProperty(value="customData")
    public CustomData getCustomData() {
        return this.customData;
    }

    @JsonProperty(value="customData")
    public void setCustomData(CustomData customData) {
        this.customData = customData;
    }

    public SetMonitoringResult withCustomData(CustomData customData) {
        this.customData = customData;
        return this;
    }

    @JsonProperty(value="id")
    public Integer getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(Integer id) {
        this.id = id;
    }

    public SetMonitoringResult withId(Integer id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="statusInfo")
    public StatusInfo getStatusInfo() {
        return this.statusInfo;
    }

    @JsonProperty(value="statusInfo")
    public void setStatusInfo(StatusInfo statusInfo) {
        this.statusInfo = statusInfo;
    }

    public SetMonitoringResult withStatusInfo(StatusInfo statusInfo) {
        this.statusInfo = statusInfo;
        return this;
    }

    @JsonProperty(value="status")
    public SetMonitoringStatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    public void setStatus(SetMonitoringStatusEnum status) {
        this.status = status;
    }

    public SetMonitoringResult withStatus(SetMonitoringStatusEnum status) {
        this.status = status;
        return this;
    }

    @JsonProperty(value="type")
    public MonitorEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(MonitorEnum type) {
        this.type = type;
    }

    public SetMonitoringResult withType(MonitorEnum type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="component")
    public Component getComponent() {
        return this.component;
    }

    @JsonProperty(value="component")
    public void setComponent(Component component) {
        this.component = component;
    }

    public SetMonitoringResult withComponent(Component component) {
        this.component = component;
        return this;
    }

    @JsonProperty(value="variable")
    public Variable getVariable() {
        return this.variable;
    }

    @JsonProperty(value="variable")
    public void setVariable(Variable variable) {
        this.variable = variable;
    }

    public SetMonitoringResult withVariable(Variable variable) {
        this.variable = variable;
        return this;
    }

    @JsonProperty(value="severity")
    public Integer getSeverity() {
        return this.severity;
    }

    @JsonProperty(value="severity")
    public void setSeverity(Integer severity) {
        this.severity = severity;
    }

    public SetMonitoringResult withSeverity(Integer severity) {
        this.severity = severity;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(SetMonitoringResult.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("customData");
        sb.append('=');
        sb.append(this.customData == null ? "<null>" : this.customData);
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(this.id == null ? "<null>" : this.id);
        sb.append(',');
        sb.append("statusInfo");
        sb.append('=');
        sb.append(this.statusInfo == null ? "<null>" : this.statusInfo);
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(this.status == null ? "<null>" : this.status);
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("component");
        sb.append('=');
        sb.append(this.component == null ? "<null>" : this.component);
        sb.append(',');
        sb.append("variable");
        sb.append('=');
        sb.append(this.variable == null ? "<null>" : this.variable);
        sb.append(',');
        sb.append("severity");
        sb.append('=');
        sb.append(this.severity == null ? "<null>" : this.severity);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.severity == null ? 0 : this.severity.hashCode());
        result = result * 31 + (this.component == null ? 0 : this.component.hashCode());
        result = result * 31 + (this.statusInfo == null ? 0 : this.statusInfo.hashCode());
        result = result * 31 + (this.variable == null ? 0 : this.variable.hashCode());
        result = result * 31 + (this.customData == null ? 0 : this.customData.hashCode());
        result = result * 31 + (this.id == null ? 0 : this.id.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SetMonitoringResult)) {
            return false;
        }
        SetMonitoringResult rhs = (SetMonitoringResult)other;
        return (this.severity == rhs.severity || this.severity != null && this.severity.equals(rhs.severity)) && (this.component == rhs.component || this.component != null && this.component.equals(rhs.component)) && (this.statusInfo == rhs.statusInfo || this.statusInfo != null && this.statusInfo.equals(rhs.statusInfo)) && (this.variable == rhs.variable || this.variable != null && this.variable.equals(rhs.variable)) && (this.customData == rhs.customData || this.customData != null && this.customData.equals(rhs.customData)) && (this.id == rhs.id || this.id != null && this.id.equals(rhs.id)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.status == rhs.status || this.status != null && this.status.equals((Object)rhs.status));
    }
}

