/*
 * Decompiled with CFR 0.152.
 */
package ocpp.v201;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import ocpp.v201.AttributeEnum;
import ocpp.v201.Component;
import ocpp.v201.CustomData;
import ocpp.v201.Variable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"customData", "attributeType", "attributeValue", "component", "variable"})
public class SetVariableData
implements Serializable {
    @JsonProperty(value="customData")
    @JsonPropertyDescription(value="This class does not get 'AdditionalProperties = false' in the schema generation, so it can be extended with arbitrary JSON properties to allow adding custom data.")
    private CustomData customData;
    @JsonProperty(value="attributeType")
    @JsonPropertyDescription(value="Type of attribute: Actual, Target, MinSet, MaxSet. Default is Actual when omitted.\r\n")
    private AttributeEnum attributeType = AttributeEnum.fromValue("Actual");
    @JsonProperty(value="attributeValue")
    @JsonPropertyDescription(value="Value to be assigned to attribute of variable.\r\n\r\nThe Configuration Variable &lt;&lt;configkey-configuration-value-size,ConfigurationValueSize&gt;&gt; can be used to limit SetVariableData.attributeValue and VariableCharacteristics.valueList. The max size of these values will always remain equal. \r\n")
    private String attributeValue;
    @JsonProperty(value="component")
    @JsonPropertyDescription(value="A physical or logical component\r\n")
    private Component component;
    @JsonProperty(value="variable")
    @JsonPropertyDescription(value="Reference key to a component-variable.\r\n")
    private Variable variable;
    private static final long serialVersionUID = -7382901050447698275L;

    public SetVariableData() {
    }

    public SetVariableData(String attributeValue, Component component, Variable variable) {
        this.attributeValue = attributeValue;
        this.component = component;
        this.variable = variable;
    }

    @JsonProperty(value="customData")
    public CustomData getCustomData() {
        return this.customData;
    }

    @JsonProperty(value="customData")
    public void setCustomData(CustomData customData) {
        this.customData = customData;
    }

    public SetVariableData withCustomData(CustomData customData) {
        this.customData = customData;
        return this;
    }

    @JsonProperty(value="attributeType")
    public AttributeEnum getAttributeType() {
        return this.attributeType;
    }

    @JsonProperty(value="attributeType")
    public void setAttributeType(AttributeEnum attributeType) {
        this.attributeType = attributeType;
    }

    public SetVariableData withAttributeType(AttributeEnum attributeType) {
        this.attributeType = attributeType;
        return this;
    }

    @JsonProperty(value="attributeValue")
    public String getAttributeValue() {
        return this.attributeValue;
    }

    @JsonProperty(value="attributeValue")
    public void setAttributeValue(String attributeValue) {
        this.attributeValue = attributeValue;
    }

    public SetVariableData withAttributeValue(String attributeValue) {
        this.attributeValue = attributeValue;
        return this;
    }

    @JsonProperty(value="component")
    public Component getComponent() {
        return this.component;
    }

    @JsonProperty(value="component")
    public void setComponent(Component component) {
        this.component = component;
    }

    public SetVariableData withComponent(Component component) {
        this.component = component;
        return this;
    }

    @JsonProperty(value="variable")
    public Variable getVariable() {
        return this.variable;
    }

    @JsonProperty(value="variable")
    public void setVariable(Variable variable) {
        this.variable = variable;
    }

    public SetVariableData withVariable(Variable variable) {
        this.variable = variable;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(SetVariableData.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("customData");
        sb.append('=');
        sb.append(this.customData == null ? "<null>" : this.customData);
        sb.append(',');
        sb.append("attributeType");
        sb.append('=');
        sb.append(this.attributeType == null ? "<null>" : this.attributeType);
        sb.append(',');
        sb.append("attributeValue");
        sb.append('=');
        sb.append(this.attributeValue == null ? "<null>" : this.attributeValue);
        sb.append(',');
        sb.append("component");
        sb.append('=');
        sb.append(this.component == null ? "<null>" : this.component);
        sb.append(',');
        sb.append("variable");
        sb.append('=');
        sb.append(this.variable == null ? "<null>" : this.variable);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.variable == null ? 0 : this.variable.hashCode());
        result = result * 31 + (this.customData == null ? 0 : this.customData.hashCode());
        result = result * 31 + (this.component == null ? 0 : this.component.hashCode());
        result = result * 31 + (this.attributeValue == null ? 0 : this.attributeValue.hashCode());
        result = result * 31 + (this.attributeType == null ? 0 : this.attributeType.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SetVariableData)) {
            return false;
        }
        SetVariableData rhs = (SetVariableData)other;
        return (this.variable == rhs.variable || this.variable != null && this.variable.equals(rhs.variable)) && (this.customData == rhs.customData || this.customData != null && this.customData.equals(rhs.customData)) && (this.component == rhs.component || this.component != null && this.component.equals(rhs.component)) && (this.attributeValue == rhs.attributeValue || this.attributeValue != null && this.attributeValue.equals(rhs.attributeValue)) && (this.attributeType == rhs.attributeType || this.attributeType != null && this.attributeType.equals((Object)rhs.attributeType));
    }
}

