/*
 * Decompiled with CFR 0.152.
 */
package ocpp.v201;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import ocpp.v201.ChargingStateEnum;
import ocpp.v201.CustomData;
import ocpp.v201.ReasonEnum;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"customData", "transactionId", "chargingState", "timeSpentCharging", "stoppedReason", "remoteStartId"})
public class Transaction
implements Serializable {
    @JsonProperty(value="customData")
    @JsonPropertyDescription(value="This class does not get 'AdditionalProperties = false' in the schema generation, so it can be extended with arbitrary JSON properties to allow adding custom data.")
    private CustomData customData;
    @JsonProperty(value="transactionId")
    @JsonPropertyDescription(value="This contains the Id of the transaction.\r\n")
    private String transactionId;
    @JsonProperty(value="chargingState")
    @JsonPropertyDescription(value="Transaction. State. Transaction_ State_ Code\r\nurn:x-oca:ocpp:uid:1:569419\r\nCurrent charging state, is required when state\r\nhas changed.\r\n")
    private ChargingStateEnum chargingState;
    @JsonProperty(value="timeSpentCharging")
    @JsonPropertyDescription(value="Transaction. Time_ Spent_ Charging. Elapsed_ Time\r\nurn:x-oca:ocpp:uid:1:569415\r\nContains the total time that energy flowed from EVSE to EV during the transaction (in seconds). Note that timeSpentCharging is smaller or equal to the duration of the transaction.\r\n")
    private Integer timeSpentCharging;
    @JsonProperty(value="stoppedReason")
    @JsonPropertyDescription(value="Transaction. Stopped_ Reason. EOT_ Reason_ Code\r\nurn:x-oca:ocpp:uid:1:569413\r\nThis contains the reason why the transaction was stopped. MAY only be omitted when Reason is \"Local\".\r\n")
    private ReasonEnum stoppedReason;
    @JsonProperty(value="remoteStartId")
    @JsonPropertyDescription(value="The ID given to remote start request (&lt;&lt;requeststarttransactionrequest, RequestStartTransactionRequest&gt;&gt;. This enables to CSMS to match the started transaction to the given start request.\r\n")
    private Integer remoteStartId;
    private static final long serialVersionUID = -2874763093137330393L;

    public Transaction() {
    }

    public Transaction(String transactionId) {
        this.transactionId = transactionId;
    }

    @JsonProperty(value="customData")
    public CustomData getCustomData() {
        return this.customData;
    }

    @JsonProperty(value="customData")
    public void setCustomData(CustomData customData) {
        this.customData = customData;
    }

    public Transaction withCustomData(CustomData customData) {
        this.customData = customData;
        return this;
    }

    @JsonProperty(value="transactionId")
    public String getTransactionId() {
        return this.transactionId;
    }

    @JsonProperty(value="transactionId")
    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public Transaction withTransactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @JsonProperty(value="chargingState")
    public ChargingStateEnum getChargingState() {
        return this.chargingState;
    }

    @JsonProperty(value="chargingState")
    public void setChargingState(ChargingStateEnum chargingState) {
        this.chargingState = chargingState;
    }

    public Transaction withChargingState(ChargingStateEnum chargingState) {
        this.chargingState = chargingState;
        return this;
    }

    @JsonProperty(value="timeSpentCharging")
    public Integer getTimeSpentCharging() {
        return this.timeSpentCharging;
    }

    @JsonProperty(value="timeSpentCharging")
    public void setTimeSpentCharging(Integer timeSpentCharging) {
        this.timeSpentCharging = timeSpentCharging;
    }

    public Transaction withTimeSpentCharging(Integer timeSpentCharging) {
        this.timeSpentCharging = timeSpentCharging;
        return this;
    }

    @JsonProperty(value="stoppedReason")
    public ReasonEnum getStoppedReason() {
        return this.stoppedReason;
    }

    @JsonProperty(value="stoppedReason")
    public void setStoppedReason(ReasonEnum stoppedReason) {
        this.stoppedReason = stoppedReason;
    }

    public Transaction withStoppedReason(ReasonEnum stoppedReason) {
        this.stoppedReason = stoppedReason;
        return this;
    }

    @JsonProperty(value="remoteStartId")
    public Integer getRemoteStartId() {
        return this.remoteStartId;
    }

    @JsonProperty(value="remoteStartId")
    public void setRemoteStartId(Integer remoteStartId) {
        this.remoteStartId = remoteStartId;
    }

    public Transaction withRemoteStartId(Integer remoteStartId) {
        this.remoteStartId = remoteStartId;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Transaction.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("customData");
        sb.append('=');
        sb.append(this.customData == null ? "<null>" : this.customData);
        sb.append(',');
        sb.append("transactionId");
        sb.append('=');
        sb.append(this.transactionId == null ? "<null>" : this.transactionId);
        sb.append(',');
        sb.append("chargingState");
        sb.append('=');
        sb.append(this.chargingState == null ? "<null>" : this.chargingState);
        sb.append(',');
        sb.append("timeSpentCharging");
        sb.append('=');
        sb.append(this.timeSpentCharging == null ? "<null>" : this.timeSpentCharging);
        sb.append(',');
        sb.append("stoppedReason");
        sb.append('=');
        sb.append(this.stoppedReason == null ? "<null>" : this.stoppedReason);
        sb.append(',');
        sb.append("remoteStartId");
        sb.append('=');
        sb.append(this.remoteStartId == null ? "<null>" : this.remoteStartId);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.remoteStartId == null ? 0 : this.remoteStartId.hashCode());
        result = result * 31 + (this.stoppedReason == null ? 0 : this.stoppedReason.hashCode());
        result = result * 31 + (this.customData == null ? 0 : this.customData.hashCode());
        result = result * 31 + (this.transactionId == null ? 0 : this.transactionId.hashCode());
        result = result * 31 + (this.timeSpentCharging == null ? 0 : this.timeSpentCharging.hashCode());
        result = result * 31 + (this.chargingState == null ? 0 : this.chargingState.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Transaction)) {
            return false;
        }
        Transaction rhs = (Transaction)other;
        return (this.remoteStartId == rhs.remoteStartId || this.remoteStartId != null && this.remoteStartId.equals(rhs.remoteStartId)) && (this.stoppedReason == rhs.stoppedReason || this.stoppedReason != null && this.stoppedReason.equals((Object)rhs.stoppedReason)) && (this.customData == rhs.customData || this.customData != null && this.customData.equals(rhs.customData)) && (this.transactionId == rhs.transactionId || this.transactionId != null && this.transactionId.equals(rhs.transactionId)) && (this.timeSpentCharging == rhs.timeSpentCharging || this.timeSpentCharging != null && this.timeSpentCharging.equals(rhs.timeSpentCharging)) && (this.chargingState == rhs.chargingState || this.chargingState != null && this.chargingState.equals((Object)rhs.chargingState));
    }
}

