/*
 * Decompiled with CFR 0.152.
 */
package ocpp.v201;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import ocpp.v201.CustomData;
import ocpp.v201.IdTokenInfo;
import ocpp.v201.MessageContent;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"customData", "totalCost", "chargingPriority", "idTokenInfo", "updatedPersonalMessage"})
public class TransactionEventResponse
implements Serializable {
    @JsonProperty(value="customData")
    @JsonPropertyDescription(value="This class does not get 'AdditionalProperties = false' in the schema generation, so it can be extended with arbitrary JSON properties to allow adding custom data.")
    private CustomData customData;
    @JsonProperty(value="totalCost")
    @JsonPropertyDescription(value="SHALL only be sent when charging has ended. Final total cost of this transaction, including taxes. In the currency configured with the Configuration Variable: &lt;&lt;configkey-currency,`Currency`&gt;&gt;. When omitted, the transaction was NOT free. To indicate a free transaction, the CSMS SHALL send 0.00.\r\n\r\n")
    private Double totalCost;
    @JsonProperty(value="chargingPriority")
    @JsonPropertyDescription(value="Priority from a business point of view. Default priority is 0, The range is from -9 to 9. Higher values indicate a higher priority. The chargingPriority in &lt;&lt;transactioneventresponse,TransactionEventResponse&gt;&gt; is temporarily, so it may not be set in the &lt;&lt;cmn_idtokeninfotype,IdTokenInfoType&gt;&gt; afterwards. Also the chargingPriority in &lt;&lt;transactioneventresponse,TransactionEventResponse&gt;&gt; overrules the one in &lt;&lt;cmn_idtokeninfotype,IdTokenInfoType&gt;&gt;.  \r\n")
    private Integer chargingPriority;
    @JsonProperty(value="idTokenInfo")
    @JsonPropertyDescription(value="ID_ Token\r\nurn:x-oca:ocpp:uid:2:233247\r\nContains status information about an identifier.\r\nIt is advised to not stop charging for a token that expires during charging, as ExpiryDate is only used for caching purposes. If ExpiryDate is not given, the status has no end date.\r\n")
    private IdTokenInfo idTokenInfo;
    @JsonProperty(value="updatedPersonalMessage")
    @JsonPropertyDescription(value="Message_ Content\r\nurn:x-enexis:ecdm:uid:2:234490\r\nContains message details, for a message to be displayed on a Charging Station.\r\n\r\n")
    private MessageContent updatedPersonalMessage;
    private static final long serialVersionUID = 1219366544580807057L;

    @JsonProperty(value="customData")
    public CustomData getCustomData() {
        return this.customData;
    }

    @JsonProperty(value="customData")
    public void setCustomData(CustomData customData) {
        this.customData = customData;
    }

    public TransactionEventResponse withCustomData(CustomData customData) {
        this.customData = customData;
        return this;
    }

    @JsonProperty(value="totalCost")
    public Double getTotalCost() {
        return this.totalCost;
    }

    @JsonProperty(value="totalCost")
    public void setTotalCost(Double totalCost) {
        this.totalCost = totalCost;
    }

    public TransactionEventResponse withTotalCost(Double totalCost) {
        this.totalCost = totalCost;
        return this;
    }

    @JsonProperty(value="chargingPriority")
    public Integer getChargingPriority() {
        return this.chargingPriority;
    }

    @JsonProperty(value="chargingPriority")
    public void setChargingPriority(Integer chargingPriority) {
        this.chargingPriority = chargingPriority;
    }

    public TransactionEventResponse withChargingPriority(Integer chargingPriority) {
        this.chargingPriority = chargingPriority;
        return this;
    }

    @JsonProperty(value="idTokenInfo")
    public IdTokenInfo getIdTokenInfo() {
        return this.idTokenInfo;
    }

    @JsonProperty(value="idTokenInfo")
    public void setIdTokenInfo(IdTokenInfo idTokenInfo) {
        this.idTokenInfo = idTokenInfo;
    }

    public TransactionEventResponse withIdTokenInfo(IdTokenInfo idTokenInfo) {
        this.idTokenInfo = idTokenInfo;
        return this;
    }

    @JsonProperty(value="updatedPersonalMessage")
    public MessageContent getUpdatedPersonalMessage() {
        return this.updatedPersonalMessage;
    }

    @JsonProperty(value="updatedPersonalMessage")
    public void setUpdatedPersonalMessage(MessageContent updatedPersonalMessage) {
        this.updatedPersonalMessage = updatedPersonalMessage;
    }

    public TransactionEventResponse withUpdatedPersonalMessage(MessageContent updatedPersonalMessage) {
        this.updatedPersonalMessage = updatedPersonalMessage;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TransactionEventResponse.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("customData");
        sb.append('=');
        sb.append(this.customData == null ? "<null>" : this.customData);
        sb.append(',');
        sb.append("totalCost");
        sb.append('=');
        sb.append(this.totalCost == null ? "<null>" : this.totalCost);
        sb.append(',');
        sb.append("chargingPriority");
        sb.append('=');
        sb.append(this.chargingPriority == null ? "<null>" : this.chargingPriority);
        sb.append(',');
        sb.append("idTokenInfo");
        sb.append('=');
        sb.append(this.idTokenInfo == null ? "<null>" : this.idTokenInfo);
        sb.append(',');
        sb.append("updatedPersonalMessage");
        sb.append('=');
        sb.append(this.updatedPersonalMessage == null ? "<null>" : this.updatedPersonalMessage);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.customData == null ? 0 : this.customData.hashCode());
        result = result * 31 + (this.chargingPriority == null ? 0 : this.chargingPriority.hashCode());
        result = result * 31 + (this.idTokenInfo == null ? 0 : this.idTokenInfo.hashCode());
        result = result * 31 + (this.totalCost == null ? 0 : this.totalCost.hashCode());
        result = result * 31 + (this.updatedPersonalMessage == null ? 0 : this.updatedPersonalMessage.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof TransactionEventResponse)) {
            return false;
        }
        TransactionEventResponse rhs = (TransactionEventResponse)other;
        return (this.customData == rhs.customData || this.customData != null && this.customData.equals(rhs.customData)) && (this.chargingPriority == rhs.chargingPriority || this.chargingPriority != null && this.chargingPriority.equals(rhs.chargingPriority)) && (this.idTokenInfo == rhs.idTokenInfo || this.idTokenInfo != null && this.idTokenInfo.equals(rhs.idTokenInfo)) && (this.totalCost == rhs.totalCost || this.totalCost != null && this.totalCost.equals(rhs.totalCost)) && (this.updatedPersonalMessage == rhs.updatedPersonalMessage || this.updatedPersonalMessage != null && this.updatedPersonalMessage.equals(rhs.updatedPersonalMessage));
    }
}

