/*
 * Decompiled with CFR 0.152.
 */
package ocpp.v201;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import ocpp.v201.AttributeEnum;
import ocpp.v201.CustomData;
import ocpp.v201.MutabilityEnum;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"customData", "type", "value", "mutability", "persistent", "constant"})
public class VariableAttribute
implements Serializable {
    @JsonProperty(value="customData")
    @JsonPropertyDescription(value="This class does not get 'AdditionalProperties = false' in the schema generation, so it can be extended with arbitrary JSON properties to allow adding custom data.")
    private CustomData customData;
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Attribute: Actual, MinSet, MaxSet, etc.\r\nDefaults to Actual if absent.\r\n")
    private AttributeEnum type = AttributeEnum.fromValue("Actual");
    @JsonProperty(value="value")
    @JsonPropertyDescription(value="Value of the attribute. May only be omitted when mutability is set to 'WriteOnly'.\r\n\r\nThe Configuration Variable &lt;&lt;configkey-reporting-value-size,ReportingValueSize&gt;&gt; can be used to limit GetVariableResult.attributeValue, VariableAttribute.value and EventData.actualValue. The max size of these values will always remain equal. \r\n")
    private String value;
    @JsonProperty(value="mutability")
    @JsonPropertyDescription(value="Defines the mutability of this attribute. Default is ReadWrite when omitted.\r\n")
    private MutabilityEnum mutability = MutabilityEnum.fromValue("ReadWrite");
    @JsonProperty(value="persistent")
    @JsonPropertyDescription(value="If true, value will be persistent across system reboots or power down. Default when omitted is false.\r\n")
    private Boolean persistent = false;
    @JsonProperty(value="constant")
    @JsonPropertyDescription(value="If true, value that will never be changed by the Charging Station at runtime. Default when omitted is false.\r\n")
    private Boolean constant = false;
    private static final long serialVersionUID = 192871157214264163L;

    @JsonProperty(value="customData")
    public CustomData getCustomData() {
        return this.customData;
    }

    @JsonProperty(value="customData")
    public void setCustomData(CustomData customData) {
        this.customData = customData;
    }

    public VariableAttribute withCustomData(CustomData customData) {
        this.customData = customData;
        return this;
    }

    @JsonProperty(value="type")
    public AttributeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(AttributeEnum type) {
        this.type = type;
    }

    public VariableAttribute withType(AttributeEnum type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    public void setValue(String value) {
        this.value = value;
    }

    public VariableAttribute withValue(String value) {
        this.value = value;
        return this;
    }

    @JsonProperty(value="mutability")
    public MutabilityEnum getMutability() {
        return this.mutability;
    }

    @JsonProperty(value="mutability")
    public void setMutability(MutabilityEnum mutability) {
        this.mutability = mutability;
    }

    public VariableAttribute withMutability(MutabilityEnum mutability) {
        this.mutability = mutability;
        return this;
    }

    @JsonProperty(value="persistent")
    public Boolean getPersistent() {
        return this.persistent;
    }

    @JsonProperty(value="persistent")
    public void setPersistent(Boolean persistent) {
        this.persistent = persistent;
    }

    public VariableAttribute withPersistent(Boolean persistent) {
        this.persistent = persistent;
        return this;
    }

    @JsonProperty(value="constant")
    public Boolean getConstant() {
        return this.constant;
    }

    @JsonProperty(value="constant")
    public void setConstant(Boolean constant) {
        this.constant = constant;
    }

    public VariableAttribute withConstant(Boolean constant) {
        this.constant = constant;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(VariableAttribute.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("customData");
        sb.append('=');
        sb.append(this.customData == null ? "<null>" : this.customData);
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("value");
        sb.append('=');
        sb.append(this.value == null ? "<null>" : this.value);
        sb.append(',');
        sb.append("mutability");
        sb.append('=');
        sb.append(this.mutability == null ? "<null>" : this.mutability);
        sb.append(',');
        sb.append("persistent");
        sb.append('=');
        sb.append(this.persistent == null ? "<null>" : this.persistent);
        sb.append(',');
        sb.append("constant");
        sb.append('=');
        sb.append(this.constant == null ? "<null>" : this.constant);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.constant == null ? 0 : this.constant.hashCode());
        result = result * 31 + (this.customData == null ? 0 : this.customData.hashCode());
        result = result * 31 + (this.mutability == null ? 0 : this.mutability.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.persistent == null ? 0 : this.persistent.hashCode());
        result = result * 31 + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof VariableAttribute)) {
            return false;
        }
        VariableAttribute rhs = (VariableAttribute)other;
        return (this.constant == rhs.constant || this.constant != null && this.constant.equals(rhs.constant)) && (this.customData == rhs.customData || this.customData != null && this.customData.equals(rhs.customData)) && (this.mutability == rhs.mutability || this.mutability != null && this.mutability.equals((Object)rhs.mutability)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.persistent == rhs.persistent || this.persistent != null && this.persistent.equals(rhs.persistent)) && (this.value == rhs.value || this.value != null && this.value.equals(rhs.value));
    }
}

