/*
 * Decompiled with CFR 0.152.
 */
package ocpp.v201;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import ocpp.v201.CustomData;
import ocpp.v201.DataEnum;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"customData", "unit", "dataType", "minLimit", "maxLimit", "valuesList", "supportsMonitoring"})
public class VariableCharacteristics
implements Serializable {
    @JsonProperty(value="customData")
    @JsonPropertyDescription(value="This class does not get 'AdditionalProperties = false' in the schema generation, so it can be extended with arbitrary JSON properties to allow adding custom data.")
    private CustomData customData;
    @JsonProperty(value="unit")
    @JsonPropertyDescription(value="Unit of the variable. When the transmitted value has a unit, this field SHALL be included.\r\n")
    private String unit;
    @JsonProperty(value="dataType")
    @JsonPropertyDescription(value="Data type of this variable.\r\n")
    private DataEnum dataType;
    @JsonProperty(value="minLimit")
    @JsonPropertyDescription(value="Minimum possible value of this variable.\r\n")
    private Double minLimit;
    @JsonProperty(value="maxLimit")
    @JsonPropertyDescription(value="Maximum possible value of this variable. When the datatype of this Variable is String, OptionList, SequenceList or MemberList, this field defines the maximum length of the (CSV) string.\r\n")
    private Double maxLimit;
    @JsonProperty(value="valuesList")
    @JsonPropertyDescription(value="Allowed values when variable is Option/Member/SequenceList. \r\n\r\n* OptionList: The (Actual) Variable value must be a single value from the reported (CSV) enumeration list.\r\n\r\n* MemberList: The (Actual) Variable value  may be an (unordered) (sub-)set of the reported (CSV) valid values list.\r\n\r\n* SequenceList: The (Actual) Variable value  may be an ordered (priority, etc)  (sub-)set of the reported (CSV) valid values.\r\n\r\nThis is a comma separated list.\r\n\r\nThe Configuration Variable &lt;&lt;configkey-configuration-value-size,ConfigurationValueSize&gt;&gt; can be used to limit SetVariableData.attributeValue and VariableCharacteristics.valueList. The max size of these values will always remain equal. \r\n\r\n")
    private String valuesList;
    @JsonProperty(value="supportsMonitoring")
    @JsonPropertyDescription(value="Flag indicating if this variable supports monitoring. \r\n")
    private Boolean supportsMonitoring;
    private static final long serialVersionUID = 1520295536510572027L;

    public VariableCharacteristics() {
    }

    public VariableCharacteristics(DataEnum dataType, Boolean supportsMonitoring) {
        this.dataType = dataType;
        this.supportsMonitoring = supportsMonitoring;
    }

    @JsonProperty(value="customData")
    public CustomData getCustomData() {
        return this.customData;
    }

    @JsonProperty(value="customData")
    public void setCustomData(CustomData customData) {
        this.customData = customData;
    }

    public VariableCharacteristics withCustomData(CustomData customData) {
        this.customData = customData;
        return this;
    }

    @JsonProperty(value="unit")
    public String getUnit() {
        return this.unit;
    }

    @JsonProperty(value="unit")
    public void setUnit(String unit) {
        this.unit = unit;
    }

    public VariableCharacteristics withUnit(String unit) {
        this.unit = unit;
        return this;
    }

    @JsonProperty(value="dataType")
    public DataEnum getDataType() {
        return this.dataType;
    }

    @JsonProperty(value="dataType")
    public void setDataType(DataEnum dataType) {
        this.dataType = dataType;
    }

    public VariableCharacteristics withDataType(DataEnum dataType) {
        this.dataType = dataType;
        return this;
    }

    @JsonProperty(value="minLimit")
    public Double getMinLimit() {
        return this.minLimit;
    }

    @JsonProperty(value="minLimit")
    public void setMinLimit(Double minLimit) {
        this.minLimit = minLimit;
    }

    public VariableCharacteristics withMinLimit(Double minLimit) {
        this.minLimit = minLimit;
        return this;
    }

    @JsonProperty(value="maxLimit")
    public Double getMaxLimit() {
        return this.maxLimit;
    }

    @JsonProperty(value="maxLimit")
    public void setMaxLimit(Double maxLimit) {
        this.maxLimit = maxLimit;
    }

    public VariableCharacteristics withMaxLimit(Double maxLimit) {
        this.maxLimit = maxLimit;
        return this;
    }

    @JsonProperty(value="valuesList")
    public String getValuesList() {
        return this.valuesList;
    }

    @JsonProperty(value="valuesList")
    public void setValuesList(String valuesList) {
        this.valuesList = valuesList;
    }

    public VariableCharacteristics withValuesList(String valuesList) {
        this.valuesList = valuesList;
        return this;
    }

    @JsonProperty(value="supportsMonitoring")
    public Boolean getSupportsMonitoring() {
        return this.supportsMonitoring;
    }

    @JsonProperty(value="supportsMonitoring")
    public void setSupportsMonitoring(Boolean supportsMonitoring) {
        this.supportsMonitoring = supportsMonitoring;
    }

    public VariableCharacteristics withSupportsMonitoring(Boolean supportsMonitoring) {
        this.supportsMonitoring = supportsMonitoring;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(VariableCharacteristics.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("customData");
        sb.append('=');
        sb.append(this.customData == null ? "<null>" : this.customData);
        sb.append(',');
        sb.append("unit");
        sb.append('=');
        sb.append(this.unit == null ? "<null>" : this.unit);
        sb.append(',');
        sb.append("dataType");
        sb.append('=');
        sb.append(this.dataType == null ? "<null>" : this.dataType);
        sb.append(',');
        sb.append("minLimit");
        sb.append('=');
        sb.append(this.minLimit == null ? "<null>" : this.minLimit);
        sb.append(',');
        sb.append("maxLimit");
        sb.append('=');
        sb.append(this.maxLimit == null ? "<null>" : this.maxLimit);
        sb.append(',');
        sb.append("valuesList");
        sb.append('=');
        sb.append(this.valuesList == null ? "<null>" : this.valuesList);
        sb.append(',');
        sb.append("supportsMonitoring");
        sb.append('=');
        sb.append(this.supportsMonitoring == null ? "<null>" : this.supportsMonitoring);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.unit == null ? 0 : this.unit.hashCode());
        result = result * 31 + (this.valuesList == null ? 0 : this.valuesList.hashCode());
        result = result * 31 + (this.supportsMonitoring == null ? 0 : this.supportsMonitoring.hashCode());
        result = result * 31 + (this.maxLimit == null ? 0 : this.maxLimit.hashCode());
        result = result * 31 + (this.dataType == null ? 0 : this.dataType.hashCode());
        result = result * 31 + (this.customData == null ? 0 : this.customData.hashCode());
        result = result * 31 + (this.minLimit == null ? 0 : this.minLimit.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof VariableCharacteristics)) {
            return false;
        }
        VariableCharacteristics rhs = (VariableCharacteristics)other;
        return (this.unit == rhs.unit || this.unit != null && this.unit.equals(rhs.unit)) && (this.valuesList == rhs.valuesList || this.valuesList != null && this.valuesList.equals(rhs.valuesList)) && (this.supportsMonitoring == rhs.supportsMonitoring || this.supportsMonitoring != null && this.supportsMonitoring.equals(rhs.supportsMonitoring)) && (this.maxLimit == rhs.maxLimit || this.maxLimit != null && this.maxLimit.equals(rhs.maxLimit)) && (this.dataType == rhs.dataType || this.dataType != null && this.dataType.equals((Object)rhs.dataType)) && (this.customData == rhs.customData || this.customData != null && this.customData.equals(rhs.customData)) && (this.minLimit == rhs.minLimit || this.minLimit != null && this.minLimit.equals(rhs.minLimit));
    }
}

