/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.dao.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.solarnetwork.node.dao.BasicBatchResult;
import net.solarnetwork.node.dao.BatchableDao;
import net.solarnetwork.node.dao.jdbc.JdbcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.support.JdbcDaoSupport;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public abstract class AbstractBatchableJdbcDao<T>
extends JdbcDaoSupport
implements BatchableDao<T> {
    private TransactionTemplate transactionTemplate;
    private String sqlForUpdateSuffix = " FOR UPDATE";
    private String sqlResourcePrefix = null;
    private final Map<String, String> sqlResourceCache = new HashMap<String, String>(10);
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected abstract String getBatchJdbcStatement(BatchableDao.BatchOptions var1);

    protected abstract T getBatchRowEntity(BatchableDao.BatchOptions var1, ResultSet var2, int var3) throws SQLException;

    protected abstract void updateBatchRowEntity(BatchableDao.BatchOptions var1, ResultSet var2, int var3, T var4) throws SQLException;

    public BatchableDao.BatchResult batchProcess(final BatchableDao.BatchCallback<T> callback, final BatchableDao.BatchOptions options) {
        if (this.transactionTemplate != null) {
            return (BatchableDao.BatchResult)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<BatchableDao.BatchResult>(){

                public BatchableDao.BatchResult doInTransaction(TransactionStatus status) {
                    return AbstractBatchableJdbcDao.this.batchProcessInternal(callback, options);
                }
            });
        }
        return this.batchProcessInternal(callback, options);
    }

    private BatchableDao.BatchResult batchProcessInternal(final BatchableDao.BatchCallback<T> callback, final BatchableDao.BatchOptions options) {
        final String querySql = this.getBatchJdbcStatement(options);
        final AtomicInteger rowCount = new AtomicInteger(0);
        this.getJdbcTemplate().execute((ConnectionCallback)new ConnectionCallback<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public BatchableDao.BatchResult doInConnection(Connection con) throws SQLException, DataAccessException {
                PreparedStatement queryStmt = null;
                ResultSet queryResult = null;
                DatabaseMetaData meta = con.getMetaData();
                int scrollType = options.isUpdatable() ? (meta.supportsResultSetType(1005) ? 1005 : 1004) : 1003;
                int concurType = options.isUpdatable() ? 1008 : 1007;
                try {
                    queryStmt = con.prepareStatement(querySql, scrollType, concurType, 2);
                    queryResult = queryStmt.executeQuery();
                    while (queryResult.next()) {
                        Object entity = AbstractBatchableJdbcDao.this.getBatchRowEntity(options, queryResult, rowCount.incrementAndGet());
                        BatchableDao.BatchCallbackResult rowResult = callback.handle(entity);
                        switch (rowResult) {
                            case CONTINUE: {
                                break;
                            }
                            case STOP: {
                                BatchableDao.BatchResult batchResult = null;
                                return batchResult;
                            }
                            case DELETE: {
                                queryResult.deleteRow();
                                break;
                            }
                            case UPDATE: 
                            case UPDATE_STOP: {
                                AbstractBatchableJdbcDao.this.updateBatchRowEntity(options, queryResult, rowCount.intValue(), entity);
                                queryResult.updateRow();
                                if (rowResult != BatchableDao.BatchCallbackResult.UPDATE_STOP) break;
                                BatchableDao.BatchResult batchResult = null;
                                return batchResult;
                            }
                        }
                    }
                }
                finally {
                    if (queryResult != null) {
                        queryResult.close();
                    }
                    if (queryStmt != null) {
                        queryStmt.close();
                    }
                }
                return null;
            }
        });
        return new BasicBatchResult(rowCount.intValue());
    }

    protected String getSqlResource(String classPathResource) {
        return JdbcUtils.getSqlResource(classPathResource, ((Object)((Object)this)).getClass(), this.getSqlResourcePrefix(), this.sqlResourceCache);
    }

    protected String getSqlResource(Resource resource) {
        return JdbcUtils.getSqlResource(resource);
    }

    protected String[] getBatchSqlResource(Resource sqlResource) {
        return JdbcUtils.getBatchSqlResource(sqlResource);
    }

    public TransactionTemplate getTransactionTemplate() {
        return this.transactionTemplate;
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public String getSqlForUpdateSuffix() {
        return this.sqlForUpdateSuffix;
    }

    public void setSqlForUpdateSuffix(String sqlForUpdateSuffix) {
        this.sqlForUpdateSuffix = sqlForUpdateSuffix;
    }

    public String getSqlResourcePrefix() {
        return this.sqlResourcePrefix;
    }

    public void setSqlResourcePrefix(String sqlResourcePrefix) {
        this.sqlResourcePrefix = sqlResourcePrefix;
    }
}

