/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.dao.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.solarnetwork.node.dao.jdbc.JdbcDao;
import net.solarnetwork.node.dao.jdbc.JdbcUtils;
import net.solarnetwork.service.OptionalService;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.support.JdbcDaoSupport;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;

public abstract class AbstractJdbcDao<T>
extends JdbcDaoSupport
implements JdbcDao {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private String sqlGetTablesVersion = null;
    private String sqlResourcePrefix = null;
    private int tablesVersion = 1;
    private boolean useAutogeneratedKeys = false;
    private Resource initSqlResource = null;
    private String schemaName = "solarnode";
    private String tableName = "sn_settings";
    private MessageSource messageSource = null;
    private String sqlForUpdateSuffix = " FOR UPDATE";
    private OptionalService<EventAdmin> eventAdmin;
    private final Map<String, String> sqlResourceCache = new HashMap<String, String>(10);

    public void init() {
        this.verifyDatabaseExists(this.schemaName, this.tableName, this.initSqlResource);
        try {
            this.upgradeTablesVersion();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to upgrade tables to version " + this.getTablesVersion(), e);
        }
        if (this.messageSource == null) {
            ResourceBundleMessageSource ms = new ResourceBundleMessageSource();
            ms.setBasename(this.getClass().getName());
            ms.setBundleClassLoader(this.getClass().getClassLoader());
            this.setMessageSource((MessageSource)ms);
        }
    }

    protected void insertDomainObject(final T obj, final String sqlInsert) {
        this.getJdbcTemplate().update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                PreparedStatement ps = con.prepareStatement(sqlInsert);
                AbstractJdbcDao.this.setStoreStatementValues(obj, ps);
                return ps;
            }
        });
    }

    protected int updateDomainObject(final T obj, final String sqlUpdate) {
        return this.getJdbcTemplate().update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                PreparedStatement ps = con.prepareStatement(sqlUpdate);
                AbstractJdbcDao.this.setUpdateStatementValues(obj, ps);
                return ps;
            }
        });
    }

    protected void setUpdateStatementValues(T obj, PreparedStatement ps) throws SQLException {
    }

    protected Long storeDomainObject(final T obj, final String sqlInsert) {
        if (!this.useAutogeneratedKeys) {
            return this.storeDomainObjectWithoutAutogeneratedKeys(obj, sqlInsert);
        }
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        this.getJdbcTemplate().update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                PreparedStatement ps = con.prepareStatement(sqlInsert, 1);
                AbstractJdbcDao.this.setStoreStatementValues(obj, ps);
                return ps;
            }
        }, (KeyHolder)keyHolder);
        Map keys = keyHolder.getKeys();
        if (keys != null) {
            for (Object key : keys.values()) {
                if (!(key instanceof Number)) continue;
                return ((Number)key).longValue();
            }
        }
        return null;
    }

    protected void setStoreStatementValues(T obj, PreparedStatement ps) throws SQLException {
    }

    protected Long storeDomainObjectWithoutAutogeneratedKeys(final T obj, final String sqlInsert) {
        Object result = this.getJdbcTemplate().execute(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                PreparedStatement ps = con.prepareStatement(sqlInsert);
                AbstractJdbcDao.this.setStoreStatementValues(obj, ps);
                return ps;
            }
        }, (PreparedStatementCallback)new PreparedStatementCallback<Object>(){

            public Object doInPreparedStatement(PreparedStatement ps) throws SQLException, DataAccessException {
                ResultSet rs;
                ps.execute();
                int count = ps.getUpdateCount();
                if (count == 1 && ps.getMoreResults() && (rs = ps.getResultSet()).next()) {
                    return rs.getObject(1);
                }
                return null;
            }
        });
        if (result instanceof Long) {
            return (Long)result;
        }
        if (result instanceof Number) {
            return ((Number)result).longValue();
        }
        this.log.debug("Non-number primary key [{}] returned from insert of {} using SQL: {}", new Object[]{result, obj, sqlInsert});
        return null;
    }

    protected void verifyDatabaseExists(final String schema, final String table, final Resource initSql) {
        this.getJdbcTemplate().execute((ConnectionCallback)new ConnectionCallback<Object>(){

            public Object doInConnection(Connection con) throws SQLException, DataAccessException {
                String[] initSqlStatements;
                if (!AbstractJdbcDao.this.tableExists(con, schema, table) && (initSqlStatements = AbstractJdbcDao.this.getBatchSqlResource(initSql)) != null) {
                    if (AbstractJdbcDao.this.log.isInfoEnabled()) {
                        AbstractJdbcDao.this.log.info("Initializing database from [" + initSql + ']');
                    }
                    AbstractJdbcDao.this.getJdbcTemplate().batchUpdate(initSqlStatements);
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean schemaExists(Connection conn, String aSchemaName) throws SQLException {
        DatabaseMetaData dbMeta = conn.getMetaData();
        ResultSet rs = null;
        try {
            rs = dbMeta.getSchemas();
            while (rs.next()) {
                String schema = rs.getString(1);
                if (aSchemaName != null && !aSchemaName.equalsIgnoreCase(schema)) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Found schema " + schema);
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean tableExists(Connection conn, String aSchemaName, String aTableName) throws SQLException {
        DatabaseMetaData dbMeta = conn.getMetaData();
        ResultSet rs = null;
        try {
            rs = dbMeta.getTables(null, null, null, null);
            while (rs.next()) {
                String schema = rs.getString(2);
                String table = rs.getString(3);
                if (aSchemaName != null && !aSchemaName.equalsIgnoreCase(schema) || !aTableName.equalsIgnoreCase(table)) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Found table " + schema + '.' + table);
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    protected void upgradeTablesVersion() throws IOException {
        block4: {
            String currVersion = "0";
            try {
                currVersion = (String)this.getJdbcTemplate().queryForObject(this.sqlGetTablesVersion, String.class);
            }
            catch (EmptyResultDataAccessException e) {
                if (!this.log.isInfoEnabled()) break block4;
                this.log.info("Table version setting not found, assuming version 0.");
            }
        }
        for (int curr = Integer.parseInt(currVersion); curr < this.tablesVersion; ++curr) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Updating database tables version from " + curr + " to " + (curr + 1));
            }
            Resource sql = this.initSqlResource.createRelative(this.sqlResourcePrefix + "-update-" + (curr + 1) + ".sql");
            String[] batch = this.getBatchSqlResource(sql);
            int[] result = this.getJdbcTemplate().batchUpdate(batch);
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug("Database tables updated to version " + (curr + 1) + " update results: " + Arrays.toString(result));
        }
    }

    protected String getSqlResource(String classPathResource) {
        return JdbcUtils.getSqlResource(classPathResource, this.getClass(), this.getSqlResourcePrefix(), this.sqlResourceCache);
    }

    protected String getSqlResource(Resource resource) {
        return JdbcUtils.getSqlResource(resource);
    }

    protected String[] getBatchSqlResource(Resource sqlResource) {
        return JdbcUtils.getBatchSqlResource(sqlResource);
    }

    protected final void postEvent(Event event) {
        EventAdmin ea;
        if (event == null) {
            return;
        }
        EventAdmin eventAdmin = ea = this.eventAdmin == null ? null : (EventAdmin)this.eventAdmin.service();
        if (ea == null) {
            return;
        }
        ea.postEvent(event);
    }

    @Override
    public String[] getTableNames() {
        return new String[]{this.getTableName()};
    }

    public String getSqlGetTablesVersion() {
        return this.sqlGetTablesVersion;
    }

    public void setSqlGetTablesVersion(String sqlGetTablesVersion) {
        this.sqlGetTablesVersion = sqlGetTablesVersion;
    }

    public String getSqlResourcePrefix() {
        return this.sqlResourcePrefix;
    }

    public void setSqlResourcePrefix(String sqlResourcePrefix) {
        this.sqlResourcePrefix = sqlResourcePrefix;
    }

    public int getTablesVersion() {
        return this.tablesVersion;
    }

    public void setTablesVersion(int tablesVersion) {
        this.tablesVersion = tablesVersion;
    }

    public boolean isUseAutogeneratedKeys() {
        return this.useAutogeneratedKeys;
    }

    public void setUseAutogeneratedKeys(boolean useAutogeneratedKeys) {
        this.useAutogeneratedKeys = useAutogeneratedKeys;
    }

    public Resource getInitSqlResource() {
        return this.initSqlResource;
    }

    public void setInitSqlResource(Resource initSqlResource) {
        this.initSqlResource = initSqlResource;
    }

    @Override
    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Override
    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public String getSqlForUpdateSuffix() {
        return this.sqlForUpdateSuffix;
    }

    public void setSqlForUpdateSuffix(String sqlForUpdateSuffix) {
        this.sqlForUpdateSuffix = sqlForUpdateSuffix;
    }

    public OptionalService<EventAdmin> getEventAdmin() {
        return this.eventAdmin;
    }

    public void setEventAdmin(OptionalService<EventAdmin> eventAdmin) {
        this.eventAdmin = eventAdmin;
    }
}

