/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.dao.jdbc;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.solarnetwork.dao.jdbc.SQLExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public abstract class AbstractSQLExceptionHandler
implements SQLExceptionHandler {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private List<Pattern> sqlStatePatterns;

    protected SQLException exceptionMatchingSqlStatePattern(SQLException e) {
        SQLException root = e;
        while (root.getNextException() != null) {
            root = root.getNextException();
        }
        String state = root.getSQLState();
        if (state == null) {
            return null;
        }
        List<Pattern> statePatterns = this.getSqlStatePatterns();
        if (statePatterns == null || statePatterns.isEmpty()) {
            return null;
        }
        for (Pattern pat : statePatterns) {
            if (!pat.matcher(state).matches()) continue;
            return root;
        }
        return null;
    }

    public List<Pattern> getSqlStatePatterns() {
        return this.sqlStatePatterns;
    }

    public void setSqlStatePatterns(List<Pattern> sqlStatePatterns) {
        this.sqlStatePatterns = sqlStatePatterns;
    }

    public void setSqlStateRegex(String regexes) {
        ArrayList<Pattern> pats = null;
        String[] list = StringUtils.delimitedListToStringArray((String)regexes, (String)",");
        if (regexes != null && list.length > 0) {
            pats = new ArrayList<Pattern>();
            for (String regex : list) {
                pats.add(Pattern.compile(regex));
            }
        }
        this.setSqlStatePatterns(pats);
    }
}

