/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.dao.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicInteger;
import net.solarnetwork.dao.BasicBatchResult;
import net.solarnetwork.dao.BatchableDao;
import net.solarnetwork.dao.Entity;
import net.solarnetwork.node.dao.jdbc.BaseJdbcGenericDao;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public abstract class BaseJdbcBatchableDao<T extends Entity<K>, K>
extends BaseJdbcGenericDao<T, K>
implements BatchableDao<T> {
    private TransactionTemplate transactionTemplate;
    private String sqlForUpdateSuffix = " FOR UPDATE";

    public BaseJdbcBatchableDao(Class<? extends T> objectType, Class<? extends K> keyType, RowMapper<T> rowMapper) {
        super(objectType, keyType, rowMapper);
    }

    public BaseJdbcBatchableDao(Class<? extends T> objectType, Class<? extends K> keyType, RowMapper<T> rowMapper, String tableNameTemplate, String entityName, int version) {
        super(objectType, keyType, rowMapper, tableNameTemplate, entityName, version);
    }

    protected abstract String getBatchJdbcStatement(BatchableDao.BatchOptions var1);

    protected void prepareBatchStatement(BatchableDao.BatchOptions options, Connection con, PreparedStatement queryStmt) throws SQLException {
    }

    protected abstract T getBatchRowEntity(BatchableDao.BatchOptions var1, ResultSet var2, int var3) throws SQLException;

    protected abstract void updateBatchRowEntity(BatchableDao.BatchOptions var1, ResultSet var2, int var3, T var4) throws SQLException;

    public BatchableDao.BatchResult batchProcess(final BatchableDao.BatchCallback<T> callback, final BatchableDao.BatchOptions options) {
        if (this.transactionTemplate != null) {
            return (BatchableDao.BatchResult)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<BatchableDao.BatchResult>(){

                public BatchableDao.BatchResult doInTransaction(TransactionStatus status) {
                    return BaseJdbcBatchableDao.this.batchProcessInternal(callback, options);
                }
            });
        }
        return this.batchProcessInternal(callback, options);
    }

    private BatchableDao.BatchResult batchProcessInternal(final BatchableDao.BatchCallback<T> callback, final BatchableDao.BatchOptions options) {
        final String querySql = this.getBatchJdbcStatement(options);
        final AtomicInteger rowCount = new AtomicInteger(0);
        this.getJdbcTemplate().execute((ConnectionCallback)new ConnectionCallback<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public BatchableDao.BatchResult doInConnection(Connection con) throws SQLException, DataAccessException {
                PreparedStatement queryStmt = null;
                ResultSet queryResult = null;
                DatabaseMetaData meta = con.getMetaData();
                int scrollType = options.isUpdatable() ? (meta.supportsResultSetType(1005) ? 1005 : 1004) : 1003;
                int concurType = options.isUpdatable() ? 1008 : 1007;
                try {
                    queryStmt = con.prepareStatement(querySql, scrollType, concurType, 2);
                    BaseJdbcBatchableDao.this.prepareBatchStatement(options, con, queryStmt);
                    queryResult = queryStmt.executeQuery();
                    while (queryResult.next()) {
                        Object entity = BaseJdbcBatchableDao.this.getBatchRowEntity(options, queryResult, rowCount.incrementAndGet());
                        BatchableDao.BatchCallbackResult rowResult = callback.handle(entity);
                        switch (rowResult) {
                            case CONTINUE: {
                                break;
                            }
                            case STOP: {
                                BatchableDao.BatchResult batchResult = null;
                                return batchResult;
                            }
                            case DELETE: {
                                queryResult.deleteRow();
                                break;
                            }
                            case UPDATE: 
                            case UPDATE_STOP: {
                                BaseJdbcBatchableDao.this.updateBatchRowEntity(options, queryResult, rowCount.intValue(), entity);
                                queryResult.updateRow();
                                if (rowResult != BatchableDao.BatchCallbackResult.UPDATE_STOP) break;
                                BatchableDao.BatchResult batchResult = null;
                                return batchResult;
                            }
                        }
                    }
                }
                finally {
                    if (queryResult != null) {
                        queryResult.close();
                    }
                    if (queryStmt != null) {
                        queryStmt.close();
                    }
                }
                return null;
            }
        });
        return new BasicBatchResult(rowCount.intValue());
    }

    public TransactionTemplate getTransactionTemplate() {
        return this.transactionTemplate;
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    @Override
    public String getSqlForUpdateSuffix() {
        return this.sqlForUpdateSuffix;
    }

    @Override
    public void setSqlForUpdateSuffix(String sqlForUpdateSuffix) {
        this.sqlForUpdateSuffix = sqlForUpdateSuffix;
    }
}

