/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.dao.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import net.solarnetwork.dao.Entity;
import net.solarnetwork.dao.GenericDao;
import net.solarnetwork.domain.SortDescriptor;
import net.solarnetwork.node.dao.jdbc.AbstractJdbcDao;
import org.osgi.service.event.Event;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.core.RowMapper;

public abstract class BaseJdbcGenericDao<T extends Entity<K>, K>
extends AbstractJdbcDao<T>
implements GenericDao<T, K> {
    public static final String SQL_RESOURCE_PREFIX = "derby-%s";
    public static final String SQL_GET_TABLES_VERSION_FORMAT = "SELECT svalue FROM solarnode.sn_settings WHERE skey = 'solarnode.%s.version'";
    public static final String INIT_SQL_FORMAT = "%s-init.sql";
    public static final String SQL_INSERT = "insert";
    public static final String SQL_UPDATE = "update";
    public static final String SQL_GET_BY_PK = "get-pk";
    public static final String SQL_FIND_ALL = "find-all";
    public static final String SQL_DELETE_BY_PK = "delete-pk";
    public static final String ORDER_BY = "ORDER BY";
    protected static final Calendar UTC_CALENDAR = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
    private final Class<? extends T> objectType;
    private final Class<? extends K> keyType;
    private final RowMapper<T> rowMapper;

    public BaseJdbcGenericDao(Class<? extends T> objectType, Class<? extends K> keyType, RowMapper<T> rowMapper) {
        if (objectType == null) {
            throw new IllegalArgumentException("The objectType parameter must not be null.");
        }
        if (keyType == null) {
            throw new IllegalArgumentException("The keyType parameter must not be null.");
        }
        this.objectType = objectType;
        this.keyType = keyType;
        this.rowMapper = rowMapper;
    }

    public BaseJdbcGenericDao(Class<? extends T> objectType, Class<? extends K> keyType, RowMapper<T> rowMapper, String tableNameTemplate, String entityName, int version) {
        this(objectType, keyType, rowMapper);
        this.setSqlResourcePrefix(String.format(SQL_RESOURCE_PREFIX, entityName));
        this.setTableName(String.format(tableNameTemplate, entityName));
        this.setTablesVersion(version);
        this.setSqlGetTablesVersion(String.format(SQL_GET_TABLES_VERSION_FORMAT, this.getTableName()));
        this.setInitSqlResource((Resource)new ClassPathResource(String.format(INIT_SQL_FORMAT, this.getSqlResourcePrefix()), this.getClass()));
    }

    public Class<? extends T> getObjectType() {
        return this.objectType;
    }

    public Class<? extends K> getKeyType() {
        return this.keyType;
    }

    protected RowMapper<T> getRowMapper() {
        return this.rowMapper;
    }

    public K save(T entity) {
        Object result;
        if (entity.getId() == null) {
            if (!this.isUseAutogeneratedKeys()) {
                throw new IllegalArgumentException("The entity ID must be provided when auto-generated keys are not used.");
            }
            if (!Long.class.isAssignableFrom(this.keyType)) {
                throw new RuntimeException("Only Long entity keys may be used with auto-generated keys.");
            }
            result = this.storeDomainObject(entity, this.getSqlResource(SQL_INSERT));
        } else {
            int count = this.updateDomainObject(entity, this.getSqlResource(SQL_UPDATE));
            if (count == 0) {
                this.insertDomainObject(entity, this.getSqlResource(SQL_INSERT));
            }
            result = entity.getId();
        }
        this.postEntityEvent(result, entity, GenericDao.EntityEventType.STORED);
        return (K)result;
    }

    protected void postEntityEvent(K id, T entity, GenericDao.EntityEventType eventType) {
        if (id == null) {
            return;
        }
        Map props = GenericDao.createEntityEventProperties(id, entity);
        String topic = this.entityEventTopic(eventType);
        if (topic != null) {
            Event event = new Event(topic, props);
            this.postEvent(event);
        }
    }

    public T get(K id) {
        if (id == null) {
            throw new IllegalArgumentException("The id parameter must not be null.");
        }
        return this.findFirst(this.getSqlResource(SQL_GET_BY_PK), this.primaryKeyArguments(id));
    }

    protected T findFirst(String sql, Object ... parameters) {
        List results = this.getJdbcTemplate().query(sql, this.rowMapper, parameters);
        return (T)(results != null && !results.isEmpty() ? (Entity)results.get(0) : null);
    }

    protected Object[] primaryKeyArguments(K id) {
        if (id instanceof UUID) {
            return new Object[]{((UUID)id).getMostSignificantBits(), ((UUID)id).getLeastSignificantBits()};
        }
        return new Object[]{id};
    }

    public Collection<T> getAll(List<SortDescriptor> sorts) {
        return this.getJdbcTemplate().query(this.querySql(SQL_FIND_ALL, sorts), this.rowMapper);
    }

    protected String querySql(String classPathResource, List<SortDescriptor> sorts) {
        String sql = this.getSqlResource(classPathResource);
        List<String> orders = this.sqlOrderClauses(classPathResource, sorts);
        if (orders != null) {
            sql = BaseJdbcGenericDao.applySqlOrderClauses(sql, orders);
        }
        return sql;
    }

    protected List<String> sqlOrderClauses(String classPathResource, List<SortDescriptor> sorts) {
        ArrayList<String> clauses = null;
        if (sorts != null && !sorts.isEmpty()) {
            for (SortDescriptor d : sorts) {
                String clause = null;
                for (GenericDao.StandardSortKey k : GenericDao.StandardSortKey.values()) {
                    String lc = k.toString().toLowerCase();
                    if (!lc.equalsIgnoreCase(d.getSortKey())) continue;
                    clause = BaseJdbcGenericDao.sqlOrderClause(lc, d.isDescending());
                    break;
                }
                if (clause == null) continue;
                if (clauses == null) {
                    clauses = new ArrayList<String>(sorts.size());
                }
                clauses.add(clause);
            }
        }
        return clauses;
    }

    public static String applySqlOrderClauses(String sql, List<String> orderClauses) {
        int len;
        int n = len = orderClauses != null ? orderClauses.size() : 0;
        if (len < 1) {
            return sql;
        }
        StringBuilder buf = new StringBuilder(sql);
        int orderIdx = sql.toUpperCase().lastIndexOf(ORDER_BY);
        if (orderIdx < 0) {
            buf.append(' ').append(ORDER_BY);
        } else {
            buf.delete(orderIdx + ORDER_BY.length(), buf.length());
        }
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append(' ');
            buf.append(orderClauses.get(i));
        }
        return buf.toString();
    }

    public static String sqlOrderClause(String columnName, boolean descending) {
        return columnName + " " + (descending ? "DESC" : "ASC");
    }

    public void delete(T entity) {
        if (entity == null || entity.getId() == null) {
            throw new IllegalArgumentException("The entity id parameter must not be null.");
        }
        this.getJdbcTemplate().update(this.getSqlResource(SQL_DELETE_BY_PK), this.primaryKeyArguments(entity.getId()));
        this.postEntityEvent(entity.getId(), entity, GenericDao.EntityEventType.DELETED);
    }

    public static void setInstantParameter(PreparedStatement stmt, int parameterIndex, Instant time) throws SQLException {
        if (time == null) {
            stmt.setNull(parameterIndex, 93);
        } else {
            stmt.setTimestamp(parameterIndex, new Timestamp(time.toEpochMilli()), (Calendar)UTC_CALENDAR.clone());
        }
    }

    public static Instant getInstantColumn(ResultSet rs, int columnIndex) throws SQLException {
        Timestamp ts = rs.getTimestamp(columnIndex, (Calendar)UTC_CALENDAR.clone());
        return ts != null ? Instant.ofEpochMilli(ts.getTime()) : null;
    }

    public static void setUuidParameters(PreparedStatement stmt, int parameterIndex, UUID uuid) throws SQLException {
        stmt.setLong(parameterIndex, uuid.getMostSignificantBits());
        stmt.setLong(parameterIndex + 1, uuid.getLeastSignificantBits());
    }

    public static UUID getUuidColumns(ResultSet rs, int columnIndex) throws SQLException {
        long hi = rs.getLong(columnIndex);
        if (rs.wasNull()) {
            return null;
        }
        long lo = rs.getLong(columnIndex + 1);
        if (rs.wasNull()) {
            return null;
        }
        return new UUID(hi, lo);
    }
}

