/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.dao.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import net.solarnetwork.node.dao.jdbc.AbstractJdbcDao;
import net.solarnetwork.node.domain.datum.NodeDatum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;

public class DatabaseSetup {
    public static final String DEFAULT_INIT_SQL_RESOURCE = "derby-init.sql";
    public static final String DEFAULT_SQL_GET_TABLES_VERSION = "SELECT svalue FROM solarnode.sn_settings WHERE skey = 'solarnode.sn_settings.version'";
    private static final int TABLES_VERSION = 6;
    private DataSource dataSource = null;
    private Resource initSqlResource = new ClassPathResource("derby-init.sql", DatabaseSetup.class);
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public void init() {
        JdbcDao dao = new JdbcDao();
        try {
            dao.init();
        }
        catch (RuntimeException e) {
            this.log.error("Error initializing database", (Throwable)e);
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Resource getInitSqlResource() {
        return this.initSqlResource;
    }

    public void setInitSqlResource(Resource initSqlResource) {
        this.initSqlResource = initSqlResource;
    }

    private class JdbcDao
    extends AbstractJdbcDao<NodeDatum> {
        private static final String CREATE_SCHEMA_SQL_TEMPLATE = "CREATE SCHEMA %s";

        private JdbcDao() {
            this.setDataSource(DatabaseSetup.this.dataSource);
            this.setInitSqlResource(DatabaseSetup.this.initSqlResource);
            this.setSchemaName("solarnode");
            this.setTableName("sn_settings");
            this.setTablesVersion(6);
            this.setSqlGetTablesVersion(DatabaseSetup.DEFAULT_SQL_GET_TABLES_VERSION);
            this.setSqlResourcePrefix("derby-init");
        }

        @Override
        public MessageSource getMessageSource() {
            return null;
        }

        @Override
        protected void verifyDatabaseExists(final String schema, String table, Resource initSql) {
            this.getJdbcTemplate().execute((ConnectionCallback)new ConnectionCallback<Object>(){

                public Object doInConnection(Connection con) throws SQLException, DataAccessException {
                    if (!JdbcDao.this.schemaExists(con, schema)) {
                        try (Statement stmt = null;){
                            stmt = con.prepareStatement(String.format(JdbcDao.CREATE_SCHEMA_SQL_TEMPLATE, schema));
                            JdbcDao.this.log.info("Initializing database schema [{}]", (Object)schema);
                            stmt.executeUpdate();
                        }
                    }
                    return null;
                }
            });
            super.verifyDatabaseExists(schema, table, initSql);
        }
    }
}

