/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.dao.jdbc;

import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.DateCellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.exception.SuperCsvCellProcessorException;
import org.supercsv.util.CsvContext;

public class JdbcFmtDate
extends CellProcessorAdaptor
implements DateCellProcessor {
    private final DateTimeFormatter dateFormatter;

    public JdbcFmtDate(DateTimeFormatter dateFormatter) {
        this.dateFormatter = dateFormatter;
    }

    public JdbcFmtDate(DateTimeFormatter dateFormatter, StringCellProcessor next) {
        super((CellProcessor)next);
        this.dateFormatter = dateFormatter;
    }

    public <T> T execute(Object value, CsvContext context) {
        String result;
        this.validateInputNotNull(value, context);
        if (value instanceof java.util.Date) {
            result = this.dateFormatter.format(((java.util.Date)value).toInstant());
        } else if (value instanceof Calendar) {
            result = this.dateFormatter.format(((Calendar)value).getTime().toInstant());
        } else if (value instanceof TemporalAccessor) {
            result = this.dateFormatter.format((TemporalAccessor)value);
        } else {
            throw new SuperCsvCellProcessorException(java.util.Date.class, value, context, (CellProcessor)this);
        }
        return (T)this.next.execute((Object)result, context);
    }

    public static final class Time
    extends JdbcFmtDate {
        public Time() {
            super(DateTimeFormatter.ISO_LOCAL_TIME);
        }

        public Time(StringCellProcessor next) {
            super(DateTimeFormatter.ISO_LOCAL_TIME, next);
        }
    }

    public static final class Date
    extends JdbcFmtDate {
        public Date() {
            super(DateTimeFormatter.ISO_LOCAL_DATE);
        }

        public Date(StringCellProcessor next) {
            super(DateTimeFormatter.ISO_LOCAL_DATE, next);
        }
    }

    public static final class Timestamp
    extends JdbcFmtDate {
        public Timestamp() {
            super(DateTimeFormatter.ISO_INSTANT);
        }

        public Timestamp(StringCellProcessor next) {
            super(DateTimeFormatter.ISO_INSTANT, next);
        }
    }
}

