/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.dao.jdbc;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.DateCellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.util.CsvContext;

public abstract class JdbcParseDate
extends CellProcessorAdaptor
implements StringCellProcessor {
    protected final DateTimeFormatter dateFormatter;

    private JdbcParseDate(DateTimeFormatter dateFormatter) {
        this.dateFormatter = dateFormatter;
    }

    private JdbcParseDate(DateTimeFormatter dateFormatter, DateCellProcessor next) {
        super((CellProcessor)next);
        this.dateFormatter = dateFormatter;
    }

    protected abstract Object parseObject(Object var1, CsvContext var2);

    public <T> T execute(Object value, CsvContext context) {
        this.validateInputNotNull(value, context);
        Object result = this.parseObject(value, context);
        return (T)this.next.execute(result, context);
    }

    public static final class Time
    extends JdbcParseDate {
        public Time() {
            super(DateTimeFormatter.ISO_LOCAL_TIME);
        }

        public Time(DateCellProcessor next) {
            super(DateTimeFormatter.ISO_LOCAL_TIME, next);
        }

        @Override
        protected Object parseObject(Object value, CsvContext context) {
            return java.sql.Time.valueOf(this.dateFormatter.parse((CharSequence)value.toString(), LocalTime::from));
        }
    }

    public static final class Date
    extends JdbcParseDate {
        public Date() {
            super(DateTimeFormatter.ISO_LOCAL_DATE);
        }

        public Date(DateCellProcessor next) {
            super(DateTimeFormatter.ISO_LOCAL_DATE, next);
        }

        @Override
        protected Object parseObject(Object value, CsvContext context) {
            return java.sql.Date.valueOf(this.dateFormatter.parse((CharSequence)value.toString(), LocalDate::from));
        }
    }

    public static final class Timestamp
    extends JdbcParseDate {
        public Timestamp() {
            super(DateTimeFormatter.ISO_INSTANT);
        }

        public Timestamp(DateCellProcessor next) {
            super(DateTimeFormatter.ISO_INSTANT, next);
        }

        @Override
        protected Object parseObject(Object value, CsvContext context) {
            return java.sql.Timestamp.from(this.dateFormatter.parse((CharSequence)value.toString(), Instant::from));
        }
    }
}

