/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.dao.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.solarnetwork.domain.KeyValuePair;
import net.solarnetwork.node.dao.BatchableDao;
import net.solarnetwork.node.dao.SettingDao;
import net.solarnetwork.node.dao.jdbc.AbstractBatchableJdbcDao;
import net.solarnetwork.node.domain.Setting;
import net.solarnetwork.service.OptionalService;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class JdbcSettingDao
extends AbstractBatchableJdbcDao<Setting>
implements SettingDao {
    public static final String SQL_RESOURCE_NON_TYPED_GET = "non-typed-get";
    public static final String SQL_RESOURCE_TYPED_GET = "typed-get";
    public static final String SQL_RESOURCE_FIND = "find";
    public static final String SQL_RESOURCE_BATCH_GET_FOR_UPDATE = "batch-get-for-update";
    public static final String SQL_RESOURCE_BATCH_GET = "batch-get";
    public static final String SQL_RESOURCE_GET_DATE = "get-date";
    public static final String SQL_RESOURCE_GET_MOST_RECENT_DATE = "get-most-recent-date";
    private OptionalService<EventAdmin> eventAdmin;

    public JdbcSettingDao() {
        this.setSqlResourcePrefix("derby-settings");
    }

    public boolean deleteSetting(String key) {
        return this.deleteSetting(key, null);
    }

    public String getSetting(String key) {
        return this.getSetting(key, "");
    }

    public void storeSetting(String key, String value) {
        this.storeSetting(key, "", value);
    }

    public boolean deleteSetting(final String key, final String type) {
        TransactionTemplate tt = this.getTransactionTemplate();
        if (tt != null) {
            return (Boolean)tt.execute((TransactionCallback)new TransactionCallback<Boolean>(){

                public Boolean doInTransaction(TransactionStatus status) {
                    return JdbcSettingDao.this.deleteSettingInternal(key, type);
                }
            });
        }
        return this.deleteSettingInternal(key, type);
    }

    private String sqlForUpdate(String sql) {
        return this.getSqlForUpdateSuffix() != null ? sql + this.getSqlForUpdateSuffix() : sql;
    }

    private boolean deleteSettingInternal(final String key, final String type) {
        boolean result;
        final String sql = type == null ? this.sqlForUpdate(this.getSqlResource(SQL_RESOURCE_NON_TYPED_GET)) : this.sqlForUpdate(this.getSqlResource(SQL_RESOURCE_TYPED_GET));
        Setting setting = (Setting)this.getJdbcTemplate().query(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                PreparedStatement queryStmt = con.prepareStatement(sql, 1003, 1008, 2);
                queryStmt.setString(1, key);
                if (type != null) {
                    queryStmt.setString(2, type);
                }
                return queryStmt;
            }
        }, (ResultSetExtractor)new ResultSetExtractor<Setting>(){

            public Setting extractData(ResultSet rs) throws SQLException, DataAccessException {
                Setting s = null;
                while (rs.next()) {
                    s = JdbcSettingDao.this.getBatchRowEntity(null, rs, 1);
                    rs.deleteRow();
                }
                return s;
            }
        });
        boolean bl = result = setting != null;
        if (setting != null && setting.getFlags() != null && !setting.getFlags().contains(Setting.SettingFlag.Volatile)) {
            this.postSettingUpdatedEvent(key, type, setting.getValue());
        }
        return result;
    }

    public String getSetting(String key, String type) {
        List res = this.getJdbcTemplate().query(this.getSqlResource(SQL_RESOURCE_TYPED_GET), (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getString(1);
            }
        }, new Object[]{key, type});
        if (res != null && res.size() > 0) {
            return (String)res.get(0);
        }
        return null;
    }

    public List<KeyValuePair> getSettingValues(String key) {
        return this.getJdbcTemplate().query(this.getSqlResource(SQL_RESOURCE_FIND), (RowMapper)new RowMapper<KeyValuePair>(){

            public KeyValuePair mapRow(ResultSet rs, int rowNum) throws SQLException {
                return new KeyValuePair(rs.getString(1), rs.getString(2));
            }
        }, new Object[]{key});
    }

    public void storeSetting(final String key, final String type, final String value) {
        TransactionTemplate tt = this.getTransactionTemplate();
        if (tt != null) {
            tt.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus status) {
                    JdbcSettingDao.this.storeSettingInternal(key, type, value, 0);
                }
            });
        } else {
            this.storeSettingInternal(key, type, value, 0);
        }
    }

    public void storeSetting(final Setting setting) {
        TransactionTemplate tt = this.getTransactionTemplate();
        if (tt != null) {
            tt.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus status) {
                    JdbcSettingDao.this.storeSettingInternal(setting.getKey(), setting.getType(), setting.getValue(), Setting.SettingFlag.maskForSet((Set)setting.getFlags()));
                }
            });
        } else {
            this.storeSettingInternal(setting.getKey(), setting.getType(), setting.getValue(), Setting.SettingFlag.maskForSet((Set)setting.getFlags()));
        }
    }

    public Setting readSetting(String key, String type) {
        List res = this.getJdbcTemplate().query(this.getSqlResource(SQL_RESOURCE_TYPED_GET), (RowMapper)new RowMapper<Setting>(){

            public Setting mapRow(ResultSet rs, int rowNum) throws SQLException {
                return JdbcSettingDao.this.getBatchRowEntity(null, rs, rowNum);
            }
        }, new Object[]{key, type});
        if (res != null && res.size() > 0) {
            return (Setting)res.get(0);
        }
        return null;
    }

    private void storeSettingInternal(final String key, String ttype, final String value, final int flags) {
        final String type = ttype == null ? "" : ttype;
        final Timestamp now = new Timestamp(System.currentTimeMillis());
        final String sql = this.sqlForUpdate(this.getSqlResource(SQL_RESOURCE_TYPED_GET));
        this.getJdbcTemplate().execute((ConnectionCallback)new ConnectionCallback<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean doInConnection(Connection con) throws SQLException, DataAccessException {
                boolean updated;
                ResultSet rs;
                block12: {
                    Statement stmt = null;
                    rs = null;
                    updated = false;
                    try {
                        stmt = con.prepareStatement(sql, 1003, 1008, 2);
                        stmt.setString(1, key);
                        stmt.setString(2, type);
                        if (stmt.execute()) {
                            rs = stmt.getResultSet();
                            if (rs.next()) {
                                String oldValue = rs.getString(1);
                                if (!value.equals(oldValue)) {
                                    rs.updateString(1, value);
                                    rs.updateTimestamp(2, now);
                                    rs.updateRow();
                                    updated = true;
                                }
                            } else {
                                rs.moveToInsertRow();
                                rs.updateString(1, value);
                                rs.updateTimestamp(2, now);
                                rs.updateString(3, key);
                                rs.updateString(4, type);
                                rs.updateInt(5, flags);
                                rs.insertRow();
                                updated = true;
                            }
                        }
                        if (stmt == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (stmt != null) {
                            SQLWarning warning = stmt.getWarnings();
                            if (warning != null) {
                                JdbcSettingDao.this.log.warn("SQL warning saving setting {}.{} to {}", new Object[]{key, type, value, warning});
                            }
                            stmt.close();
                        }
                        if (rs != null) {
                            rs.close();
                        }
                        throw throwable;
                    }
                    SQLWarning warning = stmt.getWarnings();
                    if (warning != null) {
                        JdbcSettingDao.this.log.warn("SQL warning saving setting {}.{} to {}", new Object[]{key, type, value, warning});
                    }
                    stmt.close();
                }
                if (rs != null) {
                    rs.close();
                }
                if (updated && !Setting.SettingFlag.setForMask((int)flags).contains(Setting.SettingFlag.Volatile)) {
                    JdbcSettingDao.this.postSettingUpdatedEvent(key, type, value);
                }
                return updated;
            }
        });
    }

    public Date getSettingModificationDate(final String key, final String type) {
        return (Date)this.getJdbcTemplate().query(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                PreparedStatement stmt = con.prepareStatement(JdbcSettingDao.this.getSqlResource(JdbcSettingDao.SQL_RESOURCE_GET_DATE));
                stmt.setMaxRows(1);
                stmt.setString(1, key);
                stmt.setString(2, type);
                return stmt;
            }
        }, (ResultSetExtractor)new ResultSetExtractor<Date>(){

            public Date extractData(ResultSet rs) throws SQLException, DataAccessException {
                if (rs.next()) {
                    return rs.getTimestamp(1);
                }
                return null;
            }
        });
    }

    public Date getMostRecentModificationDate() {
        return (Date)this.getJdbcTemplate().query(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                PreparedStatement stmt = con.prepareStatement(JdbcSettingDao.this.getSqlResource(JdbcSettingDao.SQL_RESOURCE_GET_MOST_RECENT_DATE));
                stmt.setMaxRows(1);
                int mask = Setting.SettingFlag.maskForSet(EnumSet.of(Setting.SettingFlag.IgnoreModificationDate));
                stmt.setInt(1, mask);
                stmt.setInt(2, mask);
                return stmt;
            }
        }, (ResultSetExtractor)new ResultSetExtractor<Date>(){

            public Date extractData(ResultSet rs) throws SQLException, DataAccessException {
                if (rs.next()) {
                    return rs.getTimestamp(1);
                }
                return null;
            }
        });
    }

    @Override
    protected String getBatchJdbcStatement(BatchableDao.BatchOptions options) {
        return options != null && options.isUpdatable() ? this.getSqlResource(SQL_RESOURCE_BATCH_GET_FOR_UPDATE) : this.getSqlResource(SQL_RESOURCE_BATCH_GET);
    }

    @Override
    protected Setting getBatchRowEntity(BatchableDao.BatchOptions options, ResultSet resultSet, int rowCount) throws SQLException {
        Setting s = new Setting();
        s.setValue(resultSet.getString(1));
        s.setModified((Date)resultSet.getTimestamp(2));
        s.setKey(resultSet.getString(3));
        s.setType(resultSet.getString(4));
        s.setFlags(Setting.SettingFlag.setForMask((int)resultSet.getInt(5)));
        return s;
    }

    @Override
    protected void updateBatchRowEntity(BatchableDao.BatchOptions options, ResultSet resultSet, int rowCount, Setting entity) throws SQLException {
        resultSet.updateString(1, entity.getValue());
        resultSet.updateTimestamp(2, new Timestamp(System.currentTimeMillis()));
        resultSet.updateString(3, entity.getKey());
        resultSet.updateString(4, entity.getType());
        resultSet.updateInt(5, Setting.SettingFlag.maskForSet((Set)entity.getFlags()));
    }

    private final void postSettingUpdatedEvent(String key, String type, String value) {
        EventAdmin ea;
        EventAdmin eventAdmin = ea = this.eventAdmin == null ? null : (EventAdmin)this.eventAdmin.service();
        if (ea == null) {
            return;
        }
        HashMap<String, String> props = new HashMap<String, String>();
        if (key != null) {
            props.put("Key", key);
        }
        if (type != null) {
            props.put("Type", type);
        }
        if (value != null) {
            props.put("Value", value);
        }
        Event event = new Event("net/solarnetwork/node/dao/SETTING_CHANGED", props);
        ea.postEvent(event);
    }

    public OptionalService<EventAdmin> getEventAdmin() {
        return this.eventAdmin;
    }

    public void setEventAdmin(OptionalService<EventAdmin> eventAdmin) {
        this.eventAdmin = eventAdmin;
    }
}

