/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.dao.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import net.solarnetwork.node.backup.BackupResource;
import net.solarnetwork.node.backup.BackupResourceInfo;
import net.solarnetwork.node.backup.BackupResourceProvider;
import net.solarnetwork.node.backup.BackupResourceProviderInfo;
import net.solarnetwork.node.backup.SimpleBackupResourceInfo;
import net.solarnetwork.node.backup.SimpleBackupResourceProviderInfo;
import net.solarnetwork.node.dao.jdbc.ColumnCsvMetaData;
import net.solarnetwork.node.dao.jdbc.JdbcUtils;
import net.solarnetwork.node.dao.jdbc.PreparedStatementCsvReader;
import net.solarnetwork.node.dao.jdbc.ResultSetCsvWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.core.task.TaskExecutor;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.StringUtils;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.prefs.CsvPreference;

public class JdbcTableBackupResourceProvider
implements BackupResourceProvider {
    private final String key;
    private final JdbcTemplate jdbcTemplate;
    private final TransactionTemplate transactionTemplate;
    private final TaskExecutor taskExecutor;
    private MessageSource messageSource;
    private String[] tableNames;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public JdbcTableBackupResourceProvider(JdbcTemplate jdbcTemplate, TransactionTemplate transactionTemplate, TaskExecutor taskExecutor) {
        this("net.solarnetwork.node.dao.jdbc.JdbcTableBackupResourceProvider", jdbcTemplate, transactionTemplate, taskExecutor);
    }

    public JdbcTableBackupResourceProvider(String key, JdbcTemplate jdbcTemplate, TransactionTemplate transactionTemplate, TaskExecutor taskExecutor) {
        this.key = key;
        this.jdbcTemplate = jdbcTemplate;
        this.transactionTemplate = transactionTemplate;
        this.taskExecutor = taskExecutor;
    }

    public String getKey() {
        return this.key;
    }

    public Iterable<BackupResource> getBackupResources() {
        ArrayList<BackupResource> result = new ArrayList<BackupResource>(this.tableNames.length);
        for (String tableName : this.tableNames) {
            result.add(new JdbcTableBackupResource(tableName, CsvPreference.STANDARD_PREFERENCE));
        }
        return result;
    }

    public boolean restoreBackupResource(final BackupResource resource) {
        if (resource == null) {
            return false;
        }
        final String tableName = StringUtils.stripFilenameExtension((String)resource.getBackupPath());
        if (tableName == null || tableName.length() < 1) {
            return false;
        }
        return (Boolean)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Boolean>(){

            public Boolean doInTransaction(TransactionStatus status) {
                return (Boolean)JdbcTableBackupResourceProvider.this.jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Boolean>(){

                    public Boolean doInConnection(Connection con) throws SQLException, DataAccessException {
                        return JdbcTableBackupResourceProvider.this.restoreWithConnection(resource, con, tableName);
                    }
                });
            }
        });
    }

    public BackupResourceProviderInfo providerInfo(Locale locale) {
        String name = "Database Table Backup Provider";
        String desc = "Backs up the SolarNode database tables.";
        MessageSource ms = this.messageSource;
        if (ms != null) {
            name = ms.getMessage("title", null, name, locale);
            desc = ms.getMessage("desc", null, desc, locale);
        }
        return new SimpleBackupResourceProviderInfo(this.getKey(), name, desc);
    }

    public BackupResourceInfo resourceInfo(BackupResource resource, Locale locale) {
        return new SimpleBackupResourceInfo(resource.getProviderKey(), resource.getBackupPath(), null);
    }

    private boolean restoreWithConnection(BackupResource resource, Connection con, String tableName) throws SQLException {
        Map<String, ColumnCsvMetaData> columnMetaData = JdbcUtils.columnCsvMetaDataForDatabaseMetaData(con.getMetaData(), tableName);
        String sql = JdbcUtils.insertSqlForColumnCsvMetaData(tableName, columnMetaData);
        PreparedStatement ps = con.prepareStatement(sql);
        PreparedStatementCsvReader reader = null;
        try {
            InputStreamReader in = new InputStreamReader(resource.getInputStream());
            reader = new PreparedStatementCsvReader(in, CsvPreference.STANDARD_PREFERENCE);
            String[] header = reader.getHeader(true);
            if (header == null) {
                this.log.info("No data provided in backup resource for table {}", (Object)tableName);
                boolean bl = true;
                return bl;
            }
            Map<String, Integer> csvColumns = JdbcUtils.csvColumnIndexMapping(header);
            CellProcessor[] cellProcessors = JdbcUtils.parsingCellProcessorsForCsvColumns(header, columnMetaData);
            while (reader.read(ps, csvColumns, cellProcessors, columnMetaData)) {
                Savepoint sp = con.setSavepoint();
                try {
                    ps.executeUpdate();
                }
                catch (SQLException e) {
                    DataAccessException dae = this.jdbcTemplate.getExceptionTranslator().translate("Load CSV", sql, e);
                    if (dae instanceof DataIntegrityViolationException) {
                        this.log.debug("Ignoring {} CSV duplicate import row {}", (Object)tableName, (Object)reader.getRowNumber());
                        con.rollback(sp);
                        continue;
                    }
                    throw e;
                }
            }
        }
        catch (IOException e) {
            throw new DataAccessResourceFailureException("CSV encoding error", (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            try {
                ps.close();
            }
            catch (SQLException sQLException) {}
        }
        return true;
    }

    public void setTableNames(String[] tableNames) {
        this.tableNames = tableNames;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    private final class JdbcTableBackupResource
    implements BackupResource {
        private final long modTime;
        private final String tableName;
        private final CsvPreference preference;

        private JdbcTableBackupResource(String tableName, CsvPreference preference) {
            this.tableName = tableName;
            this.modTime = System.currentTimeMillis();
            this.preference = preference;
        }

        public String getProviderKey() {
            return JdbcTableBackupResourceProvider.this.getKey();
        }

        public String getBackupPath() {
            return this.tableName + ".csv";
        }

        public long getModificationDate() {
            return this.modTime;
        }

        public InputStream getInputStream() throws IOException {
            PipedOutputStream sink = new PipedOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)sink, "UTF-8");
            PipedInputStream result = new PipedInputStream(sink);
            JdbcTableBackupResourceProvider.this.taskExecutor.execute((Runnable)new JdbcTableCsvExporter(this.tableName, writer, this.preference));
            return result;
        }

        public String getSha256Digest() {
            return null;
        }
    }

    private final class JdbcTableCsvExporter
    implements Runnable {
        private final String sqlQuery;
        private final Writer out;
        private final CsvPreference preference;

        private JdbcTableCsvExporter(String tableName, Writer out, CsvPreference preference) {
            this.sqlQuery = "SELECT * FROM " + tableName;
            this.out = out;
            this.preference = preference;
        }

        @Override
        public void run() {
            JdbcTableBackupResourceProvider.this.jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Object>(){

                public Object doInConnection(Connection con) throws SQLException, DataAccessException {
                    try {
                        JdbcTableCsvExporter.this.exportTable(con);
                    }
                    catch (IOException e) {
                        JdbcTableBackupResourceProvider.this.log.debug("IOException exporting table to CSV", (Throwable)e);
                    }
                    return null;
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void exportTable(Connection con) throws SQLException, IOException {
            Statement stmt = con.createStatement(1003, 1007);
            try {
                ResultSet rs = stmt.executeQuery(this.sqlQuery);
                CellProcessor[] cellProcessors = JdbcUtils.formattingProcessorsForResultSetMetaData(rs.getMetaData());
                ResultSetCsvWriter writer = new ResultSetCsvWriter(this.out, this.preference);
                try {
                    while (rs.next()) {
                        writer.write(rs, cellProcessors);
                    }
                }
                finally {
                    if (writer != null) {
                        try {
                            writer.flush();
                            writer.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
    }
}

