/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.dao.jdbc;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import net.solarnetwork.node.dao.jdbc.ColumnCsvMetaData;
import net.solarnetwork.node.dao.jdbc.JdbcFmtBytes;
import net.solarnetwork.node.dao.jdbc.JdbcFmtDate;
import net.solarnetwork.node.dao.jdbc.JdbcParseBytes;
import net.solarnetwork.node.dao.jdbc.JdbcParseDate;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ConvertNullTo;
import org.supercsv.cellprocessor.Optional;
import org.supercsv.cellprocessor.ParseBigDecimal;
import org.supercsv.cellprocessor.ParseBool;
import org.supercsv.cellprocessor.ift.CellProcessor;

public abstract class JdbcUtils {
    private JdbcUtils() {
    }

    public static CellProcessor[] formattingProcessorsForResultSetMetaData(ResultSetMetaData meta) throws SQLException {
        int colCount = meta.getColumnCount();
        CellProcessor[] cellProcessors = new CellProcessor[colCount];
        for (int i = 0; i < colCount; ++i) {
            ConvertNullTo processor = null;
            int sqlType = meta.getColumnType(i + 1);
            switch (sqlType) {
                case -4: 
                case -3: 
                case -2: {
                    processor = new ConvertNullTo((Object)"", (CellProcessor)new JdbcFmtBytes());
                    break;
                }
                case 91: {
                    processor = new ConvertNullTo((Object)"", (CellProcessor)new JdbcFmtDate.Date());
                    break;
                }
                case 92: {
                    processor = new ConvertNullTo((Object)"", (CellProcessor)new JdbcFmtDate.Time());
                    break;
                }
                case 93: 
                case 2014: {
                    processor = new ConvertNullTo((Object)"", (CellProcessor)new JdbcFmtDate.Timestamp());
                }
            }
            cellProcessors[i] = processor;
        }
        return cellProcessors;
    }

    public static CellProcessor[] parsingCellProcessorsForCsvColumns(String[] csvColumns, Map<String, ColumnCsvMetaData> columnMetaData) {
        CellProcessor[] result = new CellProcessor[csvColumns.length];
        int i = 0;
        for (String colName : csvColumns) {
            ColumnCsvMetaData meta = columnMetaData.get(colName);
            result[i++] = meta != null && meta.getCellProcessor() != null ? meta.getCellProcessor() : new Optional();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, ColumnCsvMetaData> columnCsvMetaDataForDatabaseMetaData(DatabaseMetaData meta, String tableName) throws SQLException {
        String colName;
        String[] names = tableName.toUpperCase().split("\\.", 2);
        String schema = names.length == 2 ? names[0] : null;
        String table = names.length == 2 ? names[1] : names[0];
        LinkedHashMap<String, ColumnCsvMetaData> results = new LinkedHashMap<String, ColumnCsvMetaData>(8);
        try (ResultSet rs = meta.getColumns(null, schema, table, null);){
            while (rs.next()) {
                colName = rs.getString(4);
                int sqlType = rs.getInt(5);
                CellProcessorAdaptor processor = null;
                switch (sqlType) {
                    case -4: 
                    case -3: 
                    case -2: {
                        processor = new JdbcParseBytes();
                        break;
                    }
                    case 16: {
                        processor = new ParseBool();
                        break;
                    }
                    case 91: {
                        processor = new JdbcParseDate.Date();
                        break;
                    }
                    case 92: {
                        processor = new JdbcParseDate.Time();
                        break;
                    }
                    case 93: 
                    case 2014: {
                        processor = new JdbcParseDate.Timestamp();
                        break;
                    }
                    case -6: 
                    case -5: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        processor = new ParseBigDecimal();
                    }
                }
                results.put(colName, new ColumnCsvMetaData(colName, (CellProcessor)(processor == null ? new Optional() : new Optional((CellProcessor)processor)), sqlType));
            }
        }
        rs = meta.getPrimaryKeys(null, schema, table);
        try {
            while (rs.next()) {
                colName = rs.getString(4);
                ColumnCsvMetaData colMeta = (ColumnCsvMetaData)results.get(colName);
                if (colMeta == null) continue;
                results.put(colName, colMeta.asPrimaryKeyColumn());
            }
        }
        finally {
            rs.close();
        }
        return results;
    }

    public static String insertSqlForColumnCsvMetaData(String tableName, Map<String, ColumnCsvMetaData> columnMetaData) {
        StringBuilder sql = new StringBuilder("INSERT INTO ").append(tableName).append(" (");
        StringBuilder values = new StringBuilder();
        int i = 0;
        for (Map.Entry<String, ColumnCsvMetaData> me : columnMetaData.entrySet()) {
            if (i > 0) {
                sql.append(",");
                values.append(",");
            }
            sql.append(me.getKey());
            values.append("?");
            ++i;
        }
        sql.append(") VALUES (").append((CharSequence)values).append(")");
        return sql.toString();
    }

    public static Map<String, Integer> csvColumnIndexMapping(String[] header) {
        LinkedHashMap<String, Integer> csvColumns = new LinkedHashMap<String, Integer>();
        for (int i = 0; i < header.length; ++i) {
            csvColumns.put(header[i], i);
        }
        return csvColumns;
    }

    public static String getSqlResource(String classPathResource, Class<?> resourceClass, String prefix, Map<String, String> sqlResourceCache) {
        Class<?> myClass = resourceClass;
        String resourceName = prefix + "-" + classPathResource + ".sql";
        String key = myClass.getName() + ";" + classPathResource;
        if (sqlResourceCache.containsKey(key)) {
            return sqlResourceCache.get(key);
        }
        String[] prefixes = prefix.split("-");
        try {
            ClassPathResource r = new ClassPathResource(resourceName, myClass);
            for (int prefixEndIndex = prefixes.length - 1; !r.exists() && prefixEndIndex >= 0; --prefixEndIndex) {
                String subName;
                if (prefixEndIndex > 0) {
                    Object[] subPrefixes = new String[prefixEndIndex];
                    System.arraycopy(prefixes, prefixEndIndex, subPrefixes, 0, prefixEndIndex);
                    subName = StringUtils.arrayToDelimitedString((Object[])subPrefixes, (String)"-") + "-" + classPathResource;
                } else {
                    subName = classPathResource;
                }
                subName = subName + ".sql";
                r = new ClassPathResource(subName, myClass);
            }
            if (!r.exists()) {
                throw new RuntimeException("SQL resource " + resourceName + " not found");
            }
            String result = FileCopyUtils.copyToString((Reader)new InputStreamReader(r.getInputStream()));
            if (result != null && result.length() > 0) {
                sqlResourceCache.put(key, result);
            }
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSqlResource(Resource resource) {
        try {
            return FileCopyUtils.copyToString((Reader)new InputStreamReader(resource.getInputStream()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String[] getBatchSqlResource(Resource sqlResource) {
        String sql = JdbcUtils.getSqlResource(sqlResource);
        if (sql == null) {
            return null;
        }
        return sql.split(";\\s*");
    }
}

