/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.dao.jdbc;

import java.io.IOException;
import java.io.Reader;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;
import net.solarnetwork.node.dao.jdbc.ColumnCsvMetaData;
import net.solarnetwork.node.dao.jdbc.JdbcPreparedStatementCsvReader;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.io.AbstractCsvReader;
import org.supercsv.io.ITokenizer;
import org.supercsv.prefs.CsvPreference;

public class PreparedStatementCsvReader
extends AbstractCsvReader
implements JdbcPreparedStatementCsvReader {
    public PreparedStatementCsvReader(ITokenizer tokenizer, CsvPreference preferences) throws SQLException {
        super(tokenizer, preferences);
    }

    public PreparedStatementCsvReader(Reader reader, CsvPreference preferences) throws SQLException {
        super(reader, preferences);
    }

    @Override
    public boolean read(PreparedStatement stmt, Map<String, Integer> csvColumns, CellProcessor[] cellProcessors, Map<String, ColumnCsvMetaData> columnMetaData) throws SQLException, IOException {
        ArrayList processed = new ArrayList(csvColumns.size());
        if (this.readRow()) {
            ArrayList columnValues;
            if (cellProcessors != null) {
                this.executeProcessors(processed, cellProcessors);
                columnValues = processed;
            } else {
                columnValues = this.getColumns();
            }
            int i = 1;
            Calendar utcCalendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            for (Map.Entry<String, ColumnCsvMetaData> me : columnMetaData.entrySet()) {
                Integer csvColumnIndex = csvColumns.get(me.getKey());
                Object columnValue = csvColumnIndex == null ? null : columnValues.get(csvColumnIndex);
                int sqlType = me.getValue().getSqlType();
                if (columnValue == null) {
                    stmt.setNull(i, sqlType);
                } else if (columnValue instanceof Date) {
                    stmt.setDate(i, columnValue, utcCalendar);
                } else if (columnValue instanceof Time) {
                    stmt.setTime(i, columnValue, utcCalendar);
                } else if (columnValue instanceof Timestamp) {
                    stmt.setTimestamp(i, columnValue, utcCalendar);
                } else {
                    stmt.setObject(i, columnValue, sqlType);
                }
                ++i;
            }
            return true;
        }
        return false;
    }
}

