/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.dao.jdbc;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import net.solarnetwork.node.dao.jdbc.AbstractSQLExceptionHandler;
import org.h2.jdbcx.JdbcDataSource;

public class ResetSQLExceptionHandler
extends AbstractSQLExceptionHandler {
    public void handleGetConnectionException(SQLException e) {
    }

    public void handleConnectionException(Connection conn, SQLException e) {
    }

    public void handleConnectionException(DataSource dataSource, Connection conn, SQLException e) {
        this.handleGetConnectionException(dataSource, e);
    }

    public void handleGetConnectionException(DataSource dataSource, SQLException e) {
        SQLException root = this.exceptionMatchingSqlStatePattern(e);
        if (root == null) {
            return;
        }
        try {
            if (dataSource.isWrapperFor(JdbcDataSource.class)) {
                String path;
                Path p;
                Path dir;
                JdbcDataSource h2ds = dataSource.unwrap(JdbcDataSource.class);
                String url = h2ds.getUrl();
                this.log.info("Discovered corrupted database URL: {}", (Object)url);
                int split = url.lastIndexOf(58);
                if (split >= 0 && Files.isDirectory(dir = (p = Paths.get(path = url.substring(split + 1), new String[0])).getParent(), new LinkOption[0])) {
                    String name = p.getFileName().toString();
                    Path dest = Files.createDirectory(dir.resolve(name + "-reset." + System.currentTimeMillis()), new FileAttribute[0]);
                    Files.createDirectories(dest, new FileAttribute[0]);
                    Files.list(dir).filter(f -> Files.isRegularFile(f, new LinkOption[0]) && f.getFileName().toString().startsWith(name)).forEach(f -> {
                        Path to = dest.resolve(f.getFileName());
                        try {
                            Files.move(f, to, new CopyOption[0]);
                        }
                        catch (IOException e1) {
                            this.log.warn("Error moving {} -> {}: {}", new Object[]{f, to, e1});
                        }
                    });
                }
            }
        }
        catch (Throwable e2) {
            this.log.warn("Unable to reset database from exception [{}]", (Object)e.toString(), (Object)e2);
        }
        this.shutdown(root.getMessage());
    }

    private void shutdown(String msg) {
        this.log.error("Shutting down now due to database corruption error: {}", (Object)msg);
        System.exit(1);
    }
}

