/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.dao.jdbc;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.solarnetwork.node.backup.Backup;
import net.solarnetwork.node.backup.BackupManager;
import net.solarnetwork.node.backup.BackupService;
import net.solarnetwork.node.dao.jdbc.AbstractSQLExceptionHandler;
import net.solarnetwork.node.service.IdentityService;
import net.solarnetwork.service.OptionalService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.springframework.util.FileSystemUtils;

public class RestoreFromBackupSQLExceptionHandler
extends AbstractSQLExceptionHandler {
    private final int minimumExceptionCount;
    private final BundleContext bundleContext;
    private int restoreDelaySeconds = 15;
    private String backupResourceProviderFilter;
    private OptionalService<IdentityService> identityService;
    private final AtomicInteger exceptionCount = new AtomicInteger(0);
    private final AtomicBoolean restoreScheduled = new AtomicBoolean(false);

    public RestoreFromBackupSQLExceptionHandler(BundleContext bundleContext, int minimumExceptionCount) {
        this.bundleContext = bundleContext;
        this.minimumExceptionCount = minimumExceptionCount;
    }

    public synchronized void handleGetConnectionException(SQLException e) {
        this.handleConnectionException(null, e);
    }

    public void handleConnectionException(Connection conn, SQLException e) {
        SQLException root = this.exceptionMatchingSqlStatePattern(e);
        if (root == null) {
            return;
        }
        this.log.error("Recovery triggering error {} on database connection: {}", (Object)root.getSQLState(), (Object)e.getMessage());
        int count = this.exceptionCount.incrementAndGet();
        if (count < this.minimumExceptionCount) {
            return;
        }
        this.scheduleRestoreFromBackup(count);
    }

    private File getDbDir() {
        String dbDir = System.getProperty("derby.system.home");
        if (dbDir == null) {
            return null;
        }
        return new File(dbDir, "solarnode");
    }

    private void cleanupExistingDatabase() {
        File f = this.getDbDir();
        if (f == null) {
            return;
        }
        if (f.isDirectory()) {
            this.log.warn("Deleting DB dir {}", (Object)f.getAbsolutePath());
            if (FileSystemUtils.deleteRecursively((File)f)) {
                this.log.warn("Deleted database directory " + f.getAbsolutePath());
            } else {
                try {
                    Files.delete(f.toPath());
                }
                catch (IOException e) {
                    this.log.warn("Unable to delete database directory " + f.getAbsolutePath(), (Throwable)e);
                }
            }
        }
    }

    private void scheduleRestoreFromBackup(final int count) {
        if (this.restoreScheduled.get()) {
            return;
        }
        this.log.warn("Scheduling restore from backup in {} seconds due to database connection exception", (Object)this.restoreDelaySeconds);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(TimeUnit.SECONDS.toMillis(RestoreFromBackupSQLExceptionHandler.this.restoreDelaySeconds));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                BackupService backupService = RestoreFromBackupSQLExceptionHandler.this.getBackupService();
                if (backupService != null) {
                    RestoreFromBackupSQLExceptionHandler.this.log.warn("Looking for backup to restore from {}", (Object)backupService);
                    Backup backup = RestoreFromBackupSQLExceptionHandler.this.getBackupToRestore(backupService);
                    if (backup != null && RestoreFromBackupSQLExceptionHandler.this.restoreScheduled.compareAndSet(false, true)) {
                        Map<String, String> props = Collections.singletonMap("ResourceProviderFilter", RestoreFromBackupSQLExceptionHandler.this.backupResourceProviderFilter);
                        RestoreFromBackupSQLExceptionHandler.this.log.warn("Discovered backup {} for scheduled restore using props {}", (Object)backup.getKey(), props);
                        if (backupService.markBackupForRestore(backup, props)) {
                            RestoreFromBackupSQLExceptionHandler.this.cleanupExistingDatabase();
                            RestoreFromBackupSQLExceptionHandler.this.shutdown(backup);
                        } else {
                            RestoreFromBackupSQLExceptionHandler.this.log.warn("BackupService {} failed to mark backup {} for restore); cannot schedule restore from backup", (Object)backupService, (Object)backup.getKey());
                        }
                    } else if (backup == null) {
                        RestoreFromBackupSQLExceptionHandler.this.log.warn("No backup available to restore; cannot schedule restore from backup");
                    }
                } else {
                    RestoreFromBackupSQLExceptionHandler.this.log.warn("No BackupService available for restore; will try scheduling restore again");
                    RestoreFromBackupSQLExceptionHandler.this.scheduleRestoreFromBackup(count);
                }
            }
        });
        t.setContextClassLoader(Thread.currentThread().getContextClassLoader());
        t.start();
    }

    private BackupService getBackupService() {
        BackupManager mgr = this.backupManager();
        if (mgr == null) {
            this.log.debug("No BackupManager available to restore from");
            return null;
        }
        BackupService result = mgr.activeBackupService();
        return result;
    }

    private Backup getBackupToRestore(BackupService backupService) {
        if (backupService == null) {
            this.log.debug("No BackupService available to restore from");
            return null;
        }
        IdentityService identService = this.identityService != null ? (IdentityService)this.identityService.service() : null;
        Long nodeId = identService != null ? identService.getNodeId() : null;
        Collection backups = backupService.getAvailableBackups();
        if (backups == null || backups.isEmpty()) {
            this.log.debug("No Backup available to restore from");
            return null;
        }
        Backup backup = null;
        for (Backup b : backups) {
            if (!b.isComplete() || backup != null && !backup.getDate().before(b.getDate()) || nodeId != null && !nodeId.equals(b.getNodeId())) continue;
            backup = b;
        }
        return backup;
    }

    private BackupManager backupManager() {
        ServiceReference mgrRef = this.bundleContext.getServiceReference(BackupManager.class);
        if (mgrRef == null) {
            return null;
        }
        return (BackupManager)this.bundleContext.getService(mgrRef);
    }

    private void shutdown(Backup backup) {
        this.log.warn("Shutting down now to force restore from backup {}", (Object)backup.getKey());
        System.exit(0);
    }

    public void setRestoreDelaySeconds(int restoreDelaySeconds) {
        this.restoreDelaySeconds = restoreDelaySeconds;
    }

    public void setBackupResourceProviderFilter(String backupResourceProviderFilter) {
        this.backupResourceProviderFilter = backupResourceProviderFilter;
    }

    public void setIdentityService(OptionalService<IdentityService> identityService) {
        this.identityService = identityService;
    }
}

