/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.dao.jdbc;

import java.io.IOException;
import java.io.Writer;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.TimeZone;
import net.solarnetwork.node.dao.jdbc.JdbcResultSetCsvWriter;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.io.AbstractCsvWriter;
import org.supercsv.prefs.CsvPreference;
import org.supercsv.util.Util;

public class ResultSetCsvWriter
extends AbstractCsvWriter
implements JdbcResultSetCsvWriter {
    public ResultSetCsvWriter(Writer writer, CsvPreference preference) {
        super(writer, preference);
    }

    @Override
    public void write(ResultSet resultSet) throws SQLException, IOException {
        this.write(resultSet, null);
    }

    @Override
    public void write(ResultSet resultSet, CellProcessor[] cellProcessors) throws SQLException, IOException {
        assert (resultSet != null);
        String[] headers = this.resultSetHeaders(resultSet);
        this.incrementRowAndLineNo();
        this.writeRow(headers);
        this.writeContents(headers, resultSet, cellProcessors);
    }

    private String[] resultSetHeaders(ResultSet resultSet) throws SQLException {
        ResultSetMetaData meta = resultSet.getMetaData();
        int colCount = meta.getColumnCount();
        String[] headers = new String[colCount];
        for (int i = 0; i < colCount; ++i) {
            headers[i] = meta.getColumnName(i + 1);
        }
        return headers;
    }

    private void writeContents(String[] headers, ResultSet resultSet, CellProcessor[] cellProcessors) throws SQLException, IOException {
        int colCount = headers.length;
        ArrayList<Date> objects = new ArrayList<Date>(headers.length);
        ArrayList processed = cellProcessors == null ? null : new ArrayList(headers.length);
        ResultSetMetaData meta = resultSet.getMetaData();
        Calendar utcCalendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        while (resultSet.next()) {
            super.incrementRowAndLineNo();
            objects.clear();
            for (int i = 1; i <= colCount; ++i) {
                int sqlType = meta.getColumnType(i);
                Object columnValue = sqlType == 91 ? resultSet.getDate(i, utcCalendar) : (sqlType == 92 ? resultSet.getTime(i, utcCalendar) : (sqlType == 93 ? resultSet.getTimestamp(i, utcCalendar) : resultSet.getObject(i)));
                objects.add((Date)columnValue);
            }
            if (cellProcessors != null) {
                Util.executeCellProcessors(processed, objects, (CellProcessor[])cellProcessors, (int)this.getLineNumber(), (int)this.getRowNumber());
                this.writeRow(processed);
                continue;
            }
            this.writeRow(objects);
        }
    }
}

