/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.dao.jdbc;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import net.solarnetwork.node.dao.jdbc.DatabaseSystemService;
import net.solarnetwork.node.job.JobService;
import net.solarnetwork.node.service.support.BaseIdentifiable;
import net.solarnetwork.service.OptionalService;
import net.solarnetwork.settings.SettingSpecifier;
import net.solarnetwork.util.ObjectUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcOperations;

public class TimeBasedTableDiskSizeManager
extends BaseIdentifiable
implements JobService {
    private final JdbcOperations jdbcOperations;
    private OptionalService<DatabaseSystemService> dbSystemService;
    private String schemaName = "SOLARNODE";
    private String tableName = "SN_GENERAL_NODE_DATUM";
    private String dateColumnName = "CREATED";
    private float maxFileSystemUseThreshold = 90.0f;
    private long minTableSizeThreshold = 0x100000L;
    private int trimMinutes = 90;
    private static final String OLDEST_DATE_QUERY_TEMPLATE = "SELECT MIN(%s) FROM %s";
    private static final String DELETE_BY_DATE_QUERY_TEMPLATE = "DELETE FROM %s WHERE %s < ?";

    public TimeBasedTableDiskSizeManager(JdbcOperations jdbcOperations) {
        this.jdbcOperations = (JdbcOperations)ObjectUtils.requireNonNullArgument((Object)jdbcOperations, (String)"jdbcOperations");
    }

    public String getSettingUid() {
        return "net.solarnetwork.node.dao.jdbc.derby";
    }

    public List<SettingSpecifier> getSettingSpecifiers() {
        return Collections.emptyList();
    }

    public void executeJobService() throws Exception {
        URI rootURI;
        DatabaseSystemService dbService;
        DatabaseSystemService databaseSystemService = dbService = this.dbSystemService != null ? (DatabaseSystemService)this.dbSystemService.service() : null;
        if (dbService == null) {
            this.log.debug("No DatabaseSystemService available");
            return;
        }
        File[] dbRoots = dbService.getFileSystemRoots();
        try {
            rootURI = new URI("file:///");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        Path rootPath = Paths.get(rootURI);
        for (File f : dbRoots) {
            try {
                Path dirPath = rootPath.resolve(f.getAbsolutePath());
                FileStore store = Files.getFileStore(dirPath);
                long totalSpace = store.getTotalSpace();
                long usableSpace = store.getUsableSpace();
                float percentFull = (float)(100.0 * (1.0 - (double)usableSpace / (double)totalSpace));
                this.log.debug("Database filesystem {} {}% capacity ({} available out of {})", new Object[]{store.name(), Float.valueOf(percentFull), usableSpace, totalSpace});
                if (!(percentFull >= this.maxFileSystemUseThreshold)) continue;
                long diskSize = dbService.tableFileSystemSize(this.schemaName, this.tableName);
                this.log.debug("Database table {}.{} consumes {} on disk", new Object[]{this.schemaName, this.tableName, diskSize});
                if (diskSize >= this.minTableSizeThreshold) {
                    int deleted = this.deleteOldestData(dbService);
                    if (deleted > 0) {
                        long newDiskSize = dbService.tableFileSystemSize(this.schemaName, this.tableName);
                        this.log.info("Trimmed {} oldest rows from {}.{} to free space; size diff is {}", new Object[]{deleted, this.schemaName, this.tableName, newDiskSize - diskSize});
                    }
                    return;
                }
                this.log.info("Database table {}.{} consumes {} on disk but not deleting data because of configured minimum size threshold {}", new Object[]{this.schemaName, this.tableName, diskSize, this.minTableSizeThreshold});
            }
            catch (IOException e) {
                this.log.error("Error examining disk use for database root {}", (Object)f, (Object)e);
            }
        }
    }

    private int deleteOldestData(DatabaseSystemService dbService) {
        int deleted = (Integer)this.jdbcOperations.execute((ConnectionCallback)new ConnectionCallback<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Integer doInConnection(Connection conn) throws SQLException, DataAccessException {
                DatabaseMetaData meta = conn.getMetaData();
                try (ResultSet dateColRs = null;){
                    dateColRs = meta.getColumns(null, TimeBasedTableDiskSizeManager.this.schemaName, TimeBasedTableDiskSizeManager.this.tableName, TimeBasedTableDiskSizeManager.this.dateColumnName);
                    if (!dateColRs.next()) {
                        TimeBasedTableDiskSizeManager.this.log.error("Date column {} not found on table {}.{}; cannot trim data", new Object[]{TimeBasedTableDiskSizeManager.this.dateColumnName, TimeBasedTableDiskSizeManager.this.schemaName, TimeBasedTableDiskSizeManager.this.tableName});
                        Integer n = 0;
                        return n;
                    }
                }
                String fullTableName = TimeBasedTableDiskSizeManager.this.schemaName == null ? TimeBasedTableDiskSizeManager.this.tableName : TimeBasedTableDiskSizeManager.this.schemaName + '.' + TimeBasedTableDiskSizeManager.this.tableName;
                Timestamp oldestDate = TimeBasedTableDiskSizeManager.this.findOldestDate(conn, fullTableName);
                if (oldestDate == null) {
                    TimeBasedTableDiskSizeManager.this.log.debug("Oldest date not found on table {}.{}; cannot trim data", (Object)TimeBasedTableDiskSizeManager.this.schemaName, (Object)TimeBasedTableDiskSizeManager.this.tableName);
                    return 0;
                }
                Timestamp deleteDate = new Timestamp(oldestDate.getTime() + TimeUnit.MINUTES.toMillis(TimeBasedTableDiskSizeManager.this.trimMinutes));
                int deleted = TimeBasedTableDiskSizeManager.this.deleteOlderThan(conn, fullTableName, deleteDate);
                TimeBasedTableDiskSizeManager.this.log.debug("Trimmed {} rows from {} older than {} to free space", new Object[]{deleted, fullTableName, deleteDate});
                return deleted;
            }
        });
        if (deleted > 0) {
            dbService.vacuumTable(this.schemaName, this.tableName);
        }
        return deleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Timestamp findOldestDate(Connection conn, String fullTableName) throws SQLException {
        String oldestDateSql = String.format(OLDEST_DATE_QUERY_TEMPLATE, this.dateColumnName, fullTableName);
        Timestamp oldestDate = null;
        PreparedStatement oldestDateStmt = null;
        ResultSet oldestDateRs = null;
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        try {
            oldestDateStmt = conn.prepareStatement(oldestDateSql);
            oldestDateRs = oldestDateStmt.executeQuery();
            if (oldestDateRs.next()) {
                oldestDate = oldestDateRs.getTimestamp(1, cal);
            }
        }
        finally {
            if (oldestDateRs != null) {
                oldestDateRs.close();
            }
            if (oldestDateStmt != null) {
                oldestDateStmt.close();
            }
        }
        return oldestDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int deleteOlderThan(Connection conn, String fullTableName, Timestamp date) throws SQLException {
        this.log.debug("Trimming rows from {} older than {} to free space", (Object)fullTableName, (Object)date);
        String oldestDateSql = String.format(DELETE_BY_DATE_QUERY_TEMPLATE, fullTableName, this.dateColumnName);
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        try (PreparedStatement deleteStmt = null;){
            int count;
            deleteStmt = conn.prepareStatement(oldestDateSql);
            deleteStmt.setTimestamp(1, date, cal);
            int n = count = deleteStmt.executeUpdate();
            return n;
        }
    }

    public void setDbSystemService(OptionalService<DatabaseSystemService> dbSystemService) {
        this.dbSystemService = dbSystemService;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setDateColumnName(String dateColumnName) {
        this.dateColumnName = dateColumnName;
    }

    public void setMaxFileSystemUseThreshold(float maxFileSystemUseThreshold) {
        this.maxFileSystemUseThreshold = maxFileSystemUseThreshold;
    }

    public void setMinTableSizeThreshold(long minTableSizeThreshold) {
        this.minTableSizeThreshold = minTableSizeThreshold;
    }

    public void setTrimMinutes(int trimMinutes) {
        this.trimMinutes = trimMinutes;
    }
}

