/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.dao.jdbc.general;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.solarnetwork.domain.datum.DatumId;
import net.solarnetwork.domain.datum.DatumSamples;
import net.solarnetwork.domain.datum.DatumSamplesContainer;
import net.solarnetwork.domain.datum.DatumSamplesOperations;
import net.solarnetwork.domain.datum.DatumSamplesType;
import net.solarnetwork.domain.datum.ObjectDatumKind;
import net.solarnetwork.node.dao.DatumDao;
import net.solarnetwork.node.dao.jdbc.AbstractJdbcDao;
import net.solarnetwork.node.dao.jdbc.general.DatumDaoStat;
import net.solarnetwork.node.domain.Mock;
import net.solarnetwork.node.domain.datum.NodeDatum;
import net.solarnetwork.node.domain.datum.SimpleDatum;
import net.solarnetwork.node.service.DatumEvents;
import net.solarnetwork.service.PingTest;
import net.solarnetwork.service.PingTestResult;
import net.solarnetwork.settings.SettingSpecifier;
import net.solarnetwork.settings.SettingSpecifierProvider;
import net.solarnetwork.settings.support.BasicTitleSettingSpecifier;
import net.solarnetwork.util.StatCounter;
import org.osgi.service.event.Event;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class JdbcGeneralNodeDatumDao
extends AbstractJdbcDao<NodeDatum>
implements DatumDao,
SettingSpecifierProvider,
PingTest {
    public static final int DEFAULT_TABLES_VERSION = 5;
    public static final int MAX_SAMPLES_JSON_LENGTH = 8192;
    public static final String TABLE_GENERAL_NODE_DATUM = "sn_general_node_datum";
    public static final String DEFAULT_INIT_SQL = "derby-generalnodedatum-init.sql";
    public static final String DEFAULT_SQL_GET_TABLES_VERSION = "SELECT svalue FROM solarnode.sn_settings WHERE skey = 'solarnode.sn_general_node_datum.version'";
    public static final int DEFAULT_MAX_FETCH_FOR_UPLOAD = 60;
    public static final int DEFAULT_MAX_COUNT_PING_FAIL = 10000;
    public static final String SQL_RESOURCE_INSERT = "insert";
    public static final String SQL_RESOURCE_DELETE_OLD = "delete-old";
    public static final String SQL_RESOURCE_FIND_FOR_UPLOAD = "find-upload";
    public static final String SQL_RESOURCE_FIND_FOR_PRIMARY_KEY = "find-pk";
    public static final String SQL_RESOURCE_UPDATE_UPLOADED = "update-upload";
    public static final String SQL_RESOURCE_UPDATE_DATA = "update-data";
    public static final String SQL_RESOURCE_COUNT = "count";
    public static final String LOG_SOURCE_ID = "log";
    public static final String LOG_SOURCE_ID_PREFIX = "log/";
    private final StatCounter stats;
    private ObjectMapper objectMapper;
    private int maxFetchForUpload = 60;
    private boolean ignoreMockData = true;
    private int maxCountPingFail = 10000;

    public JdbcGeneralNodeDatumDao() {
        this.setSqlResourcePrefix("derby-generalnodedatum");
        this.setTableName(TABLE_GENERAL_NODE_DATUM);
        this.setTablesVersion(5);
        this.setSqlGetTablesVersion(DEFAULT_SQL_GET_TABLES_VERSION);
        this.setInitSqlResource((Resource)new ClassPathResource(DEFAULT_INIT_SQL, this.getClass()));
        this.stats = new StatCounter("JdbcDatumDao", "", this.log, 100, (StatCounter.Stat[])DatumDaoStat.values());
    }

    @Transactional(readOnly=false, propagation=Propagation.REQUIRED, noRollbackFor={DuplicateKeyException.class})
    public void storeDatum(NodeDatum datum) {
        block2: {
            try {
                this.storeDomainObject(datum);
            }
            catch (DuplicateKeyException e) {
                List<NodeDatum> existing = this.findDatum(SQL_RESOURCE_FIND_FOR_PRIMARY_KEY, this.preparedStatementSetterForPrimaryKey(datum.getTimestamp(), datum.getSourceId()), this.rowMapper());
                if (existing.size() <= 0) break block2;
                DatumSamplesOperations existingSamples = existing.get(0).asSampleOperations();
                DatumSamplesOperations newSamples = datum.asSampleOperations();
                if (!newSamples.differsFrom(existingSamples)) break block2;
                this.updateDomainObject(datum, this.getSqlResource(SQL_RESOURCE_UPDATE_DATA));
            }
        }
    }

    @Override
    protected void setUpdateStatementValues(NodeDatum datum, PreparedStatement ps) throws SQLException {
        int col = 1;
        ps.setString(col++, this.jsonForSamples(datum));
        ps.setTimestamp(col++, Timestamp.from(datum.getTimestamp()));
        ps.setString(col++, datum.getSourceId());
    }

    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public void setDatumUploaded(NodeDatum datum, Instant date, String destination, String trackingId) {
        this.updateDatumUpload(datum, date == null ? Instant.now() : date);
    }

    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public int deleteUploadedDataOlderThan(int hours) {
        return this.deleteUploadedDataOlderThanHours(hours);
    }

    private RowMapper<NodeDatum> rowMapper() {
        return new RowMapper<NodeDatum>(){

            public NodeDatum mapRow(ResultSet rs, int rowNum) throws SQLException {
                String jdata;
                Long locationId;
                if (JdbcGeneralNodeDatumDao.this.log.isTraceEnabled()) {
                    JdbcGeneralNodeDatumDao.this.log.trace("Handling result row " + rowNum);
                }
                int col = 0;
                Instant ts = rs.getTimestamp(++col).toInstant();
                String sourceId = rs.getString(++col);
                DatumId id = (locationId = (Long)rs.getObject(++col)) != null ? DatumId.locationId((Long)locationId, (String)sourceId, (Instant)ts) : DatumId.nodeId(null, (String)sourceId, (Instant)ts);
                DatumSamples s = null;
                if ((jdata = rs.getString(++col)) != null) {
                    try {
                        s = (DatumSamples)JdbcGeneralNodeDatumDao.this.objectMapper.readValue(jdata, DatumSamples.class);
                    }
                    catch (IOException e) {
                        JdbcGeneralNodeDatumDao.this.log.error("Error deserializing JSON into GeneralNodeDatumSamples: {}", (Object)e.getMessage());
                    }
                }
                return new SimpleDatum(id, s);
            }
        };
    }

    @Transactional(readOnly=true, propagation=Propagation.REQUIRED)
    public List<NodeDatum> getDatumNotUploaded(String destination) {
        return this.findDatumNotUploaded(this.rowMapper());
    }

    private String jsonForSamples(NodeDatum datum) {
        int len;
        String json;
        DatumSamples s = ((DatumSamplesContainer)datum).getSamples();
        try {
            json = this.objectMapper.writeValueAsString((Object)s);
        }
        catch (IOException e) {
            this.log.error("Error serializing DatumSamples into JSON: {}", (Object)e.getMessage());
            json = "{}";
        }
        int n = len = json != null ? json.length() : 0;
        if (len > 8192) {
            DatumSamples s2 = new DatumSamples((DatumSamplesOperations)s);
            if (s2.getStatus() != null && !s2.getStatus().isEmpty()) {
                if (s2.hasSampleValue(DatumSamplesType.Status, "exSt")) {
                    s2.putStatusSampleValue("exSt", null);
                } else {
                    s2.getStatus().clear();
                    s2.putStatusSampleValue("error", (Object)String.format("Datum must be less than %d characters, but is %d", 8192, len));
                }
            }
            try {
                json = this.objectMapper.writeValueAsString((Object)s2);
            }
            catch (IOException e) {
                this.log.error("Error serializing DatumSamples into JSON: {}", (Object)e.getMessage());
                json = "{}";
            }
        }
        int n2 = len = json != null ? json.length() : 0;
        if (len > 8192) {
            json = "{}";
        }
        return json;
    }

    @Override
    protected void setStoreStatementValues(NodeDatum datum, PreparedStatement ps) throws SQLException {
        int col = 0;
        ps.setTimestamp(++col, Timestamp.from(datum.getTimestamp() == null ? Instant.now().truncatedTo(ChronoUnit.MILLIS) : datum.getTimestamp().truncatedTo(ChronoUnit.MILLIS)));
        ps.setString(++col, datum.getSourceId() == null ? "" : datum.getSourceId());
        if (datum.getKind() == ObjectDatumKind.Location) {
            ps.setObject(++col, datum.getObjectId());
        } else {
            ps.setNull(++col, 1);
        }
        String json = this.jsonForSamples(datum);
        ps.setString(++col, json);
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    protected int deleteUploadedDataOlderThanHours(final int hours) {
        int result = this.getJdbcTemplate().update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                String sql = JdbcGeneralNodeDatumDao.this.getSqlResource(JdbcGeneralNodeDatumDao.SQL_RESOURCE_DELETE_OLD);
                JdbcGeneralNodeDatumDao.this.log.debug("Preparing SQL to delete old datum [{}] with hours [{}]", (Object)sql, (Object)hours);
                PreparedStatement ps = con.prepareStatement(sql);
                Calendar c = Calendar.getInstance();
                c.add(10, -hours);
                ps.setTimestamp(1, new Timestamp(c.getTimeInMillis()), c);
                return ps;
            }
        });
        this.stats.addAndGet((StatCounter.Stat)DatumDaoStat.DatumDeleted, (long)result);
        return result;
    }

    protected List<NodeDatum> findDatumNotUploaded(RowMapper<NodeDatum> rowMapper) {
        List result = this.getJdbcTemplate().query(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                String sql = JdbcGeneralNodeDatumDao.this.getSqlResource(JdbcGeneralNodeDatumDao.SQL_RESOURCE_FIND_FOR_UPLOAD);
                if (JdbcGeneralNodeDatumDao.this.log.isTraceEnabled()) {
                    JdbcGeneralNodeDatumDao.this.log.trace("Preparing SQL to find datum not uploaded [" + sql + "] with maxFetchForUpload [" + JdbcGeneralNodeDatumDao.this.maxFetchForUpload + ']');
                }
                PreparedStatement ps = con.prepareStatement(sql);
                ps.setFetchDirection(1000);
                ps.setFetchSize(JdbcGeneralNodeDatumDao.this.maxFetchForUpload);
                ps.setMaxRows(JdbcGeneralNodeDatumDao.this.maxFetchForUpload);
                return ps;
            }
        }, rowMapper);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Found " + result.size() + " datum entities not uploaded");
        }
        return result;
    }

    protected List<NodeDatum> findDatum(final String sqlResource, final PreparedStatementSetter setter, RowMapper<NodeDatum> rowMapper) {
        List result = this.getJdbcTemplate().query(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                String sql = JdbcGeneralNodeDatumDao.this.getSqlResource(sqlResource);
                if (JdbcGeneralNodeDatumDao.this.log.isTraceEnabled()) {
                    JdbcGeneralNodeDatumDao.this.log.trace("Preparing SQL [{}] to find datum", (Object)sql);
                }
                PreparedStatement ps = con.prepareStatement(sql);
                ps.setFetchDirection(1000);
                ps.setFetchSize(1);
                ps.setMaxRows(1);
                setter.setValues(ps);
                return ps;
            }
        }, rowMapper);
        return result;
    }

    protected PreparedStatementSetter preparedStatementSetterForPrimaryKey(final Instant created, final String sourceId) {
        return new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                ps.setTimestamp(1, Timestamp.from(created));
                ps.setString(2, sourceId);
            }
        };
    }

    protected void storeDomainObject(NodeDatum datum) {
        if (this.ignoreMockData && datum instanceof Mock) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Not persisting Mock datum: " + datum);
            }
            return;
        }
        this.insertDomainObject(datum, this.getSqlResource(SQL_RESOURCE_INSERT));
        if (!LOG_SOURCE_ID.equalsIgnoreCase(datum.getSourceId()) && !datum.getSourceId().startsWith(LOG_SOURCE_ID_PREFIX)) {
            this.log.info("Persisted datum locally: {}", (Object)datum);
        }
        this.stats.incrementAndGet((StatCounter.Stat)DatumDaoStat.DatumStored);
        this.postDatumStoredEvent(datum);
    }

    @Override
    protected int updateDomainObject(NodeDatum datum, String sqlUpdate) {
        int result = super.updateDomainObject(datum, sqlUpdate);
        if (result > 0) {
            this.postDatumStoredEvent(datum);
        }
        return result;
    }

    protected void updateDatumUpload(NodeDatum datum, Instant timestamp) {
        this.updateDatumUpload(datum.getTimestamp(), datum.getSourceId(), timestamp);
    }

    protected int updateDatumUpload(final Instant created, final Object id, final Instant timestamp) {
        int result = this.getJdbcTemplate().update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                PreparedStatement ps = con.prepareStatement(JdbcGeneralNodeDatumDao.this.getSqlResource(JdbcGeneralNodeDatumDao.SQL_RESOURCE_UPDATE_UPLOADED));
                int col = 1;
                ps.setTimestamp(col++, Timestamp.from(timestamp));
                ps.setTimestamp(col++, Timestamp.from(created));
                ps.setObject(col++, id);
                return ps;
            }
        });
        this.stats.addAndGet((StatCounter.Stat)DatumDaoStat.DatumUploaded, (long)result);
        return result;
    }

    protected final void postDatumStoredEvent(NodeDatum datum) {
        Event event = this.createDatumStoredEvent(datum);
        this.postEvent(event);
    }

    protected Event createDatumStoredEvent(NodeDatum datum) {
        return DatumEvents.datumEvent((String)"net/solarnetwork/node/dao/DATUM_STORED", (NodeDatum)datum);
    }

    public String getPingTestId() {
        return this.getSettingUid();
    }

    public String getPingTestName() {
        return this.getDisplayName();
    }

    public long getPingTestMaximumExecutionMilliseconds() {
        return 5000L;
    }

    public PingTest.Result performPingTest() throws Exception {
        long rowCount = this.rowCount();
        int maxCount = this.getMaxCountPingFail();
        boolean ok = true;
        String msg = this.getMessageSource().getMessage("db.rowCount", new Object[]{rowCount}, Locale.getDefault());
        if (maxCount > 0 && rowCount > (long)maxCount) {
            ok = false;
        }
        return new PingTestResult(ok, msg, Collections.singletonMap(SQL_RESOURCE_COUNT, rowCount));
    }

    private long rowCount() {
        Number rowCountNum = (Number)this.getJdbcTemplate().queryForObject(this.getSqlResource(SQL_RESOURCE_COUNT), Number.class);
        return rowCountNum == null ? 0L : rowCountNum.longValue();
    }

    public String getSettingUid() {
        return "net.solarnetwork.node.dao.jdbc.general.datum";
    }

    public String getDisplayName() {
        return "DatumDao (JDBC)";
    }

    public List<SettingSpecifier> getSettingSpecifiers() {
        return Collections.singletonList(new BasicTitleSettingSpecifier("status", this.getStatusMessage(), true, true));
    }

    private String getStatusMessage() {
        long rowCount = 0L;
        try {
            rowCount = this.rowCount();
        }
        catch (Exception e) {
            this.log.warn("Error finding datum row count.", (Throwable)e);
        }
        return this.getMessageSource().getMessage("status.msg", new Object[]{rowCount, this.stats.get((StatCounter.Stat)DatumDaoStat.DatumStored), this.stats.get((StatCounter.Stat)DatumDaoStat.DatumUploaded), this.stats.get((StatCounter.Stat)DatumDaoStat.DatumDeleted)}, Locale.getDefault());
    }

    public int getMaxFetchForUpload() {
        return this.maxFetchForUpload;
    }

    public void setMaxFetchForUpload(int maxFetchForUpload) {
        this.maxFetchForUpload = maxFetchForUpload;
    }

    public boolean isIgnoreMockData() {
        return this.ignoreMockData;
    }

    public void setIgnoreMockData(boolean ignoreMockData) {
        this.ignoreMockData = ignoreMockData;
    }

    public int getMaxCountPingFail() {
        return this.maxCountPingFail;
    }

    public void setMaxCountPingFail(int maxCountPingFail) {
        this.maxCountPingFail = maxCountPingFail;
    }
}

