/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.dao.jdbc.sectok;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.Instant;
import net.solarnetwork.node.dao.SecurityTokenDao;
import net.solarnetwork.node.dao.jdbc.BaseJdbcGenericDao;
import net.solarnetwork.node.dao.jdbc.sectok.SecurityTokenRowMapper;
import net.solarnetwork.node.domain.SecurityToken;

public class JdbcSecurityTokenDao
extends BaseJdbcGenericDao<SecurityToken, String>
implements SecurityTokenDao {
    public static final String TABLE_NAME = "sectok";
    public static final int VERSION = 1;

    public JdbcSecurityTokenDao() {
        super(SecurityToken.class, String.class, SecurityTokenRowMapper.INSTANCE, "sn_%s", TABLE_NAME, 1);
    }

    @Override
    protected void setStoreStatementValues(SecurityToken obj, PreparedStatement ps) throws SQLException {
        ps.setString(1, (String)((Object)obj.getId()));
        JdbcSecurityTokenDao.setInstantParameter(ps, 2, obj.getCreated() != null ? obj.getCreated() : Instant.now());
        obj.copySecret(secret -> {
            try {
                ps.setString(3, (String)secret);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
        this.setUpdateStatementValues(obj, ps, 3);
    }

    @Override
    protected void setUpdateStatementValues(SecurityToken obj, PreparedStatement ps) throws SQLException {
        this.setUpdateStatementValues(obj, ps, 0);
        ps.setObject(3, obj.getId());
    }

    private void setUpdateStatementValues(SecurityToken obj, PreparedStatement ps, int offset) throws SQLException {
        ps.setString(1 + offset, obj.getName());
        ps.setString(2 + offset, obj.getDescription());
    }
}

