/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.dao.jdbc.sectok;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import net.solarnetwork.node.dao.jdbc.BaseJdbcGenericDao;
import net.solarnetwork.node.domain.SecurityToken;
import org.springframework.jdbc.core.RowMapper;

public class SecurityTokenRowMapper
implements RowMapper<SecurityToken> {
    public static final RowMapper<SecurityToken> INSTANCE = new SecurityTokenRowMapper();

    public SecurityToken mapRow(ResultSet rs, int rowNum) throws SQLException {
        String tokenId = rs.getString(1);
        Instant created = BaseJdbcGenericDao.getInstantColumn(rs, 2);
        String tokenSecret = rs.getString(3);
        String name = rs.getString(4);
        String description = rs.getString(5);
        SecurityToken token = new SecurityToken(tokenId, created, tokenSecret, name, description);
        if (tokenSecret.isEmpty()) {
            token = token.copyWithoutSecret(null, null);
        }
        return token;
    }
}

