/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.io.bacnet;

import net.solarnetwork.domain.CodedValue;

public enum BacnetDataType implements CodedValue
{
    Null(0),
    Boolean(1),
    UnsignedInteger(2),
    SignedInteger(3),
    Real(4),
    Double(5),
    OctetString(6),
    CharacterString(7),
    BitString(8),
    Enumerated(9),
    Date(10),
    Time(11),
    ObjectIdentifier(12);

    private int id;

    private BacnetDataType(int id) {
        this.id = id;
    }

    public int getCode() {
        return this.id;
    }

    public int getId() {
        return this.id;
    }

    public static BacnetDataType forKey(String value) {
        try {
            int code = Integer.parseInt(value);
            BacnetDataType result = (BacnetDataType)CodedValue.forCodeValue((int)code, BacnetDataType.class, null);
            if (result != null) {
                return result;
            }
            throw new IllegalArgumentException(String.format("Unsupported BacnetDataTypes value [%s]", value));
        }
        catch (NumberFormatException e) {
            return BacnetDataType.valueOf(value);
        }
    }
}

