/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.io.bacnet;

import net.solarnetwork.domain.CodedValue;
import net.solarnetwork.node.io.bacnet.BacnetUtils;
import net.solarnetwork.util.ObjectUtils;

public enum BacnetObjectType implements CodedValue
{
    AnalogInput(0),
    AnalogOutput(1),
    AnalogValue(2),
    BinaryInput(3),
    BinaryOutput(4),
    BinaryValue(5),
    Calendar(6),
    Command(7),
    Device(8),
    EventEnrollment(9),
    File(10),
    Group(11),
    Loop(12),
    MultiStateInput(13),
    MultiStateOutput(14),
    NotificationClass(15),
    Program(16),
    Schedule(17),
    Averaging(18),
    MultiStateValue(19),
    TrendLog(20),
    LifeSafetyPoint(21),
    LifeSafetyZone(22),
    Accumulator(23),
    PulseConverter(24),
    EventLog(25),
    GlobalGroup(26),
    TrendLogMultiple(27),
    LoadControl(28),
    StructuredView(29),
    AccessDoor(30),
    Timer(31),
    AccessCredential(32),
    AccessPoint(33),
    AccessRights(34),
    AccessUser(35),
    AccessZone(36),
    CredentialDataInput(37),
    NetworkSecurity(38),
    BitstringValue(39),
    CharacterstringValue(40),
    DatePatternValue(41),
    DateValue(42),
    DatetimePatternValue(43),
    DatetimeValue(44),
    IntegerValue(45),
    LargeAnalogValue(46),
    OctetstringValue(47),
    PositiveIntegerValue(48),
    TimePatternValue(49),
    TimeValue(50),
    NotificationForwarder(51),
    AlertEnrollment(52),
    Channel(53),
    LightingOutput(54),
    BinaryLightingOutput(55),
    NetworkPort(56),
    ElevatorGroup(57),
    Escalator(58),
    Lift(59),
    Staging(60),
    AuditLog(61),
    AuditReporter(62);

    private int id;

    private BacnetObjectType(int id) {
        this.id = id;
    }

    public int getCode() {
        return this.id;
    }

    public int getId() {
        return this.id;
    }

    public static BacnetObjectType forKey(String value) {
        ObjectUtils.requireNonNullArgument((Object)value, (String)"value");
        try {
            int code = Integer.parseInt(value);
            BacnetObjectType result = (BacnetObjectType)CodedValue.forCodeValue((int)code, BacnetObjectType.class, null);
            if (result != null) {
                return result;
            }
            throw new IllegalArgumentException(String.format("Unsupported BacnetObjectType value [%s]", value));
        }
        catch (NumberFormatException e) {
            try {
                return BacnetObjectType.valueOf(value);
            }
            catch (IllegalArgumentException e2) {
                try {
                    return BacnetObjectType.valueOf(BacnetUtils.kebabToCamelCase(value));
                }
                catch (IllegalArgumentException e3) {
                    throw new IllegalArgumentException(String.format("Unsupported BacnetObjectType value [%s]", value));
                }
            }
        }
    }
}

