/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.io.bacnet;

import net.solarnetwork.domain.CodedValue;
import net.solarnetwork.node.io.bacnet.BacnetUtils;
import net.solarnetwork.util.ObjectUtils;

public enum BacnetPropertyType implements CodedValue
{
    AckedTransitions(0),
    AckRequired(1),
    Action(2),
    ActionText(3),
    ActiveText(4),
    ActiveVtSessions(5),
    AlarmValue(6),
    AlarmValues(7),
    All(8),
    AllWritesSuccessful(9),
    ApduSegmentTimeout(10),
    ApduTimeout(11),
    ApplicationSoftwareVersion(12),
    Archive(13),
    Bias(14),
    ChangeOfStateCount(15),
    ChangeOfStateTime(16),
    NotificationClass(17),
    ControlledVariableReference(19),
    ControlledVariableUnits(20),
    ControlledVariableValue(21),
    CovIncrement(22),
    DateList(23),
    DaylightSavingsStatus(24),
    Deadband(25),
    DerivativeConstant(26),
    DerivativeConstantUnits(27),
    Description(28),
    DescriptionOfHalt(29),
    DeviceAddressBinding(30),
    DeviceType(31),
    EffectivePeriod(32),
    ElapsedActiveTime(33),
    ErrorLimit(34),
    EventEnable(35),
    EventState(36),
    EventType(37),
    ExceptionSchedule(38),
    FaultValues(39),
    FeedbackValue(40),
    FileAccessMethod(41),
    FileSize(42),
    FileType(43),
    FirmwareRevision(44),
    HighLimit(45),
    InactiveText(46),
    InProcess(47),
    InstanceOf(48),
    IntegralConstant(49),
    IntegralConstantUnits(50),
    LimitEnable(52),
    ListOfGroupMembers(53),
    ListOfObjectPropertyReferences(54),
    LocalDate(56),
    LocalTime(57),
    Location(58),
    LowLimit(59),
    ManipulatedVariableReference(60),
    MaximumOutput(61),
    MaxApduLengthAccepted(62),
    MaxInfoFrames(63),
    MaxMaster(64),
    MaxPresValue(65),
    MinimumOffTime(66),
    MinimumOnTime(67),
    MinimumOutput(68),
    MinPresValue(69),
    ModelName(70),
    ModificationDate(71),
    NotifyType(72),
    NumberOfApduRetries(73),
    NumberOfStates(74),
    ObjectIdentifier(75),
    ObjectList(76),
    ObjectName(77),
    ObjectPropertyReference(78),
    ObjectType(79),
    Optional(80),
    OutOfService(81),
    OutputUnits(82),
    EventParameters(83),
    Polarity(84),
    PresentValue(85),
    Priority(86),
    PriorityArray(87),
    PriorityForWriting(88),
    ProcessIdentifier(89),
    ProgramChange(90),
    ProgramLocation(91),
    ProgramState(92),
    ProportionalConstant(93),
    ProportionalConstantUnits(94),
    ProtocolObjectTypesSupported(96),
    ProtocolServicesSupported(97),
    ProtocolVersion(98),
    ReadOnly(99),
    ReasonForHalt(100),
    RecipientList(102),
    Reliability(103),
    RelinquishDefault(104),
    Required(105),
    Resolution(106),
    SegmentationSupported(107),
    Setpoint(108),
    SetpointReference(109),
    StateText(110),
    StatusFlags(111),
    SystemStatus(112),
    TimeDelay(113),
    TimeOfActiveTimeReset(114),
    TimeOfStateCountReset(115),
    TimeSynchronizationRecipients(116),
    Units(117),
    UpdateInterval(118),
    UtcOffset(119),
    VendorIdentifier(120),
    VendorName(121),
    VtClassesSupported(122),
    WeeklySchedule(123),
    AttemptedSamples(124),
    AverageValue(125),
    BufferSize(126),
    ClientCovIncrement(127),
    CovResubscriptionInterval(128),
    EventTimeStamps(130),
    LogBuffer(131),
    LogDeviceObjectProperty(132),
    Enable(133),
    LogInterval(134),
    MaximumValue(135),
    MinimumValue(136),
    NotificationThreshold(137),
    ProtocolRevision(139),
    RecordsSinceNotification(140),
    RecordCount(141),
    StartTime(142),
    StopTime(143),
    StopWhenFull(144),
    TotalRecordCount(145),
    ValidSamples(146),
    WindowInterval(147),
    WindowSamples(148),
    MaximumValueTimestamp(149),
    MinimumValueTimestamp(150),
    VarianceValue(151),
    ActiveCovSubscriptions(152),
    BackupFailureTimeout(153),
    ConfigurationFiles(154),
    DatabaseRevision(155),
    DirectReading(156),
    LastRestoreTime(157),
    MaintenanceRequired(158),
    MemberOf(159),
    Mode(160),
    OperationExpected(161),
    Setting(162),
    Silenced(163),
    TrackingValue(164),
    ZoneMembers(165),
    LifeSafetyAlarmValues(166),
    MaxSegmentsAccepted(167),
    ProfileName(168),
    AutoSlaveDiscovery(169),
    ManualSlaveAddressBinding(170),
    SlaveAddressBinding(171),
    SlaveProxyEnable(172),
    LastNotifyRecord(173),
    ScheduleDefault(174),
    AcceptedModes(175),
    AdjustValue(176),
    Count(177),
    CountBeforeChange(178),
    CountChangeTime(179),
    CovPeriod(180),
    InputReference(181),
    LimitMonitoringInterval(182),
    LoggingObject(183),
    LoggingRecord(184),
    Prescale(185),
    PulseRate(186),
    Scale(187),
    ScaleFactor(188),
    UpdateTime(189),
    ValueBeforeChange(190),
    ValueSet(191),
    ValueChangeTime(192),
    AlignIntervals(193),
    IntervalOffset(195),
    LastRestartReason(196),
    LoggingType(197),
    RestartNotificationRecipients(202),
    TimeOfDeviceRestart(203),
    TimeSynchronizationInterval(204),
    Trigger(205),
    UtcTimeSynchronizationRecipients(206),
    NodeSubtype(207),
    NodeType(208),
    StructuredObjectList(209),
    SubordinateAnnotations(210),
    SubordinateList(211),
    ActualShedLevel(212),
    DutyWindow(213),
    ExpectedShedLevel(214),
    FullDutyBaseline(215),
    RequestedShedLevel(218),
    ShedDuration(219),
    ShedLevelDescriptions(220),
    ShedLevels(221),
    StateDescription(222),
    DoorAlarmState(226),
    DoorExtendedPulseTime(227),
    DoorMembers(228),
    DoorOpenTooLongTime(229),
    DoorPulseTime(230),
    DoorStatus(231),
    DoorUnlockDelayTime(232),
    LockStatus(233),
    MaskedAlarmValues(234),
    SecuredStatus(235),
    AbsenteeLimit(244),
    AccessAlarmEvents(245),
    AccessDoors(246),
    AccessEvent(247),
    AccessEventAuthenticationFactor(248),
    AccessEventCredential(249),
    AccessEventTime(250),
    AccessTransactionEvents(251),
    Accompaniment(252),
    AccompanimentTime(253),
    ActivationTime(254),
    ActiveAuthenticationPolicy(255),
    AssignedAccessRights(256),
    AuthenticationFactors(257),
    AuthenticationPolicyList(258),
    AuthenticationPolicyNames(259),
    AuthenticationStatus(260),
    AuthorizationMode(261),
    BelongsTo(262),
    CredentialDisable(263),
    CredentialStatus(264),
    Credentials(265),
    CredentialsInZone(266),
    DaysRemaining(267),
    EntryPoints(268),
    ExitPoints(269),
    ExpirationTime(270),
    ExtendedTimeEnable(271),
    FailedAttemptEvents(272),
    FailedAttempts(273),
    FailedAttemptsTime(274),
    LastAccessEvent(275),
    LastAccessPoint(276),
    LastCredentialAdded(277),
    LastCredentialAddedTime(278),
    LastCredentialRemoved(279),
    LastCredentialRemovedTime(280),
    LastUseTime(281),
    Lockout(282),
    LockoutRelinquishTime(283),
    MaxFailedAttempts(285),
    Members(286),
    MusterPoint(287),
    NegativeAccessRules(288),
    NumberOfAuthenticationPolicies(289),
    OccupancyCount(290),
    OccupancyCountAdjust(291),
    OccupancyCountEnable(292),
    OccupancyLowerLimit(294),
    OccupancyLowerLimitEnforced(295),
    OccupancyState(296),
    OccupancyUpperLimit(297),
    OccupancyUpperLimitEnforced(298),
    PassbackMode(300),
    PassbackTimeout(301),
    PositiveAccessRules(302),
    ReasonForDisable(303),
    SupportedFormats(304),
    SupportedFormatClasses(305),
    ThreatAuthority(306),
    ThreatLevel(307),
    TraceFlag(308),
    TransactionNotificationClass(309),
    UserExternalIdentifier(310),
    UserInformationReference(311),
    UserName(317),
    UserType(318),
    UsesRemaining(319),
    ZoneFrom(320),
    ZoneTo(321),
    AccessEventTag(322),
    GlobalIdentifier(323),
    VerificationTime(326),
    BaseDeviceSecurityPolicy(327),
    DistributionKeyRevision(328),
    DoNotHide(329),
    KeySets(330),
    LastKeyServer(331),
    NetworkAccessSecurityPolicies(332),
    PacketReorderTime(333),
    SecurityPduTimeout(334),
    SecurityTimeWindow(335),
    SupportedSecurityAlgorithms(336),
    UpdateKeySetTimeout(337),
    BackupAndRestoreState(338),
    BackupPreparationTime(339),
    RestoreCompletionTime(340),
    RestorePreparationTime(341),
    BitMask(342),
    BitText(343),
    IsUtc(344),
    GroupMembers(345),
    GroupMemberNames(346),
    MemberStatusFlags(347),
    RequestedUpdateInterval(348),
    CovuPeriod(349),
    CovuRecipients(350),
    EventMessageTexts(351),
    EventMessageTextsConfig(352),
    EventDetectionEnable(353),
    EventAlgorithmInhibit(354),
    EventAlgorithmInhibitRef(355),
    TimeDelayNormal(356),
    ReliabilityEvaluationInhibit(357),
    FaultParameters(358),
    FaultType(359),
    LocalForwardingOnly(360),
    ProcessIdentifierFilter(361),
    SubscribedRecipients(362),
    PortFilter(363),
    AuthorizationExemptions(364),
    AllowGroupDelayInhibit(365),
    ChannelNumber(366),
    ControlGroups(367),
    ExecutionDelay(368),
    LastPriority(369),
    WriteStatus(370),
    PropertyList(371),
    SerialNumber(372),
    BlinkWarnEnable(373),
    DefaultFadeTime(374),
    DefaultRampRate(375),
    DefaultStepIncrement(376),
    EgressTime(377),
    InProgress(378),
    InstantaneousPower(379),
    LightingCommand(380),
    LightingCommandDefaultPriority(381),
    MaxActualValue(382),
    MinActualValue(383),
    Power(384),
    Transition(385),
    EgressActive(386),
    InterfaceValue(387),
    FaultHighLimit(388),
    FaultLowLimit(389),
    LowDiffLimit(390),
    StrikeCount(391),
    TimeOfStrikeCountReset(392),
    DefaultTimeout(393),
    InitialTimeout(394),
    LastStateChange(395),
    StateChangeValues(396),
    TimerRunning(397),
    TimerState(398),
    ApduLength(399),
    IpAddress(400),
    IpDefaultGateway(401),
    IpDhcpEnable(402),
    IpDhcpLeaseTime(403),
    IpDhcpLeaseTimeRemaining(404),
    IpDhcpServer(405),
    IpDnsServer(406),
    BacnetIpGlobalAddress(407),
    BacnetIpMode(408),
    BacnetIpMulticastAddress(409),
    BacnetIpNatTraversal(410),
    IpSubnetMask(411),
    BacnetIpUdpPort(412),
    BbmdAcceptFdRegistrations(413),
    BbmdBroadcastDistributionTable(414),
    BbmdForeignDeviceTable(415),
    ChangesPending(416),
    Command(417),
    FdBbmdAddress(418),
    FdSubscriptionLifetime(419),
    LinkSpeed(420),
    LinkSpeeds(421),
    LinkSpeedAutonegotiate(422),
    MacAddress(423),
    NetworkInterfaceName(424),
    NetworkNumber(425),
    NetworkNumberQuality(426),
    NetworkType(427),
    RoutingTable(428),
    VirtualMacAddressTable(429),
    CommandTimeArray(430),
    CurrentCommandPriority(431),
    LastCommandTime(432),
    ValueSource(433),
    ValueSourceArray(434),
    BacnetIpv6Mode(435),
    Ipv6Address(436),
    Ipv6PrefixLength(437),
    BacnetIpv6UdpPort(438),
    Ipv6DefaultGateway(439),
    BacnetIpv6MulticastAddress(440),
    Ipv6DnsServer(441),
    Ipv6AutoAddressingEnable(442),
    Ipv6DhcpLeaseTime(443),
    Ipv6DhcpLeaseTimeRemaining(444),
    Ipv6DhcpServer(445),
    Ipv6ZoneIndex(446),
    AssignedLandingCalls(447),
    CarAssignedDirection(448),
    CarDoorCommand(449),
    CarDoorStatus(450),
    CarDoorText(451),
    CarDoorZone(452),
    CarDriveStatus(453),
    CarLoad(454),
    CarLoadUnits(455),
    CarMode(456),
    CarMovingDirection(457),
    CarPosition(458),
    ElevatorGroup(459),
    EnergyMeter(460),
    EnergyMeterRef(461),
    EscalatorMode(462),
    FaultSignals(463),
    FloorText(464),
    GroupId(465),
    GroupMode(467),
    HigherDeck(468),
    InstallationId(469),
    LandingCalls(470),
    LandingCallControl(471),
    LandingDoorStatus(472),
    LowerDeck(473),
    MachineRoomId(474),
    MakingCarCall(475),
    NextStoppingFloor(476),
    OperationDirection(477),
    PassengerAlarm(478),
    PowerMode(479),
    RegisteredCarCall(480),
    ActiveCovMultipleSubscriptions(481),
    ProtocolLevel(482),
    ReferencePort(483),
    DeployedProfileLocation(484),
    ProfileLocation(485),
    Tags(486),
    SubordinateNodeTypes(487),
    SubordinateTags(488),
    SubordinateRelationships(489),
    DefaultSubordinateRelationship(490),
    Represents(491),
    DefaultPresentValue(492),
    PresentStage(493),
    Stages(494),
    StageNames(495),
    TargetReferences(496),
    AuditSourceLevel(497),
    AuditLevel(498),
    AuditNotificationRecipient(499),
    AuditPriorityFilter(500),
    AuditableOperations(501),
    DeleteOnForward(502),
    MaximumSendDelay(503),
    MonitoredObjects(504),
    SendNow(505),
    FloorNumber(506),
    DeviceUuid(507);

    private final int code;

    private BacnetPropertyType(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static BacnetPropertyType forKey(String value) {
        ObjectUtils.requireNonNullArgument((Object)value, (String)"value");
        try {
            int code = Integer.parseInt(value);
            BacnetPropertyType result = (BacnetPropertyType)CodedValue.forCodeValue((int)code, BacnetPropertyType.class, null);
            if (result != null) {
                return result;
            }
            throw new IllegalArgumentException(String.format("Unsupported BacnetPropertyType value [%s]", value));
        }
        catch (NumberFormatException e) {
            try {
                return BacnetPropertyType.valueOf(value);
            }
            catch (IllegalArgumentException e2) {
                try {
                    return BacnetPropertyType.valueOf(BacnetUtils.kebabToCamelCase(value));
                }
                catch (IllegalArgumentException e3) {
                    throw new IllegalArgumentException(String.format("Unsupported BacnetPropertyType value [%s]", value));
                }
            }
        }
    }
}

