/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.io.bacnet;

public final class BacnetUtils {
    private BacnetUtils() {
    }

    public static String camelToKebabCase(String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        StringBuilder buf = new StringBuilder();
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (Character.isUpperCase(c)) {
                if (i > 0) {
                    buf.append('-');
                }
                buf.append(Character.toLowerCase(c));
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static String kebabToCamelCase(String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        int len = value.length();
        int idx = value.indexOf(45);
        if (idx < 0) {
            char c = value.charAt(0);
            if (Character.isUpperCase(c)) {
                return value;
            }
            StringBuilder buf = new StringBuilder(len);
            buf.append(Character.toUpperCase(c));
            if (len > 1) {
                buf.append(value.substring(1));
            }
            return buf.toString();
        }
        StringBuilder buf = new StringBuilder(len);
        int prev = 0;
        do {
            if (prev < len && idx > 0) {
                buf.append(Character.toUpperCase(value.charAt(prev)));
                ++prev;
            }
            if (prev < idx) {
                buf.append(value.substring(prev, idx));
                prev = idx + 1;
            } else if (idx == prev) {
                ++prev;
            }
            if (prev >= len || (idx = value.indexOf(45, prev)) >= 0) continue;
            idx = len;
        } while (prev < len);
        return buf.toString();
    }
}

