/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.io.bacnet;

import java.io.Serializable;
import java.util.Objects;
import net.solarnetwork.domain.CodedValue;
import net.solarnetwork.node.io.bacnet.BacnetDeviceObjectPropertyRef;
import net.solarnetwork.node.io.bacnet.BacnetObjectType;
import net.solarnetwork.node.io.bacnet.BacnetPropertyType;

public class SimpleBacnetDeviceObjectPropertyRef
implements BacnetDeviceObjectPropertyRef,
Serializable,
Comparable<BacnetDeviceObjectPropertyRef> {
    private static final long serialVersionUID = -2337176762098262203L;
    private final int deviceId;
    private final int objectType;
    private final int objectNumber;
    private final int propertyId;
    private final int propertyIndex;

    public SimpleBacnetDeviceObjectPropertyRef(int deviceId, int objectType, int objectNumber, int propertyId) {
        this(deviceId, objectType, objectNumber, propertyId, -1);
    }

    public SimpleBacnetDeviceObjectPropertyRef(int deviceId, int objectType, int objectNumber, int propertyId, int propertyIndex) {
        this.deviceId = deviceId;
        this.objectType = objectType;
        this.objectNumber = objectNumber;
        this.propertyId = propertyId;
        this.propertyIndex = propertyIndex;
    }

    @Override
    public int compareTo(BacnetDeviceObjectPropertyRef o) {
        int c = Integer.compare(this.deviceId, o.getDeviceId());
        if (c != 0) {
            return c;
        }
        c = Integer.compare(this.objectType, o.getObjectType());
        if (c != 0) {
            return c;
        }
        c = Integer.compare(this.objectNumber, o.getObjectNumber());
        if (c != 0) {
            return c;
        }
        c = Integer.compare(this.propertyId, o.getPropertyId());
        if (c != 0) {
            return c;
        }
        return Integer.compare(this.propertyIndex, o.getPropertyIndex());
    }

    public int hashCode() {
        return Objects.hash(this.deviceId, this.objectNumber, this.objectType, this.propertyId, this.propertyIndex);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SimpleBacnetDeviceObjectPropertyRef)) {
            return false;
        }
        SimpleBacnetDeviceObjectPropertyRef other = (SimpleBacnetDeviceObjectPropertyRef)obj;
        return this.deviceId == other.deviceId && this.objectNumber == other.objectNumber && this.objectType == other.objectType && this.propertyId == other.propertyId && this.propertyIndex == other.propertyIndex;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BACnetRef{device=");
        builder.append(this.deviceId);
        builder.append(", objectType=");
        try {
            BacnetObjectType objType = (BacnetObjectType)CodedValue.forCodeValue((int)this.objectType, BacnetObjectType.class, null);
            if (objType != null) {
                builder.append((Object)objType);
            } else {
                builder.append(this.objectType);
            }
        }
        catch (IllegalArgumentException e) {
            builder.append(this.objectType);
        }
        builder.append(", objectNumber=");
        builder.append(this.objectNumber);
        builder.append(", propertyType=");
        try {
            BacnetPropertyType propType = (BacnetPropertyType)CodedValue.forCodeValue((int)this.propertyId, BacnetPropertyType.class, null);
            if (propType != null) {
                builder.append((Object)propType);
            } else {
                builder.append(this.propertyId);
            }
        }
        catch (IllegalArgumentException e) {
            builder.append(this.propertyId);
        }
        if (this.hasPropertyIndex()) {
            builder.append(", propertyIndex=");
            builder.append(this.propertyIndex);
        }
        builder.append("}");
        return builder.toString();
    }

    @Override
    public int getDeviceId() {
        return this.deviceId;
    }

    @Override
    public int getObjectType() {
        return this.objectType;
    }

    @Override
    public int getObjectNumber() {
        return this.objectNumber;
    }

    @Override
    public int getPropertyId() {
        return this.propertyId;
    }

    @Override
    public int getPropertyIndex() {
        return this.propertyIndex;
    }
}

