/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.io.modbus;

import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.BitSet;
import net.solarnetwork.node.io.modbus.ModbusReadFunction;
import net.solarnetwork.node.io.modbus.ModbusWriteFunction;
import net.solarnetwork.node.service.LockTimeoutException;

public interface ModbusConnection
extends Closeable {
    public int getUnitId();

    public void open() throws IOException, LockTimeoutException;

    @Override
    public void close();

    default public BitSet readDiscreteValues(int address, int count) throws IOException {
        return this.readDiscreetValues(address, count);
    }

    @Deprecated
    public BitSet readDiscreetValues(int var1, int var2) throws IOException;

    default public BitSet readDiscreteValues(int[] addresses, int count) throws IOException {
        return this.readDiscreetValues(addresses, count);
    }

    @Deprecated
    public BitSet readDiscreetValues(int[] var1, int var2) throws IOException;

    default public void writeDiscreteValues(int[] addresses, BitSet bits) throws IOException {
        this.writeDiscreetValues(addresses, bits);
    }

    @Deprecated
    public void writeDiscreetValues(int[] var1, BitSet var2) throws IOException;

    public BitSet readInputDiscreteValues(int var1, int var2) throws IOException;

    public short[] readWords(ModbusReadFunction var1, int var2, int var3) throws IOException;

    public int[] readWordsUnsigned(ModbusReadFunction var1, int var2, int var3) throws IOException;

    public void writeWords(ModbusWriteFunction var1, int var2, short[] var3) throws IOException;

    public void writeWords(ModbusWriteFunction var1, int var2, int[] var3) throws IOException;

    public byte[] readBytes(ModbusReadFunction var1, int var2, int var3) throws IOException;

    public void writeBytes(ModbusWriteFunction var1, int var2, byte[] var3) throws IOException;

    public String readString(ModbusReadFunction var1, int var2, int var3, boolean var4, Charset var5) throws IOException;

    public void writeString(ModbusWriteFunction var1, int var2, String var3, Charset var4) throws IOException;
}

