/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.io.modbus;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import net.solarnetwork.node.domain.DataAccessor;
import net.solarnetwork.node.io.modbus.ModbusConnection;
import net.solarnetwork.node.io.modbus.ModbusDataType;
import net.solarnetwork.node.io.modbus.ModbusDataUtils;
import net.solarnetwork.node.io.modbus.ModbusReadFunction;
import net.solarnetwork.node.io.modbus.ModbusReference;
import net.solarnetwork.node.io.modbus.ModbusWordOrder;
import net.solarnetwork.util.ByteUtils;
import net.solarnetwork.util.CollectionUtils;
import net.solarnetwork.util.Half;
import net.solarnetwork.util.IntRange;
import net.solarnetwork.util.IntRangeSet;
import net.solarnetwork.util.IntShortMap;

public class ModbusData
implements DataAccessor {
    private final IntShortMap dataRegisters;
    private long dataTimestamp = 0L;
    private ModbusWordOrder wordOrder;

    public ModbusData() {
        this.dataRegisters = new IntShortMap(64);
        this.wordOrder = ModbusWordOrder.MostToLeastSignificant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModbusData(ModbusData other) {
        IntShortMap intShortMap = other.dataRegisters;
        synchronized (intShortMap) {
            this.dataRegisters = (IntShortMap)other.dataRegisters.clone();
            this.dataTimestamp = other.dataTimestamp;
            this.wordOrder = other.wordOrder;
        }
    }

    public int size() {
        return this.dataRegisters.size();
    }

    public boolean isEmpty() {
        return this.dataRegisters.isEmpty();
    }

    public Instant getDataTimestamp() {
        return this.dataTimestamp > 0L ? Instant.ofEpochMilli(this.dataTimestamp) : null;
    }

    public Map<String, Object> getDeviceInfo() {
        return Collections.emptyMap();
    }

    public ModbusData copy() {
        return new ModbusData(this);
    }

    public final Number getNumber(ModbusReference ref) {
        return this.getNumber(ref, 0);
    }

    public final Number getNumber(ModbusReference ref, int offset) {
        if (ref == null) {
            return null;
        }
        ModbusDataType type = ref.getDataType();
        if (type == null) {
            type = ModbusDataType.UInt16;
        }
        int addr = ref.getAddress() + offset;
        switch (type) {
            case Boolean: {
                return this.getBoolean(addr) != false ? 1 : 0;
            }
            case Float16: {
                return this.getFloat16(addr);
            }
            case Float32: {
                return this.getFloat32(addr);
            }
            case Float64: {
                return this.getFloat64(addr);
            }
            case Int16: {
                return this.getInt16(addr);
            }
            case Int32: {
                return this.getInt32(addr);
            }
            case Int64: {
                return this.getInt64(addr);
            }
            case UInt16: {
                return this.getUnsignedInt16(addr);
            }
            case UInt32: {
                return this.getUnsignedInt32(addr);
            }
            case UInt64: {
                return this.getUnsignedInt64(addr);
            }
        }
        throw new IllegalArgumentException("Cannot get number for " + (Object)((Object)type) + " type reference");
    }

    public final Boolean getBoolean(int addr) {
        short s = this.dataRegisters.getValue(addr);
        return s != 0;
    }

    public final Integer getUnsignedInt16(int addr) {
        short s = this.dataRegisters.getValue(addr);
        return s & 0xFFFF;
    }

    public final Short getInt16(int addr) {
        return this.dataRegisters.getValue(addr);
    }

    public final Long getUnsignedInt32(int hiAddr, int loAddr) {
        return ModbusDataUtils.parseUnsignedInt32(this.dataRegisters.getValue(hiAddr), this.dataRegisters.getValue(loAddr));
    }

    public final Integer getInt32(int hiAddr, int loAddr) {
        return ModbusDataUtils.parseInt32(this.dataRegisters.getValue(hiAddr), this.dataRegisters.getValue(loAddr));
    }

    public final Integer getInt32(int addr) {
        return this.wordOrder == ModbusWordOrder.MostToLeastSignificant ? this.getInt32(addr, addr + 1) : this.getInt32(addr + 1, addr);
    }

    public final Long getUnsignedInt32(int addr) {
        return this.wordOrder == ModbusWordOrder.MostToLeastSignificant ? this.getUnsignedInt32(addr, addr + 1) : this.getUnsignedInt32(addr + 1, addr);
    }

    public final Half getFloat16(int addr) {
        return ModbusDataUtils.parseFloat16(this.dataRegisters.getValue(addr));
    }

    public final Float getFloat32(int hiAddr, int loAddr) {
        return ModbusDataUtils.parseFloat32(this.dataRegisters.getValue(hiAddr), this.dataRegisters.getValue(loAddr));
    }

    public final Float getFloat32(int addr) {
        return this.wordOrder == ModbusWordOrder.MostToLeastSignificant ? this.getFloat32(addr, addr + 1) : this.getFloat32(addr + 1, addr);
    }

    public final Long getInt64(int h1Addr, int h2Addr, int l1Addr, int l2Addr) {
        return ModbusDataUtils.parseInt64(this.dataRegisters.getValue(h1Addr), this.dataRegisters.getValue(h2Addr), this.dataRegisters.getValue(l1Addr), this.dataRegisters.getValue(l2Addr));
    }

    public final Long getInt64(int addr) {
        return this.wordOrder == ModbusWordOrder.MostToLeastSignificant ? this.getInt64(addr, addr + 1, addr + 2, addr + 3) : this.getInt64(addr + 3, addr + 2, addr + 1, addr);
    }

    public final BigInteger getUnsignedInt64(int h1Addr, int h2Addr, int l1Addr, int l2Addr) {
        return ModbusDataUtils.parseUnsignedInt64(this.dataRegisters.getValue(h1Addr), this.dataRegisters.getValue(h2Addr), this.dataRegisters.getValue(l1Addr), this.dataRegisters.getValue(l2Addr));
    }

    public final BigInteger getUnsignedInt64(int addr) {
        return this.wordOrder == ModbusWordOrder.MostToLeastSignificant ? this.getUnsignedInt64(addr, addr + 1, addr + 2, addr + 3) : this.getUnsignedInt64(addr + 3, addr + 2, addr + 1, addr);
    }

    public final Double getFloat64(int h1Addr, int h2Addr, int l1Addr, int l2Addr) {
        return ModbusDataUtils.parseFloat64(this.dataRegisters.getValue(h1Addr), this.dataRegisters.getValue(h2Addr), this.dataRegisters.getValue(l1Addr), this.dataRegisters.getValue(l2Addr));
    }

    public final Double getFloat64(int addr) {
        return this.wordOrder == ModbusWordOrder.MostToLeastSignificant ? this.getFloat64(addr, addr + 1, addr + 2, addr + 3) : this.getFloat64(addr + 3, addr + 2, addr + 1, addr);
    }

    public byte[] getBytes(int addr, int count) {
        byte[] result = new byte[count * 2];
        int i = addr;
        int end = addr + count;
        int index = 0;
        while (i < end) {
            short word = this.dataRegisters.getValue(i);
            result[index] = (byte)(word >> 8 & 0xFF);
            result[index + 1] = (byte)(word & 0xFF);
            ++i;
            index += 2;
        }
        return result;
    }

    public final String getString(int addr, int count, boolean trim, String charsetName) {
        return this.getString(addr, count, trim, Charset.forName(charsetName));
    }

    public final String getString(int addr, int count, boolean trim, Charset charset) {
        byte[] bytes = this.getBytes(addr, count);
        String result = null;
        if (bytes != null) {
            result = new String(bytes, charset);
            if (trim) {
                result = result.trim().replace("\u0000", "");
            }
        }
        return result;
    }

    public final String getUtf8String(int addr, int count, boolean trim) {
        return this.getString(addr, count, trim, ByteUtils.UTF8);
    }

    public final String getAsciiString(int addr, int count, boolean trim) {
        return this.getString(addr, count, trim, ByteUtils.ASCII);
    }

    public final String getUtf8String(ModbusReference ref, boolean trim) {
        return this.getUtf8String(ref, 0, trim);
    }

    public final String getUtf8String(ModbusReference ref, int offset, boolean trim) {
        return this.getString(ref.getAddress() + offset, ref.getWordLength(), trim, ByteUtils.UTF8);
    }

    public final String getAsciiString(ModbusReference ref, boolean trim) {
        return this.getAsciiString(ref, 0, trim);
    }

    public final String getAsciiString(ModbusReference ref, int offset, boolean trim) {
        return this.getString(ref.getAddress() + offset, ref.getWordLength(), trim, ByteUtils.ASCII);
    }

    public final String getLatin1String(ModbusReference ref, int offset, boolean trim) {
        return this.getString(ref.getAddress() + offset, ref.getWordLength(), trim, ByteUtils.LATIN1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ModbusData performUpdates(ModbusDataUpdateAction action) throws IOException {
        IntShortMap intShortMap = this.dataRegisters;
        synchronized (intShortMap) {
            long now = System.currentTimeMillis();
            if (action.updateModbusData(new MutableModbusDataView(this.dataRegisters))) {
                this.dataTimestamp = now;
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ModbusData expire() {
        IntShortMap intShortMap = this.dataRegisters;
        synchronized (intShortMap) {
            this.dataTimestamp = 0L;
        }
        return this;
    }

    public Object getValue(ModbusReference ref) {
        return this.getValue(ref.getDataType(), ref.getAddress(), ref.getWordLength());
    }

    public Object getValue(ModbusDataType dataType, int address, int count) {
        switch (dataType) {
            case Boolean: {
                return this.getBoolean(address);
            }
            case Bytes: {
                return this.getBytes(address, count);
            }
            case Float16: {
                return this.getFloat16(address);
            }
            case Float32: {
                return this.getFloat32(address);
            }
            case Float64: {
                return this.getFloat64(address);
            }
            case Int16: {
                return this.getInt16(address);
            }
            case UInt16: {
                return this.getUnsignedInt16(address);
            }
            case Int32: {
                return this.getInt32(address);
            }
            case UInt32: {
                return this.getUnsignedInt32(address);
            }
            case Int64: {
                return this.getInt64(address);
            }
            case UInt64: {
                return this.getUnsignedInt64(address);
            }
            case StringAscii: {
                return this.getAsciiString(address, count, true);
            }
            case StringUtf8: {
                return this.getUtf8String(address, count, true);
            }
        }
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ModbusData{dataTimestamp=");
        builder.append(this.dataTimestamp);
        builder.append(", ");
        if (this.wordOrder != null) {
            builder.append("wordOrder=");
            builder.append((Object)this.wordOrder);
            builder.append(", ");
        }
        if (this.dataRegisters != null) {
            builder.append("dataRegisters=");
            builder.append(this.dataRegisters);
        }
        builder.append("}");
        return builder.toString();
    }

    public final String dataDebugString() {
        StringBuilder buf = new StringBuilder(this.getClass().getSimpleName()).append("{");
        if (!this.dataRegisters.isEmpty()) {
            int[] last = new int[]{-2};
            this.dataRegisters.forEachOrdered((k, v) -> {
                boolean odd;
                boolean bl = odd = k % 2 == 1;
                if (k > last[0] + 1) {
                    int rowAddr = odd ? k - 1 : k;
                    buf.append("\n\t").append(String.format("%5d", rowAddr)).append(": ");
                    if (odd) {
                        buf.append("      , ");
                    }
                    last[0] = k;
                    if (odd) {
                        last[0] = last[0] - 1;
                    }
                } else if (odd) {
                    buf.append(", ");
                }
                buf.append(String.format("0x%04X", v));
            });
            buf.append("\n");
        }
        buf.append("}");
        return buf.toString();
    }

    public final void slice(short[] dest, int destFrom, int address, int length) {
        this.dataRegisters.forEachOrdered(address, address + length, (i, v) -> {
            int idx = i - address + destFrom;
            if (idx < dest.length) {
                dest[idx] = v;
            }
        });
    }

    public final ModbusWordOrder getWordOrder() {
        return this.wordOrder;
    }

    public final void setWordOrder(ModbusWordOrder wordOrder) {
        if (wordOrder == null) {
            return;
        }
        this.wordOrder = wordOrder;
    }

    public final void refreshData(ModbusConnection conn, IntRangeSet rangeSet) throws IOException {
        this.refreshData(conn, ModbusReadFunction.ReadHoldingRegister, rangeSet, 64);
    }

    public final void refreshData(ModbusConnection conn, ModbusReadFunction readFunction, IntRangeSet rangeSet, int maxRangeLength) throws IOException {
        List ranges = CollectionUtils.coveringIntRanges((SortedSet)rangeSet, (int)maxRangeLength);
        this.refreshData(conn, readFunction, ranges);
    }

    public final void refreshData(final ModbusConnection conn, final ModbusReadFunction readFunction, final Collection<IntRange> ranges) throws IOException {
        this.performUpdates(new ModbusDataUpdateAction(){

            @Override
            public boolean updateModbusData(MutableModbusData m) throws IOException {
                ModbusData.this.refreshData(conn, readFunction, ranges, m);
                return true;
            }
        });
    }

    public final void refreshData(ModbusConnection conn, ModbusReadFunction readFunction, Collection<IntRange> ranges, MutableModbusData m) throws IOException {
        for (IntRange r : ranges) {
            short[] data = conn.readWords(readFunction, r.getMin(), r.length());
            m.saveDataArray(data, r.getMin());
        }
    }

    public final Map<Integer, Integer> getUnsignedDataMap() {
        IntShortMap data = (IntShortMap)this.dataRegisters.clone();
        return data.unsignedMap();
    }

    public final IntShortMap dataRegisters() {
        return this.dataRegisters;
    }

    public static class MutableModbusDataView
    implements MutableModbusData {
        private final IntShortMap dataRegisters;

        public MutableModbusDataView(IntShortMap dataRegisters) {
            this.dataRegisters = dataRegisters;
        }

        public MutableModbusDataView(IntShortMap dataRegisters, ModbusWordOrder wordOrder) {
            this(dataRegisters);
        }

        @Override
        public final void saveDataMap(Map<Integer, ? extends Number> data) {
            for (Map.Entry<Integer, ? extends Number> me : data.entrySet()) {
                this.dataRegisters.putValue(me.getKey().intValue(), me.getValue().shortValue());
            }
        }

        @Override
        public final void saveDataArray(short[] data, int addr) {
            if (data == null || data.length < 1) {
                return;
            }
            for (short v : data) {
                this.dataRegisters.putValue(addr, v);
                ++addr;
            }
        }

        @Override
        public final void saveDataArray(int[] data, int addr) {
            if (data == null || data.length < 1) {
                return;
            }
            for (int v : data) {
                this.dataRegisters.putValue(addr, (short)(v & 0xFFFF));
                ++addr;
            }
        }

        @Override
        public final void saveDataArray(Integer[] data, int addr) {
            if (data == null || data.length < 1) {
                return;
            }
            for (Integer v : data) {
                this.dataRegisters.putValue(addr, (short)(v & 0xFFFF));
                ++addr;
            }
        }

        @Override
        public void saveBytes(byte[] data, int addr) {
            if (data == null || data.length < 1) {
                return;
            }
            int i = 0;
            int j = 0;
            while (i < data.length) {
                int n = (data[i] & 0xFF) << 8;
                if (i + 1 < data.length) {
                    n |= data[i + 1] & 0xFF;
                }
                int idx = addr + j;
                this.dataRegisters.putValue(idx, (short)n);
                i += 2;
                ++j;
            }
        }
    }

    public static interface ModbusDataUpdateAction {
        public boolean updateModbusData(MutableModbusData var1) throws IOException;
    }

    public static interface MutableModbusData {
        public void saveDataMap(Map<Integer, ? extends Number> var1);

        public void saveDataArray(short[] var1, int var2);

        public void saveDataArray(int[] var1, int var2);

        public void saveDataArray(Integer[] var1, int var2);

        public void saveBytes(byte[] var1, int var2);
    }
}

