/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.io.modbus;

public enum ModbusDataType {
    Boolean("bit", 1),
    Float16("f16", 1),
    Float32("f32", 2),
    Float64("f64", 4),
    Int16("i16", 1),
    UInt16("u16", 1),
    Int32("i32", 2),
    UInt32("u32", 2),
    Int64("i64", 4),
    UInt64("u64", 4),
    Bytes("b", -1),
    StringUtf8("s", -1),
    StringAscii("a", -1);

    private final String key;
    private final int wordLength;

    private ModbusDataType(String key, int wordLength) {
        this.key = key;
        this.wordLength = wordLength;
    }

    public String getKey() {
        return this.key;
    }

    public int getWordLength() {
        return this.wordLength;
    }

    public static ModbusDataType forKey(String key) {
        for (ModbusDataType e : ModbusDataType.values()) {
            if (!key.equals(e.key)) continue;
            return e;
        }
        throw new IllegalArgumentException("Unknown ModbusDataType key [" + key + "]");
    }

    public String toDisplayString() {
        switch (this) {
            case Boolean: {
                return "Bit (on/off)";
            }
            case Bytes: {
                return "Bytes, 8-bit (two per register)";
            }
            case Float16: {
                return "16-bit floating point (1 register)";
            }
            case Float32: {
                return "32-bit floating point (2 registers)";
            }
            case Float64: {
                return "64-bit floating point (4 registers)";
            }
            case Int16: {
                return "16-bit signed integer (1 register)";
            }
            case Int32: {
                return "32-bit signed integer (2 registers)";
            }
            case Int64: {
                return "64-bit signed integer (4 registers)";
            }
            case StringAscii: {
                return "String (ASCII)";
            }
            case StringUtf8: {
                return "String (UTF-8)";
            }
            case UInt16: {
                return "16-bit unsigned integer (1 register)";
            }
            case UInt32: {
                return "32-bit unsigned integer (2 registers)";
            }
            case UInt64: {
                return "64-bit unsigned integer (4 registers)";
            }
        }
        return this.toString();
    }
}

