/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.io.modbus;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.BitSet;
import net.solarnetwork.node.io.modbus.ModbusDataType;
import net.solarnetwork.node.io.modbus.ModbusWordOrder;
import net.solarnetwork.util.Half;

public final class ModbusDataUtils {
    public static Integer[] integerArray(short[] array) {
        if (array == null) {
            return null;
        }
        int count = array.length;
        Integer[] result = new Integer[count];
        for (int i = 0; i < count; ++i) {
            result[i] = array[i] & 0xFFFF;
        }
        return result;
    }

    public static int[] unsignedIntArray(short[] array) {
        if (array == null) {
            return null;
        }
        int count = array.length;
        int[] result = new int[count];
        for (int i = 0; i < count; ++i) {
            result[i] = array[i] & 0xFFFF;
        }
        return result;
    }

    public static short[] shortArray(int[] array) {
        if (array == null) {
            return null;
        }
        int count = array.length;
        short[] result = new short[count];
        for (int i = 0; i < count; ++i) {
            result[i] = (short)array[i];
        }
        return result;
    }

    public static short[] encodeNumber(ModbusDataType dataType, Number number) {
        return ModbusDataUtils.encodeNumber(dataType, number, ModbusWordOrder.MostToLeastSignificant);
    }

    public static short[] encodeNumber(ModbusDataType dataType, Number number, ModbusWordOrder wordOrder) {
        short[] result = null;
        switch (dataType) {
            case Boolean: {
                result = new short[]{number != null && number.intValue() != 0 ? (short)1 : 0};
                break;
            }
            case Float16: {
                result = new short[]{ModbusDataUtils.encodeFloat16((Half)(number instanceof Half ? (Half)number : (number != null ? Half.valueOf((String)number.toString()) : null)))};
                break;
            }
            case Float32: {
                result = ModbusDataUtils.encodeFloat32(Float.valueOf(number != null ? number.floatValue() : 0.0f));
                break;
            }
            case Float64: {
                result = ModbusDataUtils.encodeFloat64(number != null ? number.doubleValue() : 0.0);
                break;
            }
            case Int16: {
                result = ModbusDataUtils.encodeInt16(number != null ? number.shortValue() : (short)0);
                break;
            }
            case UInt16: {
                result = ModbusDataUtils.encodeUnsignedInt16(number != null ? number.intValue() : 0);
                break;
            }
            case Int32: {
                result = ModbusDataUtils.encodeInt32(number != null ? number.intValue() : 0);
                break;
            }
            case UInt32: {
                result = ModbusDataUtils.encodeUnsignedInt32(number != null ? number.longValue() : 0L);
                break;
            }
            case Int64: {
                result = ModbusDataUtils.encodeInt64(number != null ? number.longValue() : 0L);
                break;
            }
            case UInt64: {
                try {
                    result = ModbusDataUtils.encodeUnsignedInt64(number instanceof BigInteger ? (BigInteger)number : (number != null ? new BigInteger(number.toString()) : BigInteger.ZERO));
                }
                catch (NumberFormatException e) {
                    result = ModbusDataUtils.encodeInt64(0L);
                }
                break;
            }
            case Bytes: {
                try {
                    result = ModbusDataUtils.encodeUnsignedInteger(number instanceof BigInteger ? (BigInteger)number : (number != null ? new BigInteger(number.toString()) : BigInteger.ZERO));
                }
                catch (NumberFormatException e) {
                    result = new short[]{0};
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type " + (Object)((Object)dataType) + " cannot be converted into a number");
            }
        }
        if (result != null && wordOrder == ModbusWordOrder.LeastToMostSignificant) {
            ModbusDataUtils.swapWordOrder(result);
        }
        return result;
    }

    public static short[] encodeInt16(Short value) {
        short bits = value != null ? value : (short)0;
        return new short[]{bits};
    }

    public static short[] encodeUnsignedInt16(Integer value) {
        int bits = value != null ? value : 0;
        return new short[]{(short)(bits & 0xFFFF)};
    }

    public static short[] encodeInt32(Integer value) {
        return ModbusDataUtils.encodeInt32(value, ModbusWordOrder.MostToLeastSignificant);
    }

    public static short[] encodeInt32(Integer value, ModbusWordOrder wordOrder) {
        int bits = value != null ? value : 0;
        short[] result = new short[]{(short)(bits >> 16 & 0xFFFF), (short)(bits & 0xFFFF)};
        if (wordOrder == ModbusWordOrder.LeastToMostSignificant) {
            ModbusDataUtils.swapWordOrder(result);
        }
        return result;
    }

    public static short[] encodeUnsignedInt32(Long value) {
        return ModbusDataUtils.encodeUnsignedInt32(value, ModbusWordOrder.MostToLeastSignificant);
    }

    public static short[] encodeUnsignedInt32(Long value, ModbusWordOrder wordOrder) {
        short[] words = ModbusDataUtils.encodeInt64(value, wordOrder);
        if (wordOrder == ModbusWordOrder.MostToLeastSignificant) {
            return new short[]{words[2], words[3]};
        }
        return new short[]{words[0], words[1]};
    }

    public static short[] encodeInt64(Long value) {
        return ModbusDataUtils.encodeInt64(value, ModbusWordOrder.MostToLeastSignificant);
    }

    public static short[] encodeInt64(Long value, ModbusWordOrder wordOrder) {
        long bits = value != null ? value : 0L;
        short[] result = new short[]{(short)(bits >> 48 & 0xFFFFL), (short)(bits >> 32 & 0xFFFFL), (short)(bits >> 16 & 0xFFFFL), (short)(bits & 0xFFFFL)};
        if (wordOrder == ModbusWordOrder.LeastToMostSignificant) {
            ModbusDataUtils.swapWordOrder(result);
        }
        return result;
    }

    public static short[] encodeUnsignedInt64(BigInteger value) {
        return ModbusDataUtils.encodeUnsignedInt64(value, ModbusWordOrder.MostToLeastSignificant);
    }

    public static short[] encodeUnsignedInt64(BigInteger value, ModbusWordOrder wordOrder) {
        byte[] bytes = value.toByteArray();
        if (bytes[0] == 0 && bytes.length % 2 == 1 && bytes.length < 9) {
            bytes = Arrays.copyOfRange(bytes, 1, bytes.length);
        }
        if (bytes.length > 8) {
            bytes = Arrays.copyOfRange(bytes, bytes.length - 8, bytes.length);
        }
        if (bytes.length % 2 == 1) {
            byte[] tmp = new byte[bytes.length + 1];
            System.arraycopy(bytes, 0, tmp, 1, bytes.length);
            bytes = tmp;
        }
        short[] words = new short[4];
        int offset = (8 - bytes.length) / 2;
        for (int i = 0; i < bytes.length; i += 2) {
            int v = (bytes[i] & 0xFF) << 8;
            if (i + 1 < bytes.length) {
                v |= bytes[i + 1] & 0xFF;
            }
            words[offset + i / 2] = (short)(v & 0xFFFF);
        }
        if (wordOrder == ModbusWordOrder.LeastToMostSignificant) {
            ModbusDataUtils.swapWordOrder(words);
        }
        return words;
    }

    public static short[] encodeUnsignedInteger(BigInteger value) {
        return ModbusDataUtils.encodeUnsignedInteger(value, ModbusWordOrder.MostToLeastSignificant);
    }

    public static short[] encodeUnsignedInteger(BigInteger value, ModbusWordOrder wordOrder) {
        byte[] bytes = value.toByteArray();
        if (bytes[0] == 0 && bytes.length % 2 == 1) {
            bytes = Arrays.copyOfRange(bytes, 1, bytes.length);
        }
        if (bytes.length % 2 == 1) {
            byte[] tmp = new byte[bytes.length + 1];
            System.arraycopy(bytes, 0, tmp, 1, bytes.length);
            bytes = tmp;
        }
        short[] words = new short[bytes.length / 2];
        for (int i = 0; i < bytes.length; i += 2) {
            int v = (bytes[i] & 0xFF) << 8;
            if (i + 1 < bytes.length) {
                v |= bytes[i + 1] & 0xFF;
            }
            words[i / 2] = (short)v;
        }
        if (wordOrder == ModbusWordOrder.LeastToMostSignificant) {
            ModbusDataUtils.swapWordOrder(words);
        }
        return words;
    }

    public static void swapWordOrder(short[] array) {
        for (int i = 0; i < array.length / 2; ++i) {
            short temp = array[i];
            array[i] = array[array.length - i - 1];
            array[array.length - i - 1] = temp;
        }
    }

    public static short encodeFloat16(Half value) {
        return value != null ? value.halfValue() : (short)0;
    }

    public static short[] encodeFloat32(Float value) {
        return ModbusDataUtils.encodeFloat32(value, ModbusWordOrder.MostToLeastSignificant);
    }

    public static short[] encodeFloat32(Float value, ModbusWordOrder wordOrder) {
        int bits = Float.floatToIntBits(value != null ? value.floatValue() : 0.0f);
        return ModbusDataUtils.encodeInt32(bits, wordOrder);
    }

    public static short[] encodeFloat64(Double value) {
        return ModbusDataUtils.encodeFloat64(value, ModbusWordOrder.MostToLeastSignificant);
    }

    public static short[] encodeFloat64(Double value, ModbusWordOrder wordOrder) {
        long bits = Double.doubleToLongBits(value != null ? value : 0.0);
        return ModbusDataUtils.encodeInt64(bits, wordOrder);
    }

    public static short[] encodeBytes(byte[] data) {
        return ModbusDataUtils.encodeBytes(data, ModbusWordOrder.MostToLeastSignificant);
    }

    public static short[] encodeBytes(byte[] data, ModbusWordOrder wordOrder) {
        if (data == null || data.length < 1) {
            return new short[0];
        }
        short[] words = new short[(int)Math.ceil((double)data.length / 2.0)];
        int i = 0;
        int p = 0;
        while (i < data.length) {
            short n = (short)((data[i] & 0xFF) << 8);
            if (i + 1 < data.length) {
                n = (short)(n | data[i + 1] & 0xFF);
            }
            words[p] = n;
            i += 2;
            ++p;
        }
        if (wordOrder == ModbusWordOrder.LeastToMostSignificant) {
            ModbusDataUtils.swapWordOrder(words);
        }
        return words;
    }

    public static Number parseNumber(ModbusDataType dataType, short[] words, int offset) {
        return ModbusDataUtils.parseNumber(dataType, words, offset, ModbusWordOrder.MostToLeastSignificant);
    }

    public static Number parseNumber(ModbusDataType dataType, short[] words, int offset, ModbusWordOrder wordOrder) {
        Number result = null;
        switch (dataType) {
            case Boolean: {
                if (offset >= words.length) break;
                result = words[offset] == 0 ? (byte)0 : 1;
                break;
            }
            case Float16: {
                if (offset >= words.length) break;
                result = ModbusDataUtils.parseFloat16(words[offset]);
                break;
            }
            case Float32: {
                if (offset + 1 >= words.length) break;
                if (wordOrder == ModbusWordOrder.MostToLeastSignificant) {
                    result = ModbusDataUtils.parseFloat32(words[offset], words[offset + 1]);
                    break;
                }
                result = ModbusDataUtils.parseFloat32(words[offset + 1], words[offset]);
                break;
            }
            case Float64: {
                if (offset + 3 >= words.length) break;
                if (wordOrder == ModbusWordOrder.MostToLeastSignificant) {
                    result = ModbusDataUtils.parseFloat64(words[offset], words[offset + 1], words[offset + 2], words[offset + 3]);
                    break;
                }
                result = ModbusDataUtils.parseFloat64(words[offset + 3], words[offset + 2], words[offset + 1], words[offset]);
                break;
            }
            case Int16: {
                if (offset >= words.length) break;
                result = ModbusDataUtils.parseInt16(words[offset]);
                break;
            }
            case UInt16: {
                if (offset >= words.length) break;
                result = ModbusDataUtils.parseUnsignedInt16(words[offset]);
                break;
            }
            case Int32: {
                if (offset + 1 >= words.length) break;
                if (wordOrder == ModbusWordOrder.MostToLeastSignificant) {
                    result = ModbusDataUtils.parseInt32(words[offset], words[offset + 1]);
                    break;
                }
                result = ModbusDataUtils.parseInt32(words[offset + 1], words[offset]);
                break;
            }
            case UInt32: {
                if (offset + 1 >= words.length) break;
                if (wordOrder == ModbusWordOrder.MostToLeastSignificant) {
                    result = ModbusDataUtils.parseUnsignedInt32(words[offset], words[offset + 1]);
                    break;
                }
                result = ModbusDataUtils.parseUnsignedInt32(words[offset + 1], words[offset]);
                break;
            }
            case Int64: {
                if (offset + 3 >= words.length) break;
                if (wordOrder == ModbusWordOrder.MostToLeastSignificant) {
                    result = ModbusDataUtils.parseInt64(words[offset], words[offset + 1], words[offset + 2], words[offset + 3]);
                    break;
                }
                result = ModbusDataUtils.parseInt64(words[offset + 3], words[offset + 2], words[offset + 1], words[offset]);
                break;
            }
            case UInt64: {
                if (offset + 3 >= words.length) break;
                if (wordOrder == ModbusWordOrder.MostToLeastSignificant) {
                    result = ModbusDataUtils.parseUnsignedInt64(words[offset], words[offset + 1], words[offset + 2], words[offset + 3]);
                    break;
                }
                result = ModbusDataUtils.parseUnsignedInt64(words[offset + 3], words[offset + 2], words[offset + 1], words[offset]);
                break;
            }
            case Bytes: {
                result = ModbusDataUtils.parseUnsignedInteger(words, offset);
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type " + (Object)((Object)dataType) + " cannot be converted into a number");
            }
        }
        return result;
    }

    public static short toInt16(short lo) {
        return lo;
    }

    public static Short parseInt16(short lo) {
        return lo;
    }

    public static int toUnsignedInt16(short lo) {
        return lo & 0xFFFF;
    }

    public static Integer parseUnsignedInt16(short lo) {
        return ModbusDataUtils.toUnsignedInt16(lo);
    }

    public static int toInt32(short hi, short lo) {
        return (hi & 0xFFFF) << 16 | lo & 0xFFFF;
    }

    public static Integer parseInt32(short hi, short lo) {
        return ModbusDataUtils.toInt32(hi, lo);
    }

    public static long toUnsignedInt32(short hi, short lo) {
        return ((long)hi & 0xFFFFL) << 16 | (long)lo & 0xFFFFL;
    }

    public static Long parseUnsignedInt32(short hi, short lo) {
        return ModbusDataUtils.toUnsignedInt32(hi, lo);
    }

    public static long toInt64(short h1, short h2, short l1, short l2) {
        return ((long)h1 & 0xFFFFL) << 48 | ((long)h2 & 0xFFFFL) << 32 | ((long)l1 & 0xFFFFL) << 16 | (long)l2 & 0xFFFFL;
    }

    public static Long parseInt64(short h1, short h2, short l1, short l2) {
        return ModbusDataUtils.toInt64(h1, h2, l1, l2);
    }

    public static BigInteger parseUnsignedInt64(short h1, short h2, short l1, short l2) {
        int[] data = new int[]{h1, h2, l1, l2};
        BigInteger r = new BigInteger("0");
        for (int i = 0; i < 4; ++i) {
            if (i > 0) {
                r = r.shiftLeft(16);
            }
            r = r.add(new BigInteger(String.valueOf(data[i] & 0xFFFF)));
        }
        return r;
    }

    public static Half parseFloat16(short val) {
        Half result = Half.valueOf((short)val);
        if (result.isNaN()) {
            result = null;
        }
        return result;
    }

    public static float toFloat32(short hi, short lo) {
        int int32 = ModbusDataUtils.toInt32(hi, lo);
        return Float.intBitsToFloat(int32);
    }

    public static Float parseFloat32(short hi, short lo) {
        Float result = Float.valueOf(ModbusDataUtils.toFloat32(hi, lo));
        if (result.isNaN()) {
            result = null;
        }
        return result;
    }

    public static double toFloat64(short h1, short h2, short l1, short l2) {
        long l = ModbusDataUtils.toInt64(h1, h2, l1, l2);
        return Double.longBitsToDouble(l);
    }

    public static Double parseFloat64(short h1, short h2, short l1, short l2) {
        Double result = ModbusDataUtils.toFloat64(h1, h2, l1, l2);
        if (result.isNaN()) {
            result = null;
        }
        return result;
    }

    public static byte[] parseBytes(short[] words, int offset) {
        return ModbusDataUtils.parseBytes(words, offset, ModbusWordOrder.MostToLeastSignificant);
    }

    public static byte[] parseBytes(short[] words, int offset, ModbusWordOrder wordOrder) {
        byte[] bytes = new byte[2 * (words == null || offset >= words.length ? 0 : words.length - offset)];
        if (bytes.length > 0) {
            int i = offset;
            int p = 0;
            while (i < words.length) {
                int idx = wordOrder == ModbusWordOrder.MostToLeastSignificant ? p : bytes.length - p - 2;
                bytes[idx] = (byte)(words[i] >> 8 & 0xFF);
                bytes[idx + 1] = (byte)(words[i] & 0xFF);
                ++i;
                p += 2;
            }
        }
        return bytes;
    }

    public static BigInteger parseUnsignedInteger(short[] words, int offset) {
        return ModbusDataUtils.parseUnsignedInteger(words, offset, ModbusWordOrder.MostToLeastSignificant);
    }

    public static BigInteger parseUnsignedInteger(short[] words, int offset, ModbusWordOrder wordOrder) {
        BigInteger result;
        byte[] bytes = ModbusDataUtils.parseBytes(words, offset, wordOrder);
        if (bytes.length > 0 && bytes[0] != 0) {
            byte[] tmp = new byte[bytes.length + 1];
            System.arraycopy(bytes, 0, tmp, 1, bytes.length);
            bytes = tmp;
        }
        try {
            result = new BigInteger(bytes);
        }
        catch (NumberFormatException e) {
            result = BigInteger.ZERO;
        }
        return result;
    }

    public static int wordSize(BitSet bits) {
        int len = bits.length();
        return len / 16 + (len % 16 > 0 ? 1 : 0);
    }

    public static short[] shortArrayForBitSet(BitSet bits, int count, ModbusWordOrder wordOrder) {
        short[] result = new short[count];
        int i = bits.nextSetBit(0);
        while (i >= 0) {
            int pos = wordOrder == ModbusWordOrder.LeastToMostSignificant ? i / 16 : count - i / 16 - 1;
            int bitPos = i % 16;
            if (bits.get(i)) {
                int n = pos;
                result[n] = (short)(result[n] | 1 << bitPos);
            }
            if (i == Integer.MAX_VALUE) break;
            i = bits.nextSetBit(i + 1);
        }
        return result;
    }

    public static short[] shortArrayForBitSet(BitSet bits, int count) {
        return ModbusDataUtils.shortArrayForBitSet(bits, count, ModbusWordOrder.MostToLeastSignificant);
    }

    public static BitSet bitSetForShortArray(short[] words, ModbusWordOrder wordOrder) {
        int size = words != null ? words.length : 0;
        BitSet result = new BitSet(size);
        for (int pos = 0; pos < words.length; ++pos) {
            short w = words[pos];
            for (int i = 0; i < 16; ++i) {
                int bitPos = (wordOrder == ModbusWordOrder.LeastToMostSignificant ? pos * 16 : (size - pos - 1) * 16) + i % 16;
                int bit = w >> i & 1;
                result.set(bitPos, bit == 1);
            }
        }
        return result;
    }

    public static BitSet bitSetForShortArray(short[] words) {
        return ModbusDataUtils.bitSetForShortArray(words, ModbusWordOrder.MostToLeastSignificant);
    }
}

