/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.io.modbus;

import net.solarnetwork.node.io.modbus.ModbusReadFunction;
import net.solarnetwork.node.io.modbus.ModbusRegisterBlockType;
import net.solarnetwork.node.io.modbus.ModbusWriteFunction;

public interface ModbusFunction {
    public int getCode();

    public String toDisplayString();

    public boolean isReadFunction();

    public ModbusFunction oppositeFunction();

    public ModbusRegisterBlockType blockType();

    public static ModbusFunction functionForCode(int code) {
        Enum f;
        try {
            f = ModbusReadFunction.forCode(code);
        }
        catch (IllegalArgumentException e) {
            try {
                f = ModbusWriteFunction.forCode(code);
            }
            catch (IllegalArgumentException e2) {
                throw new IllegalArgumentException("Unknown Modbus function code: " + code);
            }
        }
        return f;
    }
}

