/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.io.modbus;

import net.solarnetwork.node.io.modbus.ModbusFunction;
import net.solarnetwork.node.io.modbus.ModbusRegisterBlockType;
import net.solarnetwork.node.io.modbus.ModbusWriteFunction;

public enum ModbusReadFunction implements ModbusFunction
{
    ReadCoil(1, ModbusRegisterBlockType.Coil),
    ReadDiscreteInput(2, ModbusRegisterBlockType.Discrete),
    ReadHoldingRegister(3, ModbusRegisterBlockType.Holding),
    ReadInputRegister(4, ModbusRegisterBlockType.Input);

    private final int code;
    private final ModbusRegisterBlockType blockType;

    private ModbusReadFunction(int code, ModbusRegisterBlockType blockType) {
        this.code = code;
        this.blockType = blockType;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public String toDisplayString() {
        return this.toString().replaceAll("([a-z])([A-Z])", "$1 $2") + " (" + this.code + ")";
    }

    public static ModbusReadFunction forCode(int code) {
        for (ModbusReadFunction e : ModbusReadFunction.values()) {
            if (code != e.code) continue;
            return e;
        }
        throw new IllegalArgumentException("Unknown ModbusReadFunction code [" + code + "]");
    }

    @Override
    public boolean isReadFunction() {
        return true;
    }

    @Override
    public ModbusFunction oppositeFunction() {
        switch (this) {
            case ReadCoil: {
                return ModbusWriteFunction.WriteCoil;
            }
            case ReadHoldingRegister: {
                return ModbusWriteFunction.WriteHoldingRegister;
            }
        }
        return null;
    }

    @Override
    public ModbusRegisterBlockType blockType() {
        return this.blockType;
    }
}

