/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.io.modbus;

import java.util.Set;
import net.solarnetwork.node.io.modbus.ModbusDataType;
import net.solarnetwork.node.io.modbus.ModbusReadFunction;
import net.solarnetwork.util.IntRangeSet;

public interface ModbusReference {
    public int getAddress();

    public ModbusDataType getDataType();

    public ModbusReadFunction getFunction();

    public int getWordLength();

    public static <T extends Enum<?>> IntRangeSet createAddressSet(Class<T> clazz, Set<String> prefixes) {
        return ModbusReference.createAddressSet((ModbusReference[])clazz.getEnumConstants(), prefixes);
    }

    public static IntRangeSet createAddressSet(ModbusReference[] refs, Set<String> prefixes) {
        IntRangeSet set = new IntRangeSet();
        for (ModbusReference r : refs) {
            int len;
            if (prefixes != null) {
                String name = r.toString();
                boolean found = false;
                for (String prefix : prefixes) {
                    if (!name.startsWith(prefix)) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
            }
            if ((len = r.getWordLength()) <= 0) continue;
            set.addRange(r.getAddress(), r.getAddress() + len - 1);
        }
        return set;
    }
}

