/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.io.modbus;

import net.solarnetwork.domain.CodedValue;

public enum ModbusRegisterBlockType implements CodedValue
{
    Coil(1, 1, true, false),
    Discrete(2, 1, true, true),
    Holding(3, 16, false, false),
    Input(4, 16, false, true);

    private final int code;
    private final int bitCount;
    private final boolean bitType;
    private final boolean readOnly;

    private ModbusRegisterBlockType(int code, int bitCount, boolean bitType, boolean readOnly) {
        this.code = code;
        this.bitCount = bitCount;
        this.bitType = bitType;
        this.readOnly = readOnly;
    }

    public int getCode() {
        return this.code;
    }

    public int getBitCount() {
        return this.bitCount;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isBitType() {
        return this.bitType;
    }

    public static ModbusRegisterBlockType forCode(int code) {
        switch (code) {
            case 1: {
                return Coil;
            }
            case 2: {
                return Discrete;
            }
            case 3: {
                return Holding;
            }
            case 4: {
                return Input;
            }
        }
        throw new IllegalArgumentException("ModbusRegisterBlockType code [" + code + "] not supported.");
    }
}

