/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.io.modbus;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.time.Instant;
import java.util.Arrays;
import java.util.BitSet;
import java.util.function.Function;
import net.solarnetwork.node.io.modbus.ModbusData;
import net.solarnetwork.node.io.modbus.ModbusDataType;
import net.solarnetwork.node.io.modbus.ModbusDataUtils;
import net.solarnetwork.node.io.modbus.ModbusRegisterBlockType;
import net.solarnetwork.node.io.modbus.ModbusWordOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModbusRegisterData {
    private static final Logger log = LoggerFactory.getLogger(ModbusRegisterData.class);
    private final BitSet coils;
    private long coilsTimestamp;
    private final BitSet discretes;
    private long discretesTimestamp;
    private final ModbusData inputs;
    private final ModbusData holdings;

    public ModbusRegisterData() {
        this(new BitSet(), new BitSet(), new ModbusData(), new ModbusData());
    }

    public ModbusRegisterData(BitSet coils, BitSet discretes, ModbusData holdings, ModbusData inputs) {
        this.coils = coils != null ? coils : new BitSet();
        this.discretes = discretes != null ? discretes : new BitSet();
        this.holdings = holdings != null ? holdings : new ModbusData();
        this.inputs = inputs != null ? inputs : new ModbusData();
        this.coilsTimestamp = 0L;
        this.discretesTimestamp = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModbusRegisterData(ModbusRegisterData other) {
        BitSet bitSet = other.coils;
        synchronized (bitSet) {
            this.coils = (BitSet)other.coils.clone();
            this.coilsTimestamp = other.coilsTimestamp;
        }
        bitSet = other.discretes;
        synchronized (bitSet) {
            this.discretes = (BitSet)other.discretes.clone();
            this.discretesTimestamp = other.discretesTimestamp;
        }
        this.holdings = other.holdings.copy();
        this.inputs = other.inputs.copy();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ModbusRegisterData{coilsTimestamp=");
        builder.append(this.coilsTimestamp);
        builder.append(", ");
        if (this.coils != null) {
            builder.append("coils=");
            builder.append(this.coils);
            builder.append(", ");
        }
        builder.append("discretesTimestamp=");
        builder.append(this.discretesTimestamp);
        builder.append(", ");
        if (this.discretes != null) {
            builder.append("discretes=");
            builder.append(this.discretes);
            builder.append(", ");
        }
        if (this.inputs != null) {
            builder.append("inputs=");
            builder.append(this.inputs);
            builder.append(", ");
        }
        if (this.holdings != null) {
            builder.append("holdings=");
            builder.append(this.holdings);
        }
        builder.append("}");
        return builder.toString();
    }

    public ModbusRegisterData copy() {
        return new ModbusRegisterData(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        BitSet bitSet = this.coils;
        synchronized (bitSet) {
            if (!this.coils.isEmpty()) {
                return false;
            }
        }
        bitSet = this.discretes;
        synchronized (bitSet) {
            if (!this.discretes.isEmpty()) {
                return false;
            }
        }
        if (!this.holdings.isEmpty()) {
            return false;
        }
        return this.inputs.isEmpty();
    }

    public boolean hasRegisterData() {
        return !this.holdings.isEmpty() || !this.inputs.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Instant getDataTimestamp(ModbusRegisterBlockType blockType) {
        long ts = 0L;
        switch (blockType) {
            case Coil: {
                BitSet bitSet = this.coils;
                synchronized (bitSet) {
                    ts = this.coilsTimestamp;
                    break;
                }
            }
            case Discrete: {
                BitSet bitSet = this.discretes;
                synchronized (bitSet) {
                    ts = this.discretesTimestamp;
                    break;
                }
            }
            case Holding: {
                return this.holdings.getDataTimestamp();
            }
            case Input: {
                return this.inputs.getDataTimestamp();
            }
        }
        return ts > 0L ? Instant.ofEpochMilli(ts) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void expire(ModbusRegisterBlockType blockType) {
        switch (blockType) {
            case Coil: {
                BitSet bitSet = this.coils;
                synchronized (bitSet) {
                    this.coilsTimestamp = 0L;
                    break;
                }
            }
            case Discrete: {
                BitSet bitSet = this.discretes;
                synchronized (bitSet) {
                    this.discretesTimestamp = 0L;
                    break;
                }
            }
            case Holding: {
                this.holdings.expire();
            }
            case Input: {
                this.inputs.expire();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isOlderThan(ModbusRegisterBlockType blockType, long date) {
        long ts = 0L;
        Instant inst = null;
        switch (blockType) {
            case Coil: {
                BitSet bitSet = this.coils;
                synchronized (bitSet) {
                    ts = this.coilsTimestamp;
                    break;
                }
            }
            case Discrete: {
                BitSet bitSet = this.discretes;
                synchronized (bitSet) {
                    ts = this.discretesTimestamp;
                    break;
                }
            }
            case Holding: {
                inst = this.holdings.getDataTimestamp();
            }
            case Input: {
                inst = this.inputs.getDataTimestamp();
            }
        }
        if (inst != null) {
            return inst.toEpochMilli() < date;
        }
        return ts < date;
    }

    public ModbusWordOrder getWordOrder() {
        return this.holdings.getWordOrder();
    }

    public void setWordOrder(ModbusWordOrder order) {
        this.holdings.setWordOrder(order);
        this.inputs.setWordOrder(order);
    }

    public void writeBit(ModbusRegisterBlockType blockType, int address, boolean value) {
        switch (blockType) {
            case Coil: {
                this.writeCoil(address, value);
                break;
            }
            case Discrete: {
                this.writeDiscrete(address, value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot write bit value to block type " + (Object)((Object)blockType));
            }
        }
    }

    public void writeBits(ModbusRegisterBlockType blockType, int address, int count, BitSet set) {
        switch (blockType) {
            case Coil: {
                this.writeCoils(address, count, set);
                break;
            }
            case Discrete: {
                this.writeDiscretes(address, count, set);
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot write bit values to block type " + (Object)((Object)blockType));
            }
        }
    }

    public void writeValue(ModbusRegisterBlockType blockType, ModbusDataType dataType, int address, int count, Object value) {
        short[] dataValue = this.encodeValue(dataType, address, count, value);
        this.writeRegisters(blockType, address, dataValue);
    }

    public void writeRegisters(ModbusRegisterBlockType blockType, int address, short[] dataValue) {
        if (dataValue == null || dataValue.length < 1) {
            return;
        }
        switch (blockType) {
            case Holding: {
                this.writeHoldings(address, dataValue);
                break;
            }
            case Input: {
                this.writeInputs(address, dataValue);
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot write value value to block type " + (Object)((Object)blockType));
            }
        }
    }

    private short[] encodeValue(ModbusDataType dataType, int address, int count, Object value) {
        if (value == null) {
            return null;
        }
        short[] result = null;
        switch (dataType) {
            case Bytes: {
                if (!(value instanceof byte[])) break;
                result = ModbusRegisterData.limitLength(ModbusDataUtils.encodeBytes((byte[])value, this.getWordOrder()), count);
                break;
            }
            case StringAscii: 
            case StringUtf8: {
                try {
                    byte[] strBytes = dataType == ModbusDataType.StringAscii ? value.toString().getBytes("US-ASCII") : value.toString().getBytes("UTF-8");
                    result = ModbusRegisterData.limitLength(ModbusDataUtils.encodeBytes(strBytes, this.getWordOrder()), count);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
                break;
            }
            default: {
                if (!(value instanceof Number)) break;
                result = ModbusDataUtils.encodeNumber(dataType, (Number)value, this.getWordOrder());
            }
        }
        return result;
    }

    private static short[] limitLength(short[] array, int max) {
        if (array == null || array.length <= max) {
            return array;
        }
        short[] truncated = new short[max];
        System.arraycopy(array, 0, truncated, 0, max);
        return truncated;
    }

    public BitSet readCoils(int address, int count) {
        return this.readBits(address, count, this.coils);
    }

    public void writeCoil(int address, boolean value) {
        this.writeBit(address, value, this.coils);
    }

    public void writeCoils(int address, int count, BitSet set) {
        this.writeBits(address, count, set, this.coils);
    }

    public void writeDiscrete(int address, boolean value) {
        this.writeBit(address, value, this.discretes);
    }

    public void writeDiscretes(int address, int count, BitSet set) {
        this.writeBits(address, count, set, this.discretes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBit(int address, boolean value, BitSet set) {
        BitSet bitSet = set;
        synchronized (bitSet) {
            set.set(address, value);
            if (set == this.coils) {
                this.coilsTimestamp = System.currentTimeMillis();
            } else {
                this.discretesTimestamp = System.currentTimeMillis();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBits(int address, int count, BitSet values, BitSet set) {
        BitSet bitSet = set;
        synchronized (bitSet) {
            for (int i = 0; i < count; ++i) {
                set.set(address + i, set.get(i));
            }
            if (set == this.coils) {
                this.coilsTimestamp = System.currentTimeMillis();
            } else {
                this.discretesTimestamp = System.currentTimeMillis();
            }
        }
    }

    public BitSet readDiscretes(int address, int count) {
        return this.readBits(address, count, this.discretes);
    }

    public byte[] readHoldings(int address, int count) {
        return this.readBytes(address, count, this.holdings);
    }

    public byte[] readInputs(int address, int count) {
        return this.readBytes(address, count, this.inputs);
    }

    public <T> T readRegisters(ModbusRegisterBlockType blockType, Function<ModbusData, T> action) {
        ModbusData data = null;
        switch (blockType) {
            case Holding: {
                data = this.holdings.copy();
                break;
            }
            case Input: {
                data = this.inputs.copy();
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot read value from block type " + (Object)((Object)blockType));
            }
        }
        return action.apply(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T readBits(ModbusRegisterBlockType blockType, Function<BitSet, T> action) {
        BitSet data = null;
        switch (blockType) {
            case Coil: {
                data = this.coils;
                break;
            }
            case Discrete: {
                data = this.discretes;
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot read bits from block type " + (Object)((Object)blockType));
            }
        }
        BitSet bitSet = data;
        synchronized (bitSet) {
            return action.apply(data);
        }
    }

    public void writeHolding(int address, short value) {
        this.writeHoldings(address, new short[]{value});
    }

    public void writeHoldings(int address, short[] values) {
        if (log.isDebugEnabled()) {
            log.debug("Writing Holding registers {}-{} values: {}", new Object[]{address, address + values.length - 1, Arrays.toString(ModbusRegisterData.hexValues(values))});
        }
        this.writeRegisters(address, values, this.holdings);
    }

    private static String[] hexValues(short[] values) {
        if (values == null) {
            return null;
        }
        String[] result = new String[values.length];
        int len = values.length;
        for (int i = 0; i < len; ++i) {
            result[i] = String.format("0x%04x", values[i]);
        }
        return result;
    }

    public void writeInput(int address, short value) {
        this.writeInputs(address, new short[]{value});
    }

    public void writeInputs(int address, short[] values) {
        if (log.isDebugEnabled()) {
            log.debug("Writing Input registers {}-{} values: {}", new Object[]{address, address + values.length - 1, Arrays.toString(ModbusRegisterData.hexValues(values))});
        }
        this.writeRegisters(address, values, this.inputs);
    }

    private void writeRegisters(final int address, final short[] values, ModbusData data) {
        try {
            data.performUpdates(new ModbusData.ModbusDataUpdateAction(){

                @Override
                public boolean updateModbusData(ModbusData.MutableModbusData m) {
                    m.saveDataArray(values, address);
                    return true;
                }
            });
        }
        catch (IOException e) {
            log.error("Error writing register {} data: {}", new Object[]{address, Arrays.toString(values), e});
        }
    }

    public final ModbusData performRegisterUpdates(ModbusRegisterBlockType blockType, ModbusData.ModbusDataUpdateAction action) throws IOException {
        ModbusData d;
        switch (blockType) {
            case Holding: {
                d = this.holdings;
                break;
            }
            case Input: {
                d = this.inputs;
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot perform register updates to block type " + (Object)((Object)blockType));
            }
        }
        return d.performUpdates(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void performBitUpdates(ModbusRegisterBlockType blockType, ModbusBitsUpdateAction action) throws IOException {
        BitSet bits;
        switch (blockType) {
            case Coil: {
                bits = this.coils;
                break;
            }
            case Discrete: {
                bits = this.discretes;
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot perform bit updates to block type " + (Object)((Object)blockType));
            }
        }
        BitSet bitSet = bits;
        synchronized (bitSet) {
            boolean result = action.updateModbusBits(bits);
            if (result) {
                if (blockType == ModbusRegisterBlockType.Coil) {
                    this.coilsTimestamp = System.currentTimeMillis();
                } else {
                    this.discretesTimestamp = System.currentTimeMillis();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BitSet readBits(int address, int count, BitSet set) {
        BitSet result = new BitSet();
        BitSet bitSet = set;
        synchronized (bitSet) {
            int a = address;
            int len = count;
            for (int i = 0; i < len; ++i) {
                result.set(i, set.get(a));
                ++a;
            }
        }
        return result;
    }

    private byte[] readBytes(final int address, final int count, final ModbusData data) {
        final byte[] result = new byte[count * 2];
        try {
            data.performUpdates(new ModbusData.ModbusDataUpdateAction(){

                @Override
                public boolean updateModbusData(ModbusData.MutableModbusData m) {
                    int len = count;
                    for (int i = 0; i < len; ++i) {
                        System.arraycopy(data.getBytes(i + address, 2), 0, result, i * 2, 2);
                    }
                    return true;
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public BitSet getCoils() {
        return this.coils;
    }

    public BitSet getDiscretes() {
        return this.discretes;
    }

    public ModbusData getInputs() {
        return this.inputs;
    }

    public ModbusData getHoldings() {
        return this.holdings;
    }

    public static interface ModbusBitsUpdateAction {
        public boolean updateModbusBits(BitSet var1) throws IOException;
    }
}

