/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.io.modbus;

public enum ModbusWordOrder {
    MostToLeastSignificant('m'),
    LeastToMostSignificant('l');

    private final char key;

    private ModbusWordOrder(char key) {
        this.key = key;
    }

    public char getKey() {
        return this.key;
    }

    public static ModbusWordOrder forKey(char key) {
        for (ModbusWordOrder e : ModbusWordOrder.values()) {
            if (key != e.key) continue;
            return e;
        }
        throw new IllegalArgumentException("Unknown ModbusWordOrder key [" + key + "]");
    }

    public String toDisplayString() {
        switch (this) {
            case MostToLeastSignificant: {
                return "Most significant word first";
            }
            case LeastToMostSignificant: {
                return "Least significant word first";
            }
        }
        return this.toString();
    }
}

